/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.shield.ShieldAsyncClient;
import software.amazon.awssdk.services.shield.internal.UserAgentUtils;
import software.amazon.awssdk.services.shield.model.ListResourcesInProtectionGroupRequest;
import software.amazon.awssdk.services.shield.model.ListResourcesInProtectionGroupResponse;

public class ListResourcesInProtectionGroupPublisher
implements SdkPublisher<ListResourcesInProtectionGroupResponse> {
    private final ShieldAsyncClient client;
    private final ListResourcesInProtectionGroupRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResourcesInProtectionGroupPublisher(ShieldAsyncClient client, ListResourcesInProtectionGroupRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResourcesInProtectionGroupPublisher(ShieldAsyncClient client, ListResourcesInProtectionGroupRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResourcesInProtectionGroupResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResourcesInProtectionGroupResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListResourcesInProtectionGroupResponseFetcher
    implements AsyncPageFetcher<ListResourcesInProtectionGroupResponse> {
        private ListResourcesInProtectionGroupResponseFetcher() {
        }

        public boolean hasNextPage(ListResourcesInProtectionGroupResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResourcesInProtectionGroupResponse> nextPage(ListResourcesInProtectionGroupResponse previousPage) {
            if (previousPage == null) {
                return ListResourcesInProtectionGroupPublisher.this.client.listResourcesInProtectionGroup(ListResourcesInProtectionGroupPublisher.this.firstRequest);
            }
            return ListResourcesInProtectionGroupPublisher.this.client.listResourcesInProtectionGroup((ListResourcesInProtectionGroupRequest)((Object)ListResourcesInProtectionGroupPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

