/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppSummary implements SdkPojo, Serializable, ToCopyableBuilder<AppSummary.Builder, AppSummary> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appId")
            .getter(getter(AppSummary::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()).build();

    private static final SdkField<String> IMPORTED_APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importedAppId").getter(getter(AppSummary::importedAppId)).setter(setter(Builder::importedAppId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importedAppId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AppSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AppSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(AppSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(AppSummary::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<String> REPLICATION_CONFIGURATION_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("replicationConfigurationStatus")
            .getter(getter(AppSummary::replicationConfigurationStatusAsString))
            .setter(setter(Builder::replicationConfigurationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationConfigurationStatus")
                    .build()).build();

    private static final SdkField<String> REPLICATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("replicationStatus").getter(getter(AppSummary::replicationStatusAsString))
            .setter(setter(Builder::replicationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationStatus").build()).build();

    private static final SdkField<String> REPLICATION_STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("replicationStatusMessage").getter(getter(AppSummary::replicationStatusMessage))
            .setter(setter(Builder::replicationStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationStatusMessage").build())
            .build();

    private static final SdkField<Instant> LATEST_REPLICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("latestReplicationTime").getter(getter(AppSummary::latestReplicationTime))
            .setter(setter(Builder::latestReplicationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestReplicationTime").build())
            .build();

    private static final SdkField<String> LAUNCH_CONFIGURATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("launchConfigurationStatus").getter(getter(AppSummary::launchConfigurationStatusAsString))
            .setter(setter(Builder::launchConfigurationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchConfigurationStatus").build())
            .build();

    private static final SdkField<String> LAUNCH_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("launchStatus").getter(getter(AppSummary::launchStatusAsString)).setter(setter(Builder::launchStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchStatus").build()).build();

    private static final SdkField<String> LAUNCH_STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("launchStatusMessage").getter(getter(AppSummary::launchStatusMessage))
            .setter(setter(Builder::launchStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchStatusMessage").build())
            .build();

    private static final SdkField<LaunchDetails> LAUNCH_DETAILS_FIELD = SdkField
            .<LaunchDetails> builder(MarshallingType.SDK_POJO).memberName("launchDetails")
            .getter(getter(AppSummary::launchDetails)).setter(setter(Builder::launchDetails)).constructor(LaunchDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchDetails").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(AppSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModified").getter(getter(AppSummary::lastModified)).setter(setter(Builder::lastModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModified").build()).build();

    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleName").getter(getter(AppSummary::roleName)).setter(setter(Builder::roleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleName").build()).build();

    private static final SdkField<Integer> TOTAL_SERVER_GROUPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalServerGroups").getter(getter(AppSummary::totalServerGroups))
            .setter(setter(Builder::totalServerGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalServerGroups").build()).build();

    private static final SdkField<Integer> TOTAL_SERVERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalServers").getter(getter(AppSummary::totalServers)).setter(setter(Builder::totalServers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalServers").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD,
            IMPORTED_APP_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD,
            REPLICATION_CONFIGURATION_STATUS_FIELD, REPLICATION_STATUS_FIELD, REPLICATION_STATUS_MESSAGE_FIELD,
            LATEST_REPLICATION_TIME_FIELD, LAUNCH_CONFIGURATION_STATUS_FIELD, LAUNCH_STATUS_FIELD, LAUNCH_STATUS_MESSAGE_FIELD,
            LAUNCH_DETAILS_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_FIELD, ROLE_NAME_FIELD, TOTAL_SERVER_GROUPS_FIELD,
            TOTAL_SERVERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String appId;

    private final String importedAppId;

    private final String name;

    private final String description;

    private final String status;

    private final String statusMessage;

    private final String replicationConfigurationStatus;

    private final String replicationStatus;

    private final String replicationStatusMessage;

    private final Instant latestReplicationTime;

    private final String launchConfigurationStatus;

    private final String launchStatus;

    private final String launchStatusMessage;

    private final LaunchDetails launchDetails;

    private final Instant creationTime;

    private final Instant lastModified;

    private final String roleName;

    private final Integer totalServerGroups;

    private final Integer totalServers;

    private AppSummary(BuilderImpl builder) {
        this.appId = builder.appId;
        this.importedAppId = builder.importedAppId;
        this.name = builder.name;
        this.description = builder.description;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.replicationConfigurationStatus = builder.replicationConfigurationStatus;
        this.replicationStatus = builder.replicationStatus;
        this.replicationStatusMessage = builder.replicationStatusMessage;
        this.latestReplicationTime = builder.latestReplicationTime;
        this.launchConfigurationStatus = builder.launchConfigurationStatus;
        this.launchStatus = builder.launchStatus;
        this.launchStatusMessage = builder.launchStatusMessage;
        this.launchDetails = builder.launchDetails;
        this.creationTime = builder.creationTime;
        this.lastModified = builder.lastModified;
        this.roleName = builder.roleName;
        this.totalServerGroups = builder.totalServerGroups;
        this.totalServers = builder.totalServers;
    }

    /**
     * <p>
     * The unique ID of the application.
     * </p>
     * 
     * @return The unique ID of the application.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * The ID of the application.
     * </p>
     * 
     * @return The ID of the application.
     */
    public final String importedAppId() {
        return importedAppId;
    }

    /**
     * <p>
     * The name of the application.
     * </p>
     * 
     * @return The name of the application.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the application.
     * </p>
     * 
     * @return The description of the application.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AppStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the application.
     * @see AppStatus
     */
    public final AppStatus status() {
        return AppStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AppStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the application.
     * @see AppStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A message related to the status of the application
     * </p>
     * 
     * @return A message related to the status of the application
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * Status of the replication configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #replicationConfigurationStatus} will return
     * {@link AppReplicationConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #replicationConfigurationStatusAsString}.
     * </p>
     * 
     * @return Status of the replication configuration.
     * @see AppReplicationConfigurationStatus
     */
    public final AppReplicationConfigurationStatus replicationConfigurationStatus() {
        return AppReplicationConfigurationStatus.fromValue(replicationConfigurationStatus);
    }

    /**
     * <p>
     * Status of the replication configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #replicationConfigurationStatus} will return
     * {@link AppReplicationConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #replicationConfigurationStatusAsString}.
     * </p>
     * 
     * @return Status of the replication configuration.
     * @see AppReplicationConfigurationStatus
     */
    public final String replicationConfigurationStatusAsString() {
        return replicationConfigurationStatus;
    }

    /**
     * <p>
     * The replication status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicationStatus}
     * will return {@link AppReplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #replicationStatusAsString}.
     * </p>
     * 
     * @return The replication status of the application.
     * @see AppReplicationStatus
     */
    public final AppReplicationStatus replicationStatus() {
        return AppReplicationStatus.fromValue(replicationStatus);
    }

    /**
     * <p>
     * The replication status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicationStatus}
     * will return {@link AppReplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #replicationStatusAsString}.
     * </p>
     * 
     * @return The replication status of the application.
     * @see AppReplicationStatus
     */
    public final String replicationStatusAsString() {
        return replicationStatus;
    }

    /**
     * <p>
     * A message related to the replication status of the application.
     * </p>
     * 
     * @return A message related to the replication status of the application.
     */
    public final String replicationStatusMessage() {
        return replicationStatusMessage;
    }

    /**
     * <p>
     * The timestamp of the application's most recent successful replication.
     * </p>
     * 
     * @return The timestamp of the application's most recent successful replication.
     */
    public final Instant latestReplicationTime() {
        return latestReplicationTime;
    }

    /**
     * <p>
     * Status of the launch configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #launchConfigurationStatus} will return {@link AppLaunchConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #launchConfigurationStatusAsString}.
     * </p>
     * 
     * @return Status of the launch configuration.
     * @see AppLaunchConfigurationStatus
     */
    public final AppLaunchConfigurationStatus launchConfigurationStatus() {
        return AppLaunchConfigurationStatus.fromValue(launchConfigurationStatus);
    }

    /**
     * <p>
     * Status of the launch configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #launchConfigurationStatus} will return {@link AppLaunchConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #launchConfigurationStatusAsString}.
     * </p>
     * 
     * @return Status of the launch configuration.
     * @see AppLaunchConfigurationStatus
     */
    public final String launchConfigurationStatusAsString() {
        return launchConfigurationStatus;
    }

    /**
     * <p>
     * The launch status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchStatus} will
     * return {@link AppLaunchStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #launchStatusAsString}.
     * </p>
     * 
     * @return The launch status of the application.
     * @see AppLaunchStatus
     */
    public final AppLaunchStatus launchStatus() {
        return AppLaunchStatus.fromValue(launchStatus);
    }

    /**
     * <p>
     * The launch status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchStatus} will
     * return {@link AppLaunchStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #launchStatusAsString}.
     * </p>
     * 
     * @return The launch status of the application.
     * @see AppLaunchStatus
     */
    public final String launchStatusAsString() {
        return launchStatus;
    }

    /**
     * <p>
     * A message related to the launch status of the application.
     * </p>
     * 
     * @return A message related to the launch status of the application.
     */
    public final String launchStatusMessage() {
        return launchStatusMessage;
    }

    /**
     * <p>
     * Details about the latest launch of the application.
     * </p>
     * 
     * @return Details about the latest launch of the application.
     */
    public final LaunchDetails launchDetails() {
        return launchDetails;
    }

    /**
     * <p>
     * The creation time of the application.
     * </p>
     * 
     * @return The creation time of the application.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last modified time of the application.
     * </p>
     * 
     * @return The last modified time of the application.
     */
    public final Instant lastModified() {
        return lastModified;
    }

    /**
     * <p>
     * The name of the service role in the customer's account used by Server Migration Service.
     * </p>
     * 
     * @return The name of the service role in the customer's account used by Server Migration Service.
     */
    public final String roleName() {
        return roleName;
    }

    /**
     * <p>
     * The number of server groups present in the application.
     * </p>
     * 
     * @return The number of server groups present in the application.
     */
    public final Integer totalServerGroups() {
        return totalServerGroups;
    }

    /**
     * <p>
     * The number of servers present in the application.
     * </p>
     * 
     * @return The number of servers present in the application.
     */
    public final Integer totalServers() {
        return totalServers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(importedAppId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(replicationConfigurationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(replicationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(replicationStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(latestReplicationTime());
        hashCode = 31 * hashCode + Objects.hashCode(launchConfigurationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(launchStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(launchStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(launchDetails());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(roleName());
        hashCode = 31 * hashCode + Objects.hashCode(totalServerGroups());
        hashCode = 31 * hashCode + Objects.hashCode(totalServers());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppSummary)) {
            return false;
        }
        AppSummary other = (AppSummary) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(importedAppId(), other.importedAppId())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(replicationConfigurationStatusAsString(), other.replicationConfigurationStatusAsString())
                && Objects.equals(replicationStatusAsString(), other.replicationStatusAsString())
                && Objects.equals(replicationStatusMessage(), other.replicationStatusMessage())
                && Objects.equals(latestReplicationTime(), other.latestReplicationTime())
                && Objects.equals(launchConfigurationStatusAsString(), other.launchConfigurationStatusAsString())
                && Objects.equals(launchStatusAsString(), other.launchStatusAsString())
                && Objects.equals(launchStatusMessage(), other.launchStatusMessage())
                && Objects.equals(launchDetails(), other.launchDetails()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModified(), other.lastModified()) && Objects.equals(roleName(), other.roleName())
                && Objects.equals(totalServerGroups(), other.totalServerGroups())
                && Objects.equals(totalServers(), other.totalServers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppSummary").add("AppId", appId()).add("ImportedAppId", importedAppId()).add("Name", name())
                .add("Description", description()).add("Status", statusAsString()).add("StatusMessage", statusMessage())
                .add("ReplicationConfigurationStatus", replicationConfigurationStatusAsString())
                .add("ReplicationStatus", replicationStatusAsString())
                .add("ReplicationStatusMessage", replicationStatusMessage())
                .add("LatestReplicationTime", latestReplicationTime())
                .add("LaunchConfigurationStatus", launchConfigurationStatusAsString())
                .add("LaunchStatus", launchStatusAsString()).add("LaunchStatusMessage", launchStatusMessage())
                .add("LaunchDetails", launchDetails()).add("CreationTime", creationTime()).add("LastModified", lastModified())
                .add("RoleName", roleName()).add("TotalServerGroups", totalServerGroups()).add("TotalServers", totalServers())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "importedAppId":
            return Optional.ofNullable(clazz.cast(importedAppId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "replicationConfigurationStatus":
            return Optional.ofNullable(clazz.cast(replicationConfigurationStatusAsString()));
        case "replicationStatus":
            return Optional.ofNullable(clazz.cast(replicationStatusAsString()));
        case "replicationStatusMessage":
            return Optional.ofNullable(clazz.cast(replicationStatusMessage()));
        case "latestReplicationTime":
            return Optional.ofNullable(clazz.cast(latestReplicationTime()));
        case "launchConfigurationStatus":
            return Optional.ofNullable(clazz.cast(launchConfigurationStatusAsString()));
        case "launchStatus":
            return Optional.ofNullable(clazz.cast(launchStatusAsString()));
        case "launchStatusMessage":
            return Optional.ofNullable(clazz.cast(launchStatusMessage()));
        case "launchDetails":
            return Optional.ofNullable(clazz.cast(launchDetails()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastModified":
            return Optional.ofNullable(clazz.cast(lastModified()));
        case "roleName":
            return Optional.ofNullable(clazz.cast(roleName()));
        case "totalServerGroups":
            return Optional.ofNullable(clazz.cast(totalServerGroups()));
        case "totalServers":
            return Optional.ofNullable(clazz.cast(totalServers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("appId", APP_ID_FIELD);
        map.put("importedAppId", IMPORTED_APP_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        map.put("replicationConfigurationStatus", REPLICATION_CONFIGURATION_STATUS_FIELD);
        map.put("replicationStatus", REPLICATION_STATUS_FIELD);
        map.put("replicationStatusMessage", REPLICATION_STATUS_MESSAGE_FIELD);
        map.put("latestReplicationTime", LATEST_REPLICATION_TIME_FIELD);
        map.put("launchConfigurationStatus", LAUNCH_CONFIGURATION_STATUS_FIELD);
        map.put("launchStatus", LAUNCH_STATUS_FIELD);
        map.put("launchStatusMessage", LAUNCH_STATUS_MESSAGE_FIELD);
        map.put("launchDetails", LAUNCH_DETAILS_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastModified", LAST_MODIFIED_FIELD);
        map.put("roleName", ROLE_NAME_FIELD);
        map.put("totalServerGroups", TOTAL_SERVER_GROUPS_FIELD);
        map.put("totalServers", TOTAL_SERVERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppSummary, T> g) {
        return obj -> g.apply((AppSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppSummary> {
        /**
         * <p>
         * The unique ID of the application.
         * </p>
         * 
         * @param appId
         *        The unique ID of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The ID of the application.
         * </p>
         * 
         * @param importedAppId
         *        The ID of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importedAppId(String importedAppId);

        /**
         * <p>
         * The name of the application.
         * </p>
         * 
         * @param name
         *        The name of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the application.
         * </p>
         * 
         * @param description
         *        The description of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Status of the application.
         * </p>
         * 
         * @param status
         *        Status of the application.
         * @see AppStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the application.
         * </p>
         * 
         * @param status
         *        Status of the application.
         * @see AppStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppStatus
         */
        Builder status(AppStatus status);

        /**
         * <p>
         * A message related to the status of the application
         * </p>
         * 
         * @param statusMessage
         *        A message related to the status of the application
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * Status of the replication configuration.
         * </p>
         * 
         * @param replicationConfigurationStatus
         *        Status of the replication configuration.
         * @see AppReplicationConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppReplicationConfigurationStatus
         */
        Builder replicationConfigurationStatus(String replicationConfigurationStatus);

        /**
         * <p>
         * Status of the replication configuration.
         * </p>
         * 
         * @param replicationConfigurationStatus
         *        Status of the replication configuration.
         * @see AppReplicationConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppReplicationConfigurationStatus
         */
        Builder replicationConfigurationStatus(AppReplicationConfigurationStatus replicationConfigurationStatus);

        /**
         * <p>
         * The replication status of the application.
         * </p>
         * 
         * @param replicationStatus
         *        The replication status of the application.
         * @see AppReplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppReplicationStatus
         */
        Builder replicationStatus(String replicationStatus);

        /**
         * <p>
         * The replication status of the application.
         * </p>
         * 
         * @param replicationStatus
         *        The replication status of the application.
         * @see AppReplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppReplicationStatus
         */
        Builder replicationStatus(AppReplicationStatus replicationStatus);

        /**
         * <p>
         * A message related to the replication status of the application.
         * </p>
         * 
         * @param replicationStatusMessage
         *        A message related to the replication status of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationStatusMessage(String replicationStatusMessage);

        /**
         * <p>
         * The timestamp of the application's most recent successful replication.
         * </p>
         * 
         * @param latestReplicationTime
         *        The timestamp of the application's most recent successful replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestReplicationTime(Instant latestReplicationTime);

        /**
         * <p>
         * Status of the launch configuration.
         * </p>
         * 
         * @param launchConfigurationStatus
         *        Status of the launch configuration.
         * @see AppLaunchConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppLaunchConfigurationStatus
         */
        Builder launchConfigurationStatus(String launchConfigurationStatus);

        /**
         * <p>
         * Status of the launch configuration.
         * </p>
         * 
         * @param launchConfigurationStatus
         *        Status of the launch configuration.
         * @see AppLaunchConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppLaunchConfigurationStatus
         */
        Builder launchConfigurationStatus(AppLaunchConfigurationStatus launchConfigurationStatus);

        /**
         * <p>
         * The launch status of the application.
         * </p>
         * 
         * @param launchStatus
         *        The launch status of the application.
         * @see AppLaunchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppLaunchStatus
         */
        Builder launchStatus(String launchStatus);

        /**
         * <p>
         * The launch status of the application.
         * </p>
         * 
         * @param launchStatus
         *        The launch status of the application.
         * @see AppLaunchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppLaunchStatus
         */
        Builder launchStatus(AppLaunchStatus launchStatus);

        /**
         * <p>
         * A message related to the launch status of the application.
         * </p>
         * 
         * @param launchStatusMessage
         *        A message related to the launch status of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchStatusMessage(String launchStatusMessage);

        /**
         * <p>
         * Details about the latest launch of the application.
         * </p>
         * 
         * @param launchDetails
         *        Details about the latest launch of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchDetails(LaunchDetails launchDetails);

        /**
         * <p>
         * Details about the latest launch of the application.
         * </p>
         * This is a convenience method that creates an instance of the {@link LaunchDetails.Builder} avoiding the need
         * to create one manually via {@link LaunchDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #launchDetails(LaunchDetails)}.
         * 
         * @param launchDetails
         *        a consumer that will call methods on {@link LaunchDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchDetails(LaunchDetails)
         */
        default Builder launchDetails(Consumer<LaunchDetails.Builder> launchDetails) {
            return launchDetails(LaunchDetails.builder().applyMutation(launchDetails).build());
        }

        /**
         * <p>
         * The creation time of the application.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last modified time of the application.
         * </p>
         * 
         * @param lastModified
         *        The last modified time of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(Instant lastModified);

        /**
         * <p>
         * The name of the service role in the customer's account used by Server Migration Service.
         * </p>
         * 
         * @param roleName
         *        The name of the service role in the customer's account used by Server Migration Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleName(String roleName);

        /**
         * <p>
         * The number of server groups present in the application.
         * </p>
         * 
         * @param totalServerGroups
         *        The number of server groups present in the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalServerGroups(Integer totalServerGroups);

        /**
         * <p>
         * The number of servers present in the application.
         * </p>
         * 
         * @param totalServers
         *        The number of servers present in the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalServers(Integer totalServers);
    }

    static final class BuilderImpl implements Builder {
        private String appId;

        private String importedAppId;

        private String name;

        private String description;

        private String status;

        private String statusMessage;

        private String replicationConfigurationStatus;

        private String replicationStatus;

        private String replicationStatusMessage;

        private Instant latestReplicationTime;

        private String launchConfigurationStatus;

        private String launchStatus;

        private String launchStatusMessage;

        private LaunchDetails launchDetails;

        private Instant creationTime;

        private Instant lastModified;

        private String roleName;

        private Integer totalServerGroups;

        private Integer totalServers;

        private BuilderImpl() {
        }

        private BuilderImpl(AppSummary model) {
            appId(model.appId);
            importedAppId(model.importedAppId);
            name(model.name);
            description(model.description);
            status(model.status);
            statusMessage(model.statusMessage);
            replicationConfigurationStatus(model.replicationConfigurationStatus);
            replicationStatus(model.replicationStatus);
            replicationStatusMessage(model.replicationStatusMessage);
            latestReplicationTime(model.latestReplicationTime);
            launchConfigurationStatus(model.launchConfigurationStatus);
            launchStatus(model.launchStatus);
            launchStatusMessage(model.launchStatusMessage);
            launchDetails(model.launchDetails);
            creationTime(model.creationTime);
            lastModified(model.lastModified);
            roleName(model.roleName);
            totalServerGroups(model.totalServerGroups);
            totalServers(model.totalServers);
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getImportedAppId() {
            return importedAppId;
        }

        public final void setImportedAppId(String importedAppId) {
            this.importedAppId = importedAppId;
        }

        @Override
        public final Builder importedAppId(String importedAppId) {
            this.importedAppId = importedAppId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AppStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getReplicationConfigurationStatus() {
            return replicationConfigurationStatus;
        }

        public final void setReplicationConfigurationStatus(String replicationConfigurationStatus) {
            this.replicationConfigurationStatus = replicationConfigurationStatus;
        }

        @Override
        public final Builder replicationConfigurationStatus(String replicationConfigurationStatus) {
            this.replicationConfigurationStatus = replicationConfigurationStatus;
            return this;
        }

        @Override
        public final Builder replicationConfigurationStatus(AppReplicationConfigurationStatus replicationConfigurationStatus) {
            this.replicationConfigurationStatus(replicationConfigurationStatus == null ? null : replicationConfigurationStatus
                    .toString());
            return this;
        }

        public final String getReplicationStatus() {
            return replicationStatus;
        }

        public final void setReplicationStatus(String replicationStatus) {
            this.replicationStatus = replicationStatus;
        }

        @Override
        public final Builder replicationStatus(String replicationStatus) {
            this.replicationStatus = replicationStatus;
            return this;
        }

        @Override
        public final Builder replicationStatus(AppReplicationStatus replicationStatus) {
            this.replicationStatus(replicationStatus == null ? null : replicationStatus.toString());
            return this;
        }

        public final String getReplicationStatusMessage() {
            return replicationStatusMessage;
        }

        public final void setReplicationStatusMessage(String replicationStatusMessage) {
            this.replicationStatusMessage = replicationStatusMessage;
        }

        @Override
        public final Builder replicationStatusMessage(String replicationStatusMessage) {
            this.replicationStatusMessage = replicationStatusMessage;
            return this;
        }

        public final Instant getLatestReplicationTime() {
            return latestReplicationTime;
        }

        public final void setLatestReplicationTime(Instant latestReplicationTime) {
            this.latestReplicationTime = latestReplicationTime;
        }

        @Override
        public final Builder latestReplicationTime(Instant latestReplicationTime) {
            this.latestReplicationTime = latestReplicationTime;
            return this;
        }

        public final String getLaunchConfigurationStatus() {
            return launchConfigurationStatus;
        }

        public final void setLaunchConfigurationStatus(String launchConfigurationStatus) {
            this.launchConfigurationStatus = launchConfigurationStatus;
        }

        @Override
        public final Builder launchConfigurationStatus(String launchConfigurationStatus) {
            this.launchConfigurationStatus = launchConfigurationStatus;
            return this;
        }

        @Override
        public final Builder launchConfigurationStatus(AppLaunchConfigurationStatus launchConfigurationStatus) {
            this.launchConfigurationStatus(launchConfigurationStatus == null ? null : launchConfigurationStatus.toString());
            return this;
        }

        public final String getLaunchStatus() {
            return launchStatus;
        }

        public final void setLaunchStatus(String launchStatus) {
            this.launchStatus = launchStatus;
        }

        @Override
        public final Builder launchStatus(String launchStatus) {
            this.launchStatus = launchStatus;
            return this;
        }

        @Override
        public final Builder launchStatus(AppLaunchStatus launchStatus) {
            this.launchStatus(launchStatus == null ? null : launchStatus.toString());
            return this;
        }

        public final String getLaunchStatusMessage() {
            return launchStatusMessage;
        }

        public final void setLaunchStatusMessage(String launchStatusMessage) {
            this.launchStatusMessage = launchStatusMessage;
        }

        @Override
        public final Builder launchStatusMessage(String launchStatusMessage) {
            this.launchStatusMessage = launchStatusMessage;
            return this;
        }

        public final LaunchDetails.Builder getLaunchDetails() {
            return launchDetails != null ? launchDetails.toBuilder() : null;
        }

        public final void setLaunchDetails(LaunchDetails.BuilderImpl launchDetails) {
            this.launchDetails = launchDetails != null ? launchDetails.build() : null;
        }

        @Override
        public final Builder launchDetails(LaunchDetails launchDetails) {
            this.launchDetails = launchDetails;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModified() {
            return lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final String getRoleName() {
            return roleName;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final Integer getTotalServerGroups() {
            return totalServerGroups;
        }

        public final void setTotalServerGroups(Integer totalServerGroups) {
            this.totalServerGroups = totalServerGroups;
        }

        @Override
        public final Builder totalServerGroups(Integer totalServerGroups) {
            this.totalServerGroups = totalServerGroups;
            return this;
        }

        public final Integer getTotalServers() {
            return totalServers;
        }

        public final void setTotalServers(Integer totalServers) {
            this.totalServers = totalServers;
        }

        @Override
        public final Builder totalServers(Integer totalServers) {
            this.totalServers = totalServers;
            return this;
        }

        @Override
        public AppSummary build() {
            return new AppSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
