/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains validation parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SSMValidationParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<SSMValidationParameters.Builder, SSMValidationParameters> {
    private static final SdkField<Source> SOURCE_FIELD = SdkField.<Source> builder(MarshallingType.SDK_POJO).memberName("source")
            .getter(getter(SSMValidationParameters::source)).setter(setter(Builder::source)).constructor(Source::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceId").getter(getter(SSMValidationParameters::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceId").build()).build();

    private static final SdkField<String> SCRIPT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scriptType").getter(getter(SSMValidationParameters::scriptTypeAsString))
            .setter(setter(Builder::scriptType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scriptType").build()).build();

    private static final SdkField<String> COMMAND_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("command")
            .getter(getter(SSMValidationParameters::command)).setter(setter(Builder::command))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("command").build()).build();

    private static final SdkField<Integer> EXECUTION_TIMEOUT_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("executionTimeoutSeconds").getter(getter(SSMValidationParameters::executionTimeoutSeconds))
            .setter(setter(Builder::executionTimeoutSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionTimeoutSeconds").build())
            .build();

    private static final SdkField<String> OUTPUT_S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputS3BucketName").getter(getter(SSMValidationParameters::outputS3BucketName))
            .setter(setter(Builder::outputS3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputS3BucketName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD,
            INSTANCE_ID_FIELD, SCRIPT_TYPE_FIELD, COMMAND_FIELD, EXECUTION_TIMEOUT_SECONDS_FIELD, OUTPUT_S3_BUCKET_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Source source;

    private final String instanceId;

    private final String scriptType;

    private final String command;

    private final Integer executionTimeoutSeconds;

    private final String outputS3BucketName;

    private SSMValidationParameters(BuilderImpl builder) {
        this.source = builder.source;
        this.instanceId = builder.instanceId;
        this.scriptType = builder.scriptType;
        this.command = builder.command;
        this.executionTimeoutSeconds = builder.executionTimeoutSeconds;
        this.outputS3BucketName = builder.outputS3BucketName;
    }

    /**
     * <p>
     * The location of the validation script.
     * </p>
     * 
     * @return The location of the validation script.
     */
    public final Source source() {
        return source;
    }

    /**
     * <p>
     * The ID of the instance. The instance must have the following tag: UserForSMSApplicationValidation=true.
     * </p>
     * 
     * @return The ID of the instance. The instance must have the following tag: UserForSMSApplicationValidation=true.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The type of validation script.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scriptType} will
     * return {@link ScriptType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scriptTypeAsString}.
     * </p>
     * 
     * @return The type of validation script.
     * @see ScriptType
     */
    public final ScriptType scriptType() {
        return ScriptType.fromValue(scriptType);
    }

    /**
     * <p>
     * The type of validation script.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scriptType} will
     * return {@link ScriptType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scriptTypeAsString}.
     * </p>
     * 
     * @return The type of validation script.
     * @see ScriptType
     */
    public final String scriptTypeAsString() {
        return scriptType;
    }

    /**
     * <p>
     * The command to run the validation script.
     * </p>
     * 
     * @return The command to run the validation script.
     */
    public final String command() {
        return command;
    }

    /**
     * <p>
     * The timeout interval, in seconds.
     * </p>
     * 
     * @return The timeout interval, in seconds.
     */
    public final Integer executionTimeoutSeconds() {
        return executionTimeoutSeconds;
    }

    /**
     * <p>
     * The name of the S3 bucket for output.
     * </p>
     * 
     * @return The name of the S3 bucket for output.
     */
    public final String outputS3BucketName() {
        return outputS3BucketName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(scriptTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(command());
        hashCode = 31 * hashCode + Objects.hashCode(executionTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(outputS3BucketName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SSMValidationParameters)) {
            return false;
        }
        SSMValidationParameters other = (SSMValidationParameters) obj;
        return Objects.equals(source(), other.source()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(scriptTypeAsString(), other.scriptTypeAsString()) && Objects.equals(command(), other.command())
                && Objects.equals(executionTimeoutSeconds(), other.executionTimeoutSeconds())
                && Objects.equals(outputS3BucketName(), other.outputS3BucketName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SSMValidationParameters").add("Source", source()).add("InstanceId", instanceId())
                .add("ScriptType", scriptTypeAsString()).add("Command", command())
                .add("ExecutionTimeoutSeconds", executionTimeoutSeconds()).add("OutputS3BucketName", outputS3BucketName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "instanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "scriptType":
            return Optional.ofNullable(clazz.cast(scriptTypeAsString()));
        case "command":
            return Optional.ofNullable(clazz.cast(command()));
        case "executionTimeoutSeconds":
            return Optional.ofNullable(clazz.cast(executionTimeoutSeconds()));
        case "outputS3BucketName":
            return Optional.ofNullable(clazz.cast(outputS3BucketName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("source", SOURCE_FIELD);
        map.put("instanceId", INSTANCE_ID_FIELD);
        map.put("scriptType", SCRIPT_TYPE_FIELD);
        map.put("command", COMMAND_FIELD);
        map.put("executionTimeoutSeconds", EXECUTION_TIMEOUT_SECONDS_FIELD);
        map.put("outputS3BucketName", OUTPUT_S3_BUCKET_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SSMValidationParameters, T> g) {
        return obj -> g.apply((SSMValidationParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SSMValidationParameters> {
        /**
         * <p>
         * The location of the validation script.
         * </p>
         * 
         * @param source
         *        The location of the validation script.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(Source source);

        /**
         * <p>
         * The location of the validation script.
         * </p>
         * This is a convenience method that creates an instance of the {@link Source.Builder} avoiding the need to
         * create one manually via {@link Source#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Source.Builder#build()} is called immediately and its result is
         * passed to {@link #source(Source)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link Source.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(Source)
         */
        default Builder source(Consumer<Source.Builder> source) {
            return source(Source.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * The ID of the instance. The instance must have the following tag: UserForSMSApplicationValidation=true.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance. The instance must have the following tag:
         *        UserForSMSApplicationValidation=true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The type of validation script.
         * </p>
         * 
         * @param scriptType
         *        The type of validation script.
         * @see ScriptType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScriptType
         */
        Builder scriptType(String scriptType);

        /**
         * <p>
         * The type of validation script.
         * </p>
         * 
         * @param scriptType
         *        The type of validation script.
         * @see ScriptType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScriptType
         */
        Builder scriptType(ScriptType scriptType);

        /**
         * <p>
         * The command to run the validation script.
         * </p>
         * 
         * @param command
         *        The command to run the validation script.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder command(String command);

        /**
         * <p>
         * The timeout interval, in seconds.
         * </p>
         * 
         * @param executionTimeoutSeconds
         *        The timeout interval, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionTimeoutSeconds(Integer executionTimeoutSeconds);

        /**
         * <p>
         * The name of the S3 bucket for output.
         * </p>
         * 
         * @param outputS3BucketName
         *        The name of the S3 bucket for output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3BucketName(String outputS3BucketName);
    }

    static final class BuilderImpl implements Builder {
        private Source source;

        private String instanceId;

        private String scriptType;

        private String command;

        private Integer executionTimeoutSeconds;

        private String outputS3BucketName;

        private BuilderImpl() {
        }

        private BuilderImpl(SSMValidationParameters model) {
            source(model.source);
            instanceId(model.instanceId);
            scriptType(model.scriptType);
            command(model.command);
            executionTimeoutSeconds(model.executionTimeoutSeconds);
            outputS3BucketName(model.outputS3BucketName);
        }

        public final Source.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getScriptType() {
            return scriptType;
        }

        public final void setScriptType(String scriptType) {
            this.scriptType = scriptType;
        }

        @Override
        public final Builder scriptType(String scriptType) {
            this.scriptType = scriptType;
            return this;
        }

        @Override
        public final Builder scriptType(ScriptType scriptType) {
            this.scriptType(scriptType == null ? null : scriptType.toString());
            return this;
        }

        public final String getCommand() {
            return command;
        }

        public final void setCommand(String command) {
            this.command = command;
        }

        @Override
        public final Builder command(String command) {
            this.command = command;
            return this;
        }

        public final Integer getExecutionTimeoutSeconds() {
            return executionTimeoutSeconds;
        }

        public final void setExecutionTimeoutSeconds(Integer executionTimeoutSeconds) {
            this.executionTimeoutSeconds = executionTimeoutSeconds;
        }

        @Override
        public final Builder executionTimeoutSeconds(Integer executionTimeoutSeconds) {
            this.executionTimeoutSeconds = executionTimeoutSeconds;
            return this;
        }

        public final String getOutputS3BucketName() {
            return outputS3BucketName;
        }

        public final void setOutputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
        }

        @Override
        public final Builder outputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
            return this;
        }

        @Override
        public SSMValidationParameters build() {
            return new SSMValidationParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
