/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.snowball.model.LongTermPricingType;
import software.amazon.awssdk.services.snowball.model.SnowballRequest;
import software.amazon.awssdk.services.snowball.model.SnowballType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLongTermPricingRequest
extends SnowballRequest
implements ToCopyableBuilder<Builder, CreateLongTermPricingRequest> {
    private static final SdkField<String> LONG_TERM_PRICING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LongTermPricingType").getter(CreateLongTermPricingRequest.getter(CreateLongTermPricingRequest::longTermPricingTypeAsString)).setter(CreateLongTermPricingRequest.setter(Builder::longTermPricingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LongTermPricingType").build()}).build();
    private static final SdkField<Boolean> IS_LONG_TERM_PRICING_AUTO_RENEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsLongTermPricingAutoRenew").getter(CreateLongTermPricingRequest.getter(CreateLongTermPricingRequest::isLongTermPricingAutoRenew)).setter(CreateLongTermPricingRequest.setter(Builder::isLongTermPricingAutoRenew)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsLongTermPricingAutoRenew").build()}).build();
    private static final SdkField<String> SNOWBALL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnowballType").getter(CreateLongTermPricingRequest.getter(CreateLongTermPricingRequest::snowballTypeAsString)).setter(CreateLongTermPricingRequest.setter(Builder::snowballType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnowballType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LONG_TERM_PRICING_TYPE_FIELD, IS_LONG_TERM_PRICING_AUTO_RENEW_FIELD, SNOWBALL_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateLongTermPricingRequest.memberNameToFieldInitializer();
    private final String longTermPricingType;
    private final Boolean isLongTermPricingAutoRenew;
    private final String snowballType;

    private CreateLongTermPricingRequest(BuilderImpl builder) {
        super(builder);
        this.longTermPricingType = builder.longTermPricingType;
        this.isLongTermPricingAutoRenew = builder.isLongTermPricingAutoRenew;
        this.snowballType = builder.snowballType;
    }

    public final LongTermPricingType longTermPricingType() {
        return LongTermPricingType.fromValue(this.longTermPricingType);
    }

    public final String longTermPricingTypeAsString() {
        return this.longTermPricingType;
    }

    public final Boolean isLongTermPricingAutoRenew() {
        return this.isLongTermPricingAutoRenew;
    }

    public final SnowballType snowballType() {
        return SnowballType.fromValue(this.snowballType);
    }

    public final String snowballTypeAsString() {
        return this.snowballType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.longTermPricingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.isLongTermPricingAutoRenew());
        hashCode = 31 * hashCode + Objects.hashCode(this.snowballTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLongTermPricingRequest)) {
            return false;
        }
        CreateLongTermPricingRequest other = (CreateLongTermPricingRequest)((Object)obj);
        return Objects.equals(this.longTermPricingTypeAsString(), other.longTermPricingTypeAsString()) && Objects.equals(this.isLongTermPricingAutoRenew(), other.isLongTermPricingAutoRenew()) && Objects.equals(this.snowballTypeAsString(), other.snowballTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLongTermPricingRequest").add("LongTermPricingType", (Object)this.longTermPricingTypeAsString()).add("IsLongTermPricingAutoRenew", (Object)this.isLongTermPricingAutoRenew()).add("SnowballType", (Object)this.snowballTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LongTermPricingType": {
                return Optional.ofNullable(clazz.cast(this.longTermPricingTypeAsString()));
            }
            case "IsLongTermPricingAutoRenew": {
                return Optional.ofNullable(clazz.cast(this.isLongTermPricingAutoRenew()));
            }
            case "SnowballType": {
                return Optional.ofNullable(clazz.cast(this.snowballTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LongTermPricingType", LONG_TERM_PRICING_TYPE_FIELD);
        map.put("IsLongTermPricingAutoRenew", IS_LONG_TERM_PRICING_AUTO_RENEW_FIELD);
        map.put("SnowballType", SNOWBALL_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLongTermPricingRequest, T> g) {
        return obj -> g.apply((CreateLongTermPricingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnowballRequest.BuilderImpl
    implements Builder {
        private String longTermPricingType;
        private Boolean isLongTermPricingAutoRenew;
        private String snowballType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLongTermPricingRequest model) {
            super(model);
            this.longTermPricingType(model.longTermPricingType);
            this.isLongTermPricingAutoRenew(model.isLongTermPricingAutoRenew);
            this.snowballType(model.snowballType);
        }

        public final String getLongTermPricingType() {
            return this.longTermPricingType;
        }

        public final void setLongTermPricingType(String longTermPricingType) {
            this.longTermPricingType = longTermPricingType;
        }

        @Override
        public final Builder longTermPricingType(String longTermPricingType) {
            this.longTermPricingType = longTermPricingType;
            return this;
        }

        @Override
        public final Builder longTermPricingType(LongTermPricingType longTermPricingType) {
            this.longTermPricingType(longTermPricingType == null ? null : longTermPricingType.toString());
            return this;
        }

        public final Boolean getIsLongTermPricingAutoRenew() {
            return this.isLongTermPricingAutoRenew;
        }

        public final void setIsLongTermPricingAutoRenew(Boolean isLongTermPricingAutoRenew) {
            this.isLongTermPricingAutoRenew = isLongTermPricingAutoRenew;
        }

        @Override
        public final Builder isLongTermPricingAutoRenew(Boolean isLongTermPricingAutoRenew) {
            this.isLongTermPricingAutoRenew = isLongTermPricingAutoRenew;
            return this;
        }

        public final String getSnowballType() {
            return this.snowballType;
        }

        public final void setSnowballType(String snowballType) {
            this.snowballType = snowballType;
        }

        @Override
        public final Builder snowballType(String snowballType) {
            this.snowballType = snowballType;
            return this;
        }

        @Override
        public final Builder snowballType(SnowballType snowballType) {
            this.snowballType(snowballType == null ? null : snowballType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLongTermPricingRequest build() {
            return new CreateLongTermPricingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SnowballRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLongTermPricingRequest> {
        public Builder longTermPricingType(String var1);

        public Builder longTermPricingType(LongTermPricingType var1);

        public Builder isLongTermPricingAutoRenew(Boolean var1);

        public Builder snowballType(String var1);

        public Builder snowballType(SnowballType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

