/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.NodeAggregator;
import software.amazon.awssdk.services.ssm.model.NodeAggregatorListCopier;
import software.amazon.awssdk.services.ssm.model.NodeFilter;
import software.amazon.awssdk.services.ssm.model.NodeFilterListCopier;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNodesSummaryRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, ListNodesSummaryRequest> {
    private static final SdkField<String> SYNC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SyncName").getter(ListNodesSummaryRequest.getter(ListNodesSummaryRequest::syncName)).setter(ListNodesSummaryRequest.setter(Builder::syncName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncName").build()}).build();
    private static final SdkField<List<NodeFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(ListNodesSummaryRequest.getter(ListNodesSummaryRequest::filters)).setter(ListNodesSummaryRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NodeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<NodeAggregator>> AGGREGATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Aggregators").getter(ListNodesSummaryRequest.getter(ListNodesSummaryRequest::aggregators)).setter(ListNodesSummaryRequest.setter(Builder::aggregators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NodeAggregator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListNodesSummaryRequest.getter(ListNodesSummaryRequest::nextToken)).setter(ListNodesSummaryRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListNodesSummaryRequest.getter(ListNodesSummaryRequest::maxResults)).setter(ListNodesSummaryRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYNC_NAME_FIELD, FILTERS_FIELD, AGGREGATORS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SyncName", SYNC_NAME_FIELD);
            this.put("Filters", FILTERS_FIELD);
            this.put("Aggregators", AGGREGATORS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
        }
    });
    private final String syncName;
    private final List<NodeFilter> filters;
    private final List<NodeAggregator> aggregators;
    private final String nextToken;
    private final Integer maxResults;

    private ListNodesSummaryRequest(BuilderImpl builder) {
        super(builder);
        this.syncName = builder.syncName;
        this.filters = builder.filters;
        this.aggregators = builder.aggregators;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String syncName() {
        return this.syncName;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<NodeFilter> filters() {
        return this.filters;
    }

    public final boolean hasAggregators() {
        return this.aggregators != null && !(this.aggregators instanceof SdkAutoConstructList);
    }

    public final List<NodeAggregator> aggregators() {
        return this.aggregators;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.syncName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggregators() ? this.aggregators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNodesSummaryRequest)) {
            return false;
        }
        ListNodesSummaryRequest other = (ListNodesSummaryRequest)((Object)obj);
        return Objects.equals(this.syncName(), other.syncName()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && this.hasAggregators() == other.hasAggregators() && Objects.equals(this.aggregators(), other.aggregators()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListNodesSummaryRequest").add("SyncName", (Object)this.syncName()).add("Filters", this.hasFilters() ? this.filters() : null).add("Aggregators", this.hasAggregators() ? this.aggregators() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SyncName": {
                return Optional.ofNullable(clazz.cast(this.syncName()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "Aggregators": {
                return Optional.ofNullable(clazz.cast(this.aggregators()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListNodesSummaryRequest, T> g) {
        return obj -> g.apply((ListNodesSummaryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String syncName;
        private List<NodeFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private List<NodeAggregator> aggregators = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNodesSummaryRequest model) {
            super(model);
            this.syncName(model.syncName);
            this.filters(model.filters);
            this.aggregators(model.aggregators);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getSyncName() {
            return this.syncName;
        }

        public final void setSyncName(String syncName) {
            this.syncName = syncName;
        }

        @Override
        public final Builder syncName(String syncName) {
            this.syncName = syncName;
            return this;
        }

        public final List<NodeFilter.Builder> getFilters() {
            List<NodeFilter.Builder> result = NodeFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<NodeFilter.BuilderImpl> filters) {
            this.filters = NodeFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<NodeFilter> filters) {
            this.filters = NodeFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(NodeFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<NodeFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (NodeFilter)((NodeFilter.Builder)NodeFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<NodeAggregator.Builder> getAggregators() {
            List<NodeAggregator.Builder> result = NodeAggregatorListCopier.copyToBuilder(this.aggregators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregators(Collection<NodeAggregator.BuilderImpl> aggregators) {
            this.aggregators = NodeAggregatorListCopier.copyFromBuilder(aggregators);
        }

        @Override
        public final Builder aggregators(Collection<NodeAggregator> aggregators) {
            this.aggregators = NodeAggregatorListCopier.copy(aggregators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregators(NodeAggregator ... aggregators) {
            this.aggregators(Arrays.asList(aggregators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregators(Consumer<NodeAggregator.Builder> ... aggregators) {
            this.aggregators(Stream.of(aggregators).map(c -> (NodeAggregator)((NodeAggregator.Builder)NodeAggregator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListNodesSummaryRequest build() {
            return new ListNodesSummaryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNodesSummaryRequest> {
        public Builder syncName(String var1);

        public Builder filters(Collection<NodeFilter> var1);

        public Builder filters(NodeFilter ... var1);

        public Builder filters(Consumer<NodeFilter.Builder> ... var1);

        public Builder aggregators(Collection<NodeAggregator> var1);

        public Builder aggregators(NodeAggregator ... var1);

        public Builder aggregators(Consumer<NodeAggregator.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

