/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.InstancePropertyFilter;
import software.amazon.awssdk.services.ssm.model.InstancePropertyFilterListCopier;
import software.amazon.awssdk.services.ssm.model.InstancePropertyStringFilter;
import software.amazon.awssdk.services.ssm.model.InstancePropertyStringFilterListCopier;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInstancePropertiesRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, DescribeInstancePropertiesRequest> {
    private static final SdkField<List<InstancePropertyFilter>> INSTANCE_PROPERTY_FILTER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstancePropertyFilterList").getter(DescribeInstancePropertiesRequest.getter(DescribeInstancePropertiesRequest::instancePropertyFilterList)).setter(DescribeInstancePropertiesRequest.setter(Builder::instancePropertyFilterList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancePropertyFilterList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstancePropertyFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<InstancePropertyStringFilter>> FILTERS_WITH_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FiltersWithOperator").getter(DescribeInstancePropertiesRequest.getter(DescribeInstancePropertiesRequest::filtersWithOperator)).setter(DescribeInstancePropertiesRequest.setter(Builder::filtersWithOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FiltersWithOperator").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstancePropertyStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeInstancePropertiesRequest.getter(DescribeInstancePropertiesRequest::maxResults)).setter(DescribeInstancePropertiesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeInstancePropertiesRequest.getter(DescribeInstancePropertiesRequest::nextToken)).setter(DescribeInstancePropertiesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_PROPERTY_FILTER_LIST_FIELD, FILTERS_WITH_OPERATOR_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InstancePropertyFilterList", INSTANCE_PROPERTY_FILTER_LIST_FIELD);
            this.put("FiltersWithOperator", FILTERS_WITH_OPERATOR_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<InstancePropertyFilter> instancePropertyFilterList;
    private final List<InstancePropertyStringFilter> filtersWithOperator;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeInstancePropertiesRequest(BuilderImpl builder) {
        super(builder);
        this.instancePropertyFilterList = builder.instancePropertyFilterList;
        this.filtersWithOperator = builder.filtersWithOperator;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasInstancePropertyFilterList() {
        return this.instancePropertyFilterList != null && !(this.instancePropertyFilterList instanceof SdkAutoConstructList);
    }

    public final List<InstancePropertyFilter> instancePropertyFilterList() {
        return this.instancePropertyFilterList;
    }

    public final boolean hasFiltersWithOperator() {
        return this.filtersWithOperator != null && !(this.filtersWithOperator instanceof SdkAutoConstructList);
    }

    public final List<InstancePropertyStringFilter> filtersWithOperator() {
        return this.filtersWithOperator;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstancePropertyFilterList() ? this.instancePropertyFilterList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFiltersWithOperator() ? this.filtersWithOperator() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancePropertiesRequest)) {
            return false;
        }
        DescribeInstancePropertiesRequest other = (DescribeInstancePropertiesRequest)((Object)obj);
        return this.hasInstancePropertyFilterList() == other.hasInstancePropertyFilterList() && Objects.equals(this.instancePropertyFilterList(), other.instancePropertyFilterList()) && this.hasFiltersWithOperator() == other.hasFiltersWithOperator() && Objects.equals(this.filtersWithOperator(), other.filtersWithOperator()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeInstancePropertiesRequest").add("InstancePropertyFilterList", this.hasInstancePropertyFilterList() ? this.instancePropertyFilterList() : null).add("FiltersWithOperator", this.hasFiltersWithOperator() ? this.filtersWithOperator() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstancePropertyFilterList": {
                return Optional.ofNullable(clazz.cast(this.instancePropertyFilterList()));
            }
            case "FiltersWithOperator": {
                return Optional.ofNullable(clazz.cast(this.filtersWithOperator()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstancePropertiesRequest, T> g) {
        return obj -> g.apply((DescribeInstancePropertiesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private List<InstancePropertyFilter> instancePropertyFilterList = DefaultSdkAutoConstructList.getInstance();
        private List<InstancePropertyStringFilter> filtersWithOperator = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancePropertiesRequest model) {
            super(model);
            this.instancePropertyFilterList(model.instancePropertyFilterList);
            this.filtersWithOperator(model.filtersWithOperator);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final List<InstancePropertyFilter.Builder> getInstancePropertyFilterList() {
            List<InstancePropertyFilter.Builder> result = InstancePropertyFilterListCopier.copyToBuilder(this.instancePropertyFilterList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstancePropertyFilterList(Collection<InstancePropertyFilter.BuilderImpl> instancePropertyFilterList) {
            this.instancePropertyFilterList = InstancePropertyFilterListCopier.copyFromBuilder(instancePropertyFilterList);
        }

        @Override
        public final Builder instancePropertyFilterList(Collection<InstancePropertyFilter> instancePropertyFilterList) {
            this.instancePropertyFilterList = InstancePropertyFilterListCopier.copy(instancePropertyFilterList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instancePropertyFilterList(InstancePropertyFilter ... instancePropertyFilterList) {
            this.instancePropertyFilterList(Arrays.asList(instancePropertyFilterList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instancePropertyFilterList(Consumer<InstancePropertyFilter.Builder> ... instancePropertyFilterList) {
            this.instancePropertyFilterList(Stream.of(instancePropertyFilterList).map(c -> (InstancePropertyFilter)((InstancePropertyFilter.Builder)InstancePropertyFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<InstancePropertyStringFilter.Builder> getFiltersWithOperator() {
            List<InstancePropertyStringFilter.Builder> result = InstancePropertyStringFilterListCopier.copyToBuilder(this.filtersWithOperator);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFiltersWithOperator(Collection<InstancePropertyStringFilter.BuilderImpl> filtersWithOperator) {
            this.filtersWithOperator = InstancePropertyStringFilterListCopier.copyFromBuilder(filtersWithOperator);
        }

        @Override
        public final Builder filtersWithOperator(Collection<InstancePropertyStringFilter> filtersWithOperator) {
            this.filtersWithOperator = InstancePropertyStringFilterListCopier.copy(filtersWithOperator);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filtersWithOperator(InstancePropertyStringFilter ... filtersWithOperator) {
            this.filtersWithOperator(Arrays.asList(filtersWithOperator));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filtersWithOperator(Consumer<InstancePropertyStringFilter.Builder> ... filtersWithOperator) {
            this.filtersWithOperator(Stream.of(filtersWithOperator).map(c -> (InstancePropertyStringFilter)((InstancePropertyStringFilter.Builder)InstancePropertyStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeInstancePropertiesRequest build() {
            return new DescribeInstancePropertiesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInstancePropertiesRequest> {
        public Builder instancePropertyFilterList(Collection<InstancePropertyFilter> var1);

        public Builder instancePropertyFilterList(InstancePropertyFilter ... var1);

        public Builder instancePropertyFilterList(Consumer<InstancePropertyFilter.Builder> ... var1);

        public Builder filtersWithOperator(Collection<InstancePropertyStringFilter> var1);

        public Builder filtersWithOperator(InstancePropertyStringFilter ... var1);

        public Builder filtersWithOperator(Consumer<InstancePropertyStringFilter.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

