/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.DocumentReviewCommentListCopier;
import software.amazon.awssdk.services.ssm.model.DocumentReviewCommentSource;
import software.amazon.awssdk.services.ssm.model.ReviewStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentReviewerResponseSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentReviewerResponseSource> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(DocumentReviewerResponseSource.getter(DocumentReviewerResponseSource::createTime)).setter(DocumentReviewerResponseSource.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()}).build();
    private static final SdkField<Instant> UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedTime").getter(DocumentReviewerResponseSource.getter(DocumentReviewerResponseSource::updatedTime)).setter(DocumentReviewerResponseSource.setter(Builder::updatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTime").build()}).build();
    private static final SdkField<String> REVIEW_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReviewStatus").getter(DocumentReviewerResponseSource.getter(DocumentReviewerResponseSource::reviewStatusAsString)).setter(DocumentReviewerResponseSource.setter(Builder::reviewStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewStatus").build()}).build();
    private static final SdkField<List<DocumentReviewCommentSource>> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Comment").getter(DocumentReviewerResponseSource.getter(DocumentReviewerResponseSource::comment)).setter(DocumentReviewerResponseSource.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentReviewCommentSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REVIEWER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Reviewer").getter(DocumentReviewerResponseSource.getter(DocumentReviewerResponseSource::reviewer)).setter(DocumentReviewerResponseSource.setter(Builder::reviewer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reviewer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD, UPDATED_TIME_FIELD, REVIEW_STATUS_FIELD, COMMENT_FIELD, REVIEWER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CreateTime", CREATE_TIME_FIELD);
            this.put("UpdatedTime", UPDATED_TIME_FIELD);
            this.put("ReviewStatus", REVIEW_STATUS_FIELD);
            this.put("Comment", COMMENT_FIELD);
            this.put("Reviewer", REVIEWER_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Instant createTime;
    private final Instant updatedTime;
    private final String reviewStatus;
    private final List<DocumentReviewCommentSource> comment;
    private final String reviewer;

    private DocumentReviewerResponseSource(BuilderImpl builder) {
        this.createTime = builder.createTime;
        this.updatedTime = builder.updatedTime;
        this.reviewStatus = builder.reviewStatus;
        this.comment = builder.comment;
        this.reviewer = builder.reviewer;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updatedTime() {
        return this.updatedTime;
    }

    public final ReviewStatus reviewStatus() {
        return ReviewStatus.fromValue(this.reviewStatus);
    }

    public final String reviewStatusAsString() {
        return this.reviewStatus;
    }

    public final boolean hasComment() {
        return this.comment != null && !(this.comment instanceof SdkAutoConstructList);
    }

    public final List<DocumentReviewCommentSource> comment() {
        return this.comment;
    }

    public final String reviewer() {
        return this.reviewer;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.reviewStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComment() ? this.comment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.reviewer());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentReviewerResponseSource)) {
            return false;
        }
        DocumentReviewerResponseSource other = (DocumentReviewerResponseSource)obj;
        return Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updatedTime(), other.updatedTime()) && Objects.equals(this.reviewStatusAsString(), other.reviewStatusAsString()) && this.hasComment() == other.hasComment() && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.reviewer(), other.reviewer());
    }

    public final String toString() {
        return ToString.builder((String)"DocumentReviewerResponseSource").add("CreateTime", (Object)this.createTime()).add("UpdatedTime", (Object)this.updatedTime()).add("ReviewStatus", (Object)this.reviewStatusAsString()).add("Comment", this.hasComment() ? this.comment() : null).add("Reviewer", (Object)this.reviewer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "UpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.updatedTime()));
            }
            case "ReviewStatus": {
                return Optional.ofNullable(clazz.cast(this.reviewStatusAsString()));
            }
            case "Comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "Reviewer": {
                return Optional.ofNullable(clazz.cast(this.reviewer()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DocumentReviewerResponseSource, T> g) {
        return obj -> g.apply((DocumentReviewerResponseSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createTime;
        private Instant updatedTime;
        private String reviewStatus;
        private List<DocumentReviewCommentSource> comment = DefaultSdkAutoConstructList.getInstance();
        private String reviewer;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentReviewerResponseSource model) {
            this.createTime(model.createTime);
            this.updatedTime(model.updatedTime);
            this.reviewStatus(model.reviewStatus);
            this.comment(model.comment);
            this.reviewer(model.reviewer);
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdatedTime() {
            return this.updatedTime;
        }

        public final void setUpdatedTime(Instant updatedTime) {
            this.updatedTime = updatedTime;
        }

        @Override
        public final Builder updatedTime(Instant updatedTime) {
            this.updatedTime = updatedTime;
            return this;
        }

        public final String getReviewStatus() {
            return this.reviewStatus;
        }

        public final void setReviewStatus(String reviewStatus) {
            this.reviewStatus = reviewStatus;
        }

        @Override
        public final Builder reviewStatus(String reviewStatus) {
            this.reviewStatus = reviewStatus;
            return this;
        }

        @Override
        public final Builder reviewStatus(ReviewStatus reviewStatus) {
            this.reviewStatus(reviewStatus == null ? null : reviewStatus.toString());
            return this;
        }

        public final List<DocumentReviewCommentSource.Builder> getComment() {
            List<DocumentReviewCommentSource.Builder> result = DocumentReviewCommentListCopier.copyToBuilder(this.comment);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComment(Collection<DocumentReviewCommentSource.BuilderImpl> comment) {
            this.comment = DocumentReviewCommentListCopier.copyFromBuilder(comment);
        }

        @Override
        public final Builder comment(Collection<DocumentReviewCommentSource> comment) {
            this.comment = DocumentReviewCommentListCopier.copy(comment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder comment(DocumentReviewCommentSource ... comment) {
            this.comment(Arrays.asList(comment));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder comment(Consumer<DocumentReviewCommentSource.Builder> ... comment) {
            this.comment(Stream.of(comment).map(c -> (DocumentReviewCommentSource)((DocumentReviewCommentSource.Builder)DocumentReviewCommentSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getReviewer() {
            return this.reviewer;
        }

        public final void setReviewer(String reviewer) {
            this.reviewer = reviewer;
        }

        @Override
        public final Builder reviewer(String reviewer) {
            this.reviewer = reviewer;
            return this;
        }

        public DocumentReviewerResponseSource build() {
            return new DocumentReviewerResponseSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentReviewerResponseSource> {
        public Builder createTime(Instant var1);

        public Builder updatedTime(Instant var1);

        public Builder reviewStatus(String var1);

        public Builder reviewStatus(ReviewStatus var1);

        public Builder comment(Collection<DocumentReviewCommentSource> var1);

        public Builder comment(DocumentReviewCommentSource ... var1);

        public Builder comment(Consumer<DocumentReviewCommentSource.Builder> ... var1);

        public Builder reviewer(String var1);
    }
}

