/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.GetResourcePoliciesResponseEntriesCopier;
import software.amazon.awssdk.services.ssm.model.GetResourcePoliciesResponseEntry;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourcePoliciesResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, GetResourcePoliciesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetResourcePoliciesResponse.getter(GetResourcePoliciesResponse::nextToken)).setter(GetResourcePoliciesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<GetResourcePoliciesResponseEntry>> POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Policies").getter(GetResourcePoliciesResponse.getter(GetResourcePoliciesResponse::policies)).setter(GetResourcePoliciesResponse.setter(Builder::policies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GetResourcePoliciesResponseEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, POLICIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("Policies", POLICIES_FIELD);
        }
    });
    private final String nextToken;
    private final List<GetResourcePoliciesResponseEntry> policies;

    private GetResourcePoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.policies = builder.policies;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasPolicies() {
        return this.policies != null && !(this.policies instanceof SdkAutoConstructList);
    }

    public final List<GetResourcePoliciesResponseEntry> policies() {
        return this.policies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicies() ? this.policies() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourcePoliciesResponse)) {
            return false;
        }
        GetResourcePoliciesResponse other = (GetResourcePoliciesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasPolicies() == other.hasPolicies() && Objects.equals(this.policies(), other.policies());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourcePoliciesResponse").add("NextToken", (Object)this.nextToken()).add("Policies", this.hasPolicies() ? this.policies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Policies": {
                return Optional.ofNullable(clazz.cast(this.policies()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetResourcePoliciesResponse, T> g) {
        return obj -> g.apply((GetResourcePoliciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<GetResourcePoliciesResponseEntry> policies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourcePoliciesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.policies(model.policies);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<GetResourcePoliciesResponseEntry.Builder> getPolicies() {
            List<GetResourcePoliciesResponseEntry.Builder> result = GetResourcePoliciesResponseEntriesCopier.copyToBuilder(this.policies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicies(Collection<GetResourcePoliciesResponseEntry.BuilderImpl> policies) {
            this.policies = GetResourcePoliciesResponseEntriesCopier.copyFromBuilder(policies);
        }

        @Override
        public final Builder policies(Collection<GetResourcePoliciesResponseEntry> policies) {
            this.policies = GetResourcePoliciesResponseEntriesCopier.copy(policies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(GetResourcePoliciesResponseEntry ... policies) {
            this.policies(Arrays.asList(policies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(Consumer<GetResourcePoliciesResponseEntry.Builder> ... policies) {
            this.policies(Stream.of(policies).map(c -> (GetResourcePoliciesResponseEntry)((GetResourcePoliciesResponseEntry.Builder)GetResourcePoliciesResponseEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetResourcePoliciesResponse build() {
            return new GetResourcePoliciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourcePoliciesResponse> {
        public Builder nextToken(String var1);

        public Builder policies(Collection<GetResourcePoliciesResponseEntry> var1);

        public Builder policies(GetResourcePoliciesResponseEntry ... var1);

        public Builder policies(Consumer<GetResourcePoliciesResponseEntry.Builder> ... var1);
    }
}

