/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest;
import software.amazon.awssdk.services.ssm.model.DescribePatchGroupsResponse;
import software.amazon.awssdk.services.ssm.model.PatchGroupPatchBaselineMapping;

public class DescribePatchGroupsIterable
implements SdkIterable<DescribePatchGroupsResponse> {
    private final SsmClient client;
    private final DescribePatchGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribePatchGroupsIterable(SsmClient client, DescribePatchGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribePatchGroupsResponseFetcher();
    }

    public Iterator<DescribePatchGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PatchGroupPatchBaselineMapping> mappings() {
        Function<DescribePatchGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.mappings() != null) {
                return response.mappings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribePatchGroupsResponseFetcher
    implements SyncPageFetcher<DescribePatchGroupsResponse> {
        private DescribePatchGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribePatchGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribePatchGroupsResponse nextPage(DescribePatchGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribePatchGroupsIterable.this.client.describePatchGroups(DescribePatchGroupsIterable.this.firstRequest);
            }
            return DescribePatchGroupsIterable.this.client.describePatchGroups((DescribePatchGroupsRequest)((Object)DescribePatchGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

