/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information includes the Amazon Web Services account ID where the current document is shared and the version shared
 * with that account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountSharingInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<AccountSharingInfo.Builder, AccountSharingInfo> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(AccountSharingInfo::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> SHARED_DOCUMENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SharedDocumentVersion").getter(getter(AccountSharingInfo::sharedDocumentVersion))
            .setter(setter(Builder::sharedDocumentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedDocumentVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            SHARED_DOCUMENT_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String sharedDocumentVersion;

    private AccountSharingInfo(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.sharedDocumentVersion = builder.sharedDocumentVersion;
    }

    /**
     * <p>
     * The Amazon Web Services account ID where the current document is shared.
     * </p>
     * 
     * @return The Amazon Web Services account ID where the current document is shared.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The version of the current document shared with the account.
     * </p>
     * 
     * @return The version of the current document shared with the account.
     */
    public final String sharedDocumentVersion() {
        return sharedDocumentVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(sharedDocumentVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountSharingInfo)) {
            return false;
        }
        AccountSharingInfo other = (AccountSharingInfo) obj;
        return Objects.equals(accountId(), other.accountId())
                && Objects.equals(sharedDocumentVersion(), other.sharedDocumentVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountSharingInfo").add("AccountId", accountId())
                .add("SharedDocumentVersion", sharedDocumentVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "SharedDocumentVersion":
            return Optional.ofNullable(clazz.cast(sharedDocumentVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("SharedDocumentVersion", SHARED_DOCUMENT_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountSharingInfo, T> g) {
        return obj -> g.apply((AccountSharingInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountSharingInfo> {
        /**
         * <p>
         * The Amazon Web Services account ID where the current document is shared.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID where the current document is shared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The version of the current document shared with the account.
         * </p>
         * 
         * @param sharedDocumentVersion
         *        The version of the current document shared with the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedDocumentVersion(String sharedDocumentVersion);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String sharedDocumentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountSharingInfo model) {
            accountId(model.accountId);
            sharedDocumentVersion(model.sharedDocumentVersion);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getSharedDocumentVersion() {
            return sharedDocumentVersion;
        }

        public final void setSharedDocumentVersion(String sharedDocumentVersion) {
            this.sharedDocumentVersion = sharedDocumentVersion;
        }

        @Override
        public final Builder sharedDocumentVersion(String sharedDocumentVersion) {
            this.sharedDocumentVersion = sharedDocumentVersion;
            return this;
        }

        @Override
        public AccountSharingInfo build() {
            return new AccountSharingInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
