/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the results of the execution preview.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomationExecutionPreview implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomationExecutionPreview.Builder, AutomationExecutionPreview> {
    private static final SdkField<Map<String, Integer>> STEP_PREVIEWS_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("StepPreviews")
            .getter(getter(AutomationExecutionPreview::stepPreviewsAsStrings))
            .setter(setter(Builder::stepPreviewsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepPreviews").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Regions")
            .getter(getter(AutomationExecutionPreview::regions))
            .setter(setter(Builder::regions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Regions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TargetPreview>> TARGET_PREVIEWS_FIELD = SdkField
            .<List<TargetPreview>> builder(MarshallingType.LIST)
            .memberName("TargetPreviews")
            .getter(getter(AutomationExecutionPreview::targetPreviews))
            .setter(setter(Builder::targetPreviews))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetPreviews").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TargetPreview> builder(MarshallingType.SDK_POJO)
                                            .constructor(TargetPreview::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> TOTAL_ACCOUNTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalAccounts").getter(getter(AutomationExecutionPreview::totalAccounts))
            .setter(setter(Builder::totalAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalAccounts").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_PREVIEWS_FIELD,
            REGIONS_FIELD, TARGET_PREVIEWS_FIELD, TOTAL_ACCOUNTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, Integer> stepPreviews;

    private final List<String> regions;

    private final List<TargetPreview> targetPreviews;

    private final Integer totalAccounts;

    private AutomationExecutionPreview(BuilderImpl builder) {
        this.stepPreviews = builder.stepPreviews;
        this.regions = builder.regions;
        this.targetPreviews = builder.targetPreviews;
        this.totalAccounts = builder.totalAccounts;
    }

    /**
     * <p>
     * Information about the type of impact a runbook step would have on a resource.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Mutating</code>: The runbook step would make changes to the targets through actions that create, modify, or
     * delete resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Non_Mutating</code>: The runbook step would retrieve data about resources but not make changes to them.
     * This category generally includes <code>Describe*</code>, <code>List*</code>, <code>Get*</code>, and similar
     * read-only API actions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Undetermined</code>: An undetermined step invokes executions performed by another orchestration service
     * like Lambda, Step Functions, or Amazon Web Services Systems Manager Run Command. An undetermined step might also
     * call a third-party API. Systems Manager Automation doesn't know the outcome of the orchestration processes or
     * third-party API executions, so the results of the steps are undetermined.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStepPreviews} method.
     * </p>
     * 
     * @return Information about the type of impact a runbook step would have on a resource.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Mutating</code>: The runbook step would make changes to the targets through actions that create,
     *         modify, or delete resources.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Non_Mutating</code>: The runbook step would retrieve data about resources but not make changes to
     *         them. This category generally includes <code>Describe*</code>, <code>List*</code>, <code>Get*</code>, and
     *         similar read-only API actions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Undetermined</code>: An undetermined step invokes executions performed by another orchestration
     *         service like Lambda, Step Functions, or Amazon Web Services Systems Manager Run Command. An undetermined
     *         step might also call a third-party API. Systems Manager Automation doesn't know the outcome of the
     *         orchestration processes or third-party API executions, so the results of the steps are undetermined.
     *         </p>
     *         </li>
     */
    public final Map<ImpactType, Integer> stepPreviews() {
        return StepPreviewMapCopier.copyStringToEnum(stepPreviews);
    }

    /**
     * For responses, this returns true if the service returned a value for the StepPreviews property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStepPreviews() {
        return stepPreviews != null && !(stepPreviews instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Information about the type of impact a runbook step would have on a resource.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Mutating</code>: The runbook step would make changes to the targets through actions that create, modify, or
     * delete resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Non_Mutating</code>: The runbook step would retrieve data about resources but not make changes to them.
     * This category generally includes <code>Describe*</code>, <code>List*</code>, <code>Get*</code>, and similar
     * read-only API actions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Undetermined</code>: An undetermined step invokes executions performed by another orchestration service
     * like Lambda, Step Functions, or Amazon Web Services Systems Manager Run Command. An undetermined step might also
     * call a third-party API. Systems Manager Automation doesn't know the outcome of the orchestration processes or
     * third-party API executions, so the results of the steps are undetermined.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStepPreviews} method.
     * </p>
     * 
     * @return Information about the type of impact a runbook step would have on a resource.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Mutating</code>: The runbook step would make changes to the targets through actions that create,
     *         modify, or delete resources.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Non_Mutating</code>: The runbook step would retrieve data about resources but not make changes to
     *         them. This category generally includes <code>Describe*</code>, <code>List*</code>, <code>Get*</code>, and
     *         similar read-only API actions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Undetermined</code>: An undetermined step invokes executions performed by another orchestration
     *         service like Lambda, Step Functions, or Amazon Web Services Systems Manager Run Command. An undetermined
     *         step might also call a third-party API. Systems Manager Automation doesn't know the outcome of the
     *         orchestration processes or third-party API executions, so the results of the steps are undetermined.
     *         </p>
     *         </li>
     */
    public final Map<String, Integer> stepPreviewsAsStrings() {
        return stepPreviews;
    }

    /**
     * For responses, this returns true if the service returned a value for the Regions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRegions() {
        return regions != null && !(regions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the Amazon Web Services Regions targeted by the execution preview.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegions} method.
     * </p>
     * 
     * @return Information about the Amazon Web Services Regions targeted by the execution preview.
     */
    public final List<String> regions() {
        return regions;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetPreviews property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetPreviews() {
        return targetPreviews != null && !(targetPreviews instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information that provides a preview of what the impact of running the specified Automation runbook would be.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetPreviews} method.
     * </p>
     * 
     * @return Information that provides a preview of what the impact of running the specified Automation runbook would
     *         be.
     */
    public final List<TargetPreview> targetPreviews() {
        return targetPreviews;
    }

    /**
     * <p>
     * Information about the Amazon Web Services accounts that were included in the execution preview.
     * </p>
     * 
     * @return Information about the Amazon Web Services accounts that were included in the execution preview.
     */
    public final Integer totalAccounts() {
        return totalAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasStepPreviews() ? stepPreviewsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRegions() ? regions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetPreviews() ? targetPreviews() : null);
        hashCode = 31 * hashCode + Objects.hashCode(totalAccounts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationExecutionPreview)) {
            return false;
        }
        AutomationExecutionPreview other = (AutomationExecutionPreview) obj;
        return hasStepPreviews() == other.hasStepPreviews()
                && Objects.equals(stepPreviewsAsStrings(), other.stepPreviewsAsStrings()) && hasRegions() == other.hasRegions()
                && Objects.equals(regions(), other.regions()) && hasTargetPreviews() == other.hasTargetPreviews()
                && Objects.equals(targetPreviews(), other.targetPreviews())
                && Objects.equals(totalAccounts(), other.totalAccounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomationExecutionPreview")
                .add("StepPreviews", hasStepPreviews() ? stepPreviewsAsStrings() : null)
                .add("Regions", hasRegions() ? regions() : null)
                .add("TargetPreviews", hasTargetPreviews() ? targetPreviews() : null).add("TotalAccounts", totalAccounts())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StepPreviews":
            return Optional.ofNullable(clazz.cast(stepPreviewsAsStrings()));
        case "Regions":
            return Optional.ofNullable(clazz.cast(regions()));
        case "TargetPreviews":
            return Optional.ofNullable(clazz.cast(targetPreviews()));
        case "TotalAccounts":
            return Optional.ofNullable(clazz.cast(totalAccounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StepPreviews", STEP_PREVIEWS_FIELD);
        map.put("Regions", REGIONS_FIELD);
        map.put("TargetPreviews", TARGET_PREVIEWS_FIELD);
        map.put("TotalAccounts", TOTAL_ACCOUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomationExecutionPreview, T> g) {
        return obj -> g.apply((AutomationExecutionPreview) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomationExecutionPreview> {
        /**
         * <p>
         * Information about the type of impact a runbook step would have on a resource.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Mutating</code>: The runbook step would make changes to the targets through actions that create,
         * modify, or delete resources.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Non_Mutating</code>: The runbook step would retrieve data about resources but not make changes to them.
         * This category generally includes <code>Describe*</code>, <code>List*</code>, <code>Get*</code>, and similar
         * read-only API actions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Undetermined</code>: An undetermined step invokes executions performed by another orchestration service
         * like Lambda, Step Functions, or Amazon Web Services Systems Manager Run Command. An undetermined step might
         * also call a third-party API. Systems Manager Automation doesn't know the outcome of the orchestration
         * processes or third-party API executions, so the results of the steps are undetermined.
         * </p>
         * </li>
         * </ul>
         * 
         * @param stepPreviews
         *        Information about the type of impact a runbook step would have on a resource.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Mutating</code>: The runbook step would make changes to the targets through actions that create,
         *        modify, or delete resources.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Non_Mutating</code>: The runbook step would retrieve data about resources but not make changes
         *        to them. This category generally includes <code>Describe*</code>, <code>List*</code>,
         *        <code>Get*</code>, and similar read-only API actions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Undetermined</code>: An undetermined step invokes executions performed by another orchestration
         *        service like Lambda, Step Functions, or Amazon Web Services Systems Manager Run Command. An
         *        undetermined step might also call a third-party API. Systems Manager Automation doesn't know the
         *        outcome of the orchestration processes or third-party API executions, so the results of the steps are
         *        undetermined.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepPreviewsWithStrings(Map<String, Integer> stepPreviews);

        /**
         * <p>
         * Information about the type of impact a runbook step would have on a resource.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Mutating</code>: The runbook step would make changes to the targets through actions that create,
         * modify, or delete resources.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Non_Mutating</code>: The runbook step would retrieve data about resources but not make changes to them.
         * This category generally includes <code>Describe*</code>, <code>List*</code>, <code>Get*</code>, and similar
         * read-only API actions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Undetermined</code>: An undetermined step invokes executions performed by another orchestration service
         * like Lambda, Step Functions, or Amazon Web Services Systems Manager Run Command. An undetermined step might
         * also call a third-party API. Systems Manager Automation doesn't know the outcome of the orchestration
         * processes or third-party API executions, so the results of the steps are undetermined.
         * </p>
         * </li>
         * </ul>
         * 
         * @param stepPreviews
         *        Information about the type of impact a runbook step would have on a resource.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Mutating</code>: The runbook step would make changes to the targets through actions that create,
         *        modify, or delete resources.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Non_Mutating</code>: The runbook step would retrieve data about resources but not make changes
         *        to them. This category generally includes <code>Describe*</code>, <code>List*</code>,
         *        <code>Get*</code>, and similar read-only API actions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Undetermined</code>: An undetermined step invokes executions performed by another orchestration
         *        service like Lambda, Step Functions, or Amazon Web Services Systems Manager Run Command. An
         *        undetermined step might also call a third-party API. Systems Manager Automation doesn't know the
         *        outcome of the orchestration processes or third-party API executions, so the results of the steps are
         *        undetermined.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepPreviews(Map<ImpactType, Integer> stepPreviews);

        /**
         * <p>
         * Information about the Amazon Web Services Regions targeted by the execution preview.
         * </p>
         * 
         * @param regions
         *        Information about the Amazon Web Services Regions targeted by the execution preview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(Collection<String> regions);

        /**
         * <p>
         * Information about the Amazon Web Services Regions targeted by the execution preview.
         * </p>
         * 
         * @param regions
         *        Information about the Amazon Web Services Regions targeted by the execution preview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(String... regions);

        /**
         * <p>
         * Information that provides a preview of what the impact of running the specified Automation runbook would be.
         * </p>
         * 
         * @param targetPreviews
         *        Information that provides a preview of what the impact of running the specified Automation runbook
         *        would be.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetPreviews(Collection<TargetPreview> targetPreviews);

        /**
         * <p>
         * Information that provides a preview of what the impact of running the specified Automation runbook would be.
         * </p>
         * 
         * @param targetPreviews
         *        Information that provides a preview of what the impact of running the specified Automation runbook
         *        would be.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetPreviews(TargetPreview... targetPreviews);

        /**
         * <p>
         * Information that provides a preview of what the impact of running the specified Automation runbook would be.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssm.model.TargetPreview.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ssm.model.TargetPreview#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssm.model.TargetPreview.Builder#build()} is called immediately and its
         * result is passed to {@link #targetPreviews(List<TargetPreview>)}.
         * 
         * @param targetPreviews
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssm.model.TargetPreview.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetPreviews(java.util.Collection<TargetPreview>)
         */
        Builder targetPreviews(Consumer<TargetPreview.Builder>... targetPreviews);

        /**
         * <p>
         * Information about the Amazon Web Services accounts that were included in the execution preview.
         * </p>
         * 
         * @param totalAccounts
         *        Information about the Amazon Web Services accounts that were included in the execution preview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalAccounts(Integer totalAccounts);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, Integer> stepPreviews = DefaultSdkAutoConstructMap.getInstance();

        private List<String> regions = DefaultSdkAutoConstructList.getInstance();

        private List<TargetPreview> targetPreviews = DefaultSdkAutoConstructList.getInstance();

        private Integer totalAccounts;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationExecutionPreview model) {
            stepPreviewsWithStrings(model.stepPreviews);
            regions(model.regions);
            targetPreviews(model.targetPreviews);
            totalAccounts(model.totalAccounts);
        }

        public final Map<String, Integer> getStepPreviews() {
            if (stepPreviews instanceof SdkAutoConstructMap) {
                return null;
            }
            return stepPreviews;
        }

        public final void setStepPreviews(Map<String, Integer> stepPreviews) {
            this.stepPreviews = StepPreviewMapCopier.copy(stepPreviews);
        }

        @Override
        public final Builder stepPreviewsWithStrings(Map<String, Integer> stepPreviews) {
            this.stepPreviews = StepPreviewMapCopier.copy(stepPreviews);
            return this;
        }

        @Override
        public final Builder stepPreviews(Map<ImpactType, Integer> stepPreviews) {
            this.stepPreviews = StepPreviewMapCopier.copyEnumToString(stepPreviews);
            return this;
        }

        public final Collection<String> getRegions() {
            if (regions instanceof SdkAutoConstructList) {
                return null;
            }
            return regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String... regions) {
            regions(Arrays.asList(regions));
            return this;
        }

        public final List<TargetPreview.Builder> getTargetPreviews() {
            List<TargetPreview.Builder> result = TargetPreviewListCopier.copyToBuilder(this.targetPreviews);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetPreviews(Collection<TargetPreview.BuilderImpl> targetPreviews) {
            this.targetPreviews = TargetPreviewListCopier.copyFromBuilder(targetPreviews);
        }

        @Override
        public final Builder targetPreviews(Collection<TargetPreview> targetPreviews) {
            this.targetPreviews = TargetPreviewListCopier.copy(targetPreviews);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetPreviews(TargetPreview... targetPreviews) {
            targetPreviews(Arrays.asList(targetPreviews));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetPreviews(Consumer<TargetPreview.Builder>... targetPreviews) {
            targetPreviews(Stream.of(targetPreviews).map(c -> TargetPreview.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getTotalAccounts() {
            return totalAccounts;
        }

        public final void setTotalAccounts(Integer totalAccounts) {
            this.totalAccounts = totalAccounts;
        }

        @Override
        public final Builder totalAccounts(Integer totalAccounts) {
            this.totalAccounts = totalAccounts;
            return this;
        }

        @Override
        public AutomationExecutionPreview build() {
            return new AutomationExecutionPreview(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
