/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsResponse;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowIdentity;

public class DescribeMaintenanceWindowsIterable
implements SdkIterable<DescribeMaintenanceWindowsResponse> {
    private final SsmClient client;
    private final DescribeMaintenanceWindowsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeMaintenanceWindowsIterable(SsmClient client, DescribeMaintenanceWindowsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeMaintenanceWindowsResponseFetcher();
    }

    public Iterator<DescribeMaintenanceWindowsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MaintenanceWindowIdentity> windowIdentities() {
        Function<DescribeMaintenanceWindowsResponse, Iterator> getIterator = response -> {
            if (response != null && response.windowIdentities() != null) {
                return response.windowIdentities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeMaintenanceWindowsResponseFetcher
    implements SyncPageFetcher<DescribeMaintenanceWindowsResponse> {
        private DescribeMaintenanceWindowsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMaintenanceWindowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeMaintenanceWindowsResponse nextPage(DescribeMaintenanceWindowsResponse previousPage) {
            if (previousPage == null) {
                return DescribeMaintenanceWindowsIterable.this.client.describeMaintenanceWindows(DescribeMaintenanceWindowsIterable.this.firstRequest);
            }
            return DescribeMaintenanceWindowsIterable.this.client.describeMaintenanceWindows((DescribeMaintenanceWindowsRequest)((Object)DescribeMaintenanceWindowsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

