/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.ListResourceDataSyncRequest;
import software.amazon.awssdk.services.ssm.model.ListResourceDataSyncResponse;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncItem;

public class ListResourceDataSyncIterable
implements SdkIterable<ListResourceDataSyncResponse> {
    private final SsmClient client;
    private final ListResourceDataSyncRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResourceDataSyncIterable(SsmClient client, ListResourceDataSyncRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListResourceDataSyncResponseFetcher();
    }

    public Iterator<ListResourceDataSyncResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResourceDataSyncItem> resourceDataSyncItems() {
        Function<ListResourceDataSyncResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceDataSyncItems() != null) {
                return response.resourceDataSyncItems().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResourceDataSyncResponseFetcher
    implements SyncPageFetcher<ListResourceDataSyncResponse> {
        private ListResourceDataSyncResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceDataSyncResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResourceDataSyncResponse nextPage(ListResourceDataSyncResponse previousPage) {
            if (previousPage == null) {
                return ListResourceDataSyncIterable.this.client.listResourceDataSync(ListResourceDataSyncIterable.this.firstRequest);
            }
            return ListResourceDataSyncIterable.this.client.listResourceDataSync((ListResourceDataSyncRequest)((Object)ListResourceDataSyncIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

