/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.AlarmConfiguration;
import software.amazon.awssdk.services.ssm.model.AlarmStateInformation;
import software.amazon.awssdk.services.ssm.model.AlarmStateInformationListCopier;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MaintenanceWindowExecutionTaskIdentity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MaintenanceWindowExecutionTaskIdentity> {
    private static final SdkField<String> WINDOW_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WindowExecutionId").getter(MaintenanceWindowExecutionTaskIdentity.getter(MaintenanceWindowExecutionTaskIdentity::windowExecutionId)).setter(MaintenanceWindowExecutionTaskIdentity.setter(Builder::windowExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowExecutionId").build()}).build();
    private static final SdkField<String> TASK_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskExecutionId").getter(MaintenanceWindowExecutionTaskIdentity.getter(MaintenanceWindowExecutionTaskIdentity::taskExecutionId)).setter(MaintenanceWindowExecutionTaskIdentity.setter(Builder::taskExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskExecutionId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(MaintenanceWindowExecutionTaskIdentity.getter(MaintenanceWindowExecutionTaskIdentity::statusAsString)).setter(MaintenanceWindowExecutionTaskIdentity.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusDetails").getter(MaintenanceWindowExecutionTaskIdentity.getter(MaintenanceWindowExecutionTaskIdentity::statusDetails)).setter(MaintenanceWindowExecutionTaskIdentity.setter(Builder::statusDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDetails").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(MaintenanceWindowExecutionTaskIdentity.getter(MaintenanceWindowExecutionTaskIdentity::startTime)).setter(MaintenanceWindowExecutionTaskIdentity.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(MaintenanceWindowExecutionTaskIdentity.getter(MaintenanceWindowExecutionTaskIdentity::endTime)).setter(MaintenanceWindowExecutionTaskIdentity.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskArn").getter(MaintenanceWindowExecutionTaskIdentity.getter(MaintenanceWindowExecutionTaskIdentity::taskArn)).setter(MaintenanceWindowExecutionTaskIdentity.setter(Builder::taskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskArn").build()}).build();
    private static final SdkField<String> TASK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskType").getter(MaintenanceWindowExecutionTaskIdentity.getter(MaintenanceWindowExecutionTaskIdentity::taskTypeAsString)).setter(MaintenanceWindowExecutionTaskIdentity.setter(Builder::taskType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskType").build()}).build();
    private static final SdkField<AlarmConfiguration> ALARM_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AlarmConfiguration").getter(MaintenanceWindowExecutionTaskIdentity.getter(MaintenanceWindowExecutionTaskIdentity::alarmConfiguration)).setter(MaintenanceWindowExecutionTaskIdentity.setter(Builder::alarmConfiguration)).constructor(AlarmConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmConfiguration").build()}).build();
    private static final SdkField<List<AlarmStateInformation>> TRIGGERED_ALARMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TriggeredAlarms").getter(MaintenanceWindowExecutionTaskIdentity.getter(MaintenanceWindowExecutionTaskIdentity::triggeredAlarms)).setter(MaintenanceWindowExecutionTaskIdentity.setter(Builder::triggeredAlarms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggeredAlarms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AlarmStateInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_EXECUTION_ID_FIELD, TASK_EXECUTION_ID_FIELD, STATUS_FIELD, STATUS_DETAILS_FIELD, START_TIME_FIELD, END_TIME_FIELD, TASK_ARN_FIELD, TASK_TYPE_FIELD, ALARM_CONFIGURATION_FIELD, TRIGGERED_ALARMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MaintenanceWindowExecutionTaskIdentity.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String windowExecutionId;
    private final String taskExecutionId;
    private final String status;
    private final String statusDetails;
    private final Instant startTime;
    private final Instant endTime;
    private final String taskArn;
    private final String taskType;
    private final AlarmConfiguration alarmConfiguration;
    private final List<AlarmStateInformation> triggeredAlarms;

    private MaintenanceWindowExecutionTaskIdentity(BuilderImpl builder) {
        this.windowExecutionId = builder.windowExecutionId;
        this.taskExecutionId = builder.taskExecutionId;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.taskArn = builder.taskArn;
        this.taskType = builder.taskType;
        this.alarmConfiguration = builder.alarmConfiguration;
        this.triggeredAlarms = builder.triggeredAlarms;
    }

    public final String windowExecutionId() {
        return this.windowExecutionId;
    }

    public final String taskExecutionId() {
        return this.taskExecutionId;
    }

    public final MaintenanceWindowExecutionStatus status() {
        return MaintenanceWindowExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusDetails() {
        return this.statusDetails;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String taskArn() {
        return this.taskArn;
    }

    public final MaintenanceWindowTaskType taskType() {
        return MaintenanceWindowTaskType.fromValue(this.taskType);
    }

    public final String taskTypeAsString() {
        return this.taskType;
    }

    public final AlarmConfiguration alarmConfiguration() {
        return this.alarmConfiguration;
    }

    public final boolean hasTriggeredAlarms() {
        return this.triggeredAlarms != null && !(this.triggeredAlarms instanceof SdkAutoConstructList);
    }

    public final List<AlarmStateInformation> triggeredAlarms() {
        return this.triggeredAlarms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.windowExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTriggeredAlarms() ? this.triggeredAlarms() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowExecutionTaskIdentity)) {
            return false;
        }
        MaintenanceWindowExecutionTaskIdentity other = (MaintenanceWindowExecutionTaskIdentity)obj;
        return Objects.equals(this.windowExecutionId(), other.windowExecutionId()) && Objects.equals(this.taskExecutionId(), other.taskExecutionId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusDetails(), other.statusDetails()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.taskArn(), other.taskArn()) && Objects.equals(this.taskTypeAsString(), other.taskTypeAsString()) && Objects.equals(this.alarmConfiguration(), other.alarmConfiguration()) && this.hasTriggeredAlarms() == other.hasTriggeredAlarms() && Objects.equals(this.triggeredAlarms(), other.triggeredAlarms());
    }

    public final String toString() {
        return ToString.builder((String)"MaintenanceWindowExecutionTaskIdentity").add("WindowExecutionId", (Object)this.windowExecutionId()).add("TaskExecutionId", (Object)this.taskExecutionId()).add("Status", (Object)this.statusAsString()).add("StatusDetails", (Object)this.statusDetails()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("TaskArn", (Object)this.taskArn()).add("TaskType", (Object)this.taskTypeAsString()).add("AlarmConfiguration", (Object)this.alarmConfiguration()).add("TriggeredAlarms", this.hasTriggeredAlarms() ? this.triggeredAlarms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowExecutionId": {
                return Optional.ofNullable(clazz.cast(this.windowExecutionId()));
            }
            case "TaskExecutionId": {
                return Optional.ofNullable(clazz.cast(this.taskExecutionId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusDetails": {
                return Optional.ofNullable(clazz.cast(this.statusDetails()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "TaskArn": {
                return Optional.ofNullable(clazz.cast(this.taskArn()));
            }
            case "TaskType": {
                return Optional.ofNullable(clazz.cast(this.taskTypeAsString()));
            }
            case "AlarmConfiguration": {
                return Optional.ofNullable(clazz.cast(this.alarmConfiguration()));
            }
            case "TriggeredAlarms": {
                return Optional.ofNullable(clazz.cast(this.triggeredAlarms()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WindowExecutionId", WINDOW_EXECUTION_ID_FIELD);
        map.put("TaskExecutionId", TASK_EXECUTION_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusDetails", STATUS_DETAILS_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("TaskArn", TASK_ARN_FIELD);
        map.put("TaskType", TASK_TYPE_FIELD);
        map.put("AlarmConfiguration", ALARM_CONFIGURATION_FIELD);
        map.put("TriggeredAlarms", TRIGGERED_ALARMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MaintenanceWindowExecutionTaskIdentity, T> g) {
        return obj -> g.apply((MaintenanceWindowExecutionTaskIdentity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String windowExecutionId;
        private String taskExecutionId;
        private String status;
        private String statusDetails;
        private Instant startTime;
        private Instant endTime;
        private String taskArn;
        private String taskType;
        private AlarmConfiguration alarmConfiguration;
        private List<AlarmStateInformation> triggeredAlarms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowExecutionTaskIdentity model) {
            this.windowExecutionId(model.windowExecutionId);
            this.taskExecutionId(model.taskExecutionId);
            this.status(model.status);
            this.statusDetails(model.statusDetails);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.taskArn(model.taskArn);
            this.taskType(model.taskType);
            this.alarmConfiguration(model.alarmConfiguration);
            this.triggeredAlarms(model.triggeredAlarms);
        }

        public final String getWindowExecutionId() {
            return this.windowExecutionId;
        }

        public final void setWindowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
        }

        @Override
        public final Builder windowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
            return this;
        }

        public final String getTaskExecutionId() {
            return this.taskExecutionId;
        }

        public final void setTaskExecutionId(String taskExecutionId) {
            this.taskExecutionId = taskExecutionId;
        }

        @Override
        public final Builder taskExecutionId(String taskExecutionId) {
            this.taskExecutionId = taskExecutionId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MaintenanceWindowExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusDetails() {
            return this.statusDetails;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getTaskArn() {
            return this.taskArn;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final String getTaskType() {
            return this.taskType;
        }

        public final void setTaskType(String taskType) {
            this.taskType = taskType;
        }

        @Override
        public final Builder taskType(String taskType) {
            this.taskType = taskType;
            return this;
        }

        @Override
        public final Builder taskType(MaintenanceWindowTaskType taskType) {
            this.taskType(taskType == null ? null : taskType.toString());
            return this;
        }

        public final AlarmConfiguration.Builder getAlarmConfiguration() {
            return this.alarmConfiguration != null ? this.alarmConfiguration.toBuilder() : null;
        }

        public final void setAlarmConfiguration(AlarmConfiguration.BuilderImpl alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration != null ? alarmConfiguration.build() : null;
        }

        @Override
        public final Builder alarmConfiguration(AlarmConfiguration alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration;
            return this;
        }

        public final List<AlarmStateInformation.Builder> getTriggeredAlarms() {
            List<AlarmStateInformation.Builder> result = AlarmStateInformationListCopier.copyToBuilder(this.triggeredAlarms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTriggeredAlarms(Collection<AlarmStateInformation.BuilderImpl> triggeredAlarms) {
            this.triggeredAlarms = AlarmStateInformationListCopier.copyFromBuilder(triggeredAlarms);
        }

        @Override
        public final Builder triggeredAlarms(Collection<AlarmStateInformation> triggeredAlarms) {
            this.triggeredAlarms = AlarmStateInformationListCopier.copy(triggeredAlarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggeredAlarms(AlarmStateInformation ... triggeredAlarms) {
            this.triggeredAlarms(Arrays.asList(triggeredAlarms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggeredAlarms(Consumer<AlarmStateInformation.Builder> ... triggeredAlarms) {
            this.triggeredAlarms(Stream.of(triggeredAlarms).map(c -> (AlarmStateInformation)((AlarmStateInformation.Builder)AlarmStateInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public MaintenanceWindowExecutionTaskIdentity build() {
            return new MaintenanceWindowExecutionTaskIdentity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MaintenanceWindowExecutionTaskIdentity> {
        public Builder windowExecutionId(String var1);

        public Builder taskExecutionId(String var1);

        public Builder status(String var1);

        public Builder status(MaintenanceWindowExecutionStatus var1);

        public Builder statusDetails(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder taskArn(String var1);

        public Builder taskType(String var1);

        public Builder taskType(MaintenanceWindowTaskType var1);

        public Builder alarmConfiguration(AlarmConfiguration var1);

        default public Builder alarmConfiguration(Consumer<AlarmConfiguration.Builder> alarmConfiguration) {
            return this.alarmConfiguration((AlarmConfiguration)((AlarmConfiguration.Builder)AlarmConfiguration.builder().applyMutation(alarmConfiguration)).build());
        }

        public Builder triggeredAlarms(Collection<AlarmStateInformation> var1);

        public Builder triggeredAlarms(AlarmStateInformation ... var1);

        public Builder triggeredAlarms(Consumer<AlarmStateInformation.Builder> ... var1);
    }
}

