/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmincidents.model.SsmIncidentsRequest;
import software.amazon.awssdk.services.ssmincidents.model.UpdateReplicationSetAction;
import software.amazon.awssdk.services.ssmincidents.model.UpdateReplicationSetInputActionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateReplicationSetRequest
extends SsmIncidentsRequest
implements ToCopyableBuilder<Builder, UpdateReplicationSetRequest> {
    private static final SdkField<List<UpdateReplicationSetAction>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actions").getter(UpdateReplicationSetRequest.getter(UpdateReplicationSetRequest::actions)).setter(UpdateReplicationSetRequest.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpdateReplicationSetAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(UpdateReplicationSetRequest.getter(UpdateReplicationSetRequest::arn)).setter(UpdateReplicationSetRequest.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateReplicationSetRequest.getter(UpdateReplicationSetRequest::clientToken)).setter(UpdateReplicationSetRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_FIELD, ARN_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("actions", ACTIONS_FIELD);
            this.put("arn", ARN_FIELD);
            this.put("clientToken", CLIENT_TOKEN_FIELD);
        }
    });
    private final List<UpdateReplicationSetAction> actions;
    private final String arn;
    private final String clientToken;

    private UpdateReplicationSetRequest(BuilderImpl builder) {
        super(builder);
        this.actions = builder.actions;
        this.arn = builder.arn;
        this.clientToken = builder.clientToken;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<UpdateReplicationSetAction> actions() {
        return this.actions;
    }

    public final String arn() {
        return this.arn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateReplicationSetRequest)) {
            return false;
        }
        UpdateReplicationSetRequest other = (UpdateReplicationSetRequest)((Object)obj);
        return this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateReplicationSetRequest").add("Actions", this.hasActions() ? this.actions() : null).add("Arn", (Object)this.arn()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateReplicationSetRequest, T> g) {
        return obj -> g.apply((UpdateReplicationSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmIncidentsRequest.BuilderImpl
    implements Builder {
        private List<UpdateReplicationSetAction> actions = DefaultSdkAutoConstructList.getInstance();
        private String arn;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateReplicationSetRequest model) {
            super(model);
            this.actions(model.actions);
            this.arn(model.arn);
            this.clientToken(model.clientToken);
        }

        public final List<UpdateReplicationSetAction.Builder> getActions() {
            List<UpdateReplicationSetAction.Builder> result = UpdateReplicationSetInputActionsListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<UpdateReplicationSetAction.BuilderImpl> actions) {
            this.actions = UpdateReplicationSetInputActionsListCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<UpdateReplicationSetAction> actions) {
            this.actions = UpdateReplicationSetInputActionsListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(UpdateReplicationSetAction ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<UpdateReplicationSetAction.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (UpdateReplicationSetAction)((UpdateReplicationSetAction.Builder)UpdateReplicationSetAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateReplicationSetRequest build() {
            return new UpdateReplicationSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmIncidentsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateReplicationSetRequest> {
        public Builder actions(Collection<UpdateReplicationSetAction> var1);

        public Builder actions(UpdateReplicationSetAction ... var1);

        public Builder actions(Consumer<UpdateReplicationSetAction.Builder> ... var1);

        public Builder arn(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

