/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotificationTargetItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NotificationTargetItem> {
    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snsTopicArn").getter(NotificationTargetItem.getter(NotificationTargetItem::snsTopicArn)).setter(NotificationTargetItem.setter(Builder::snsTopicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snsTopicArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNS_TOPIC_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NotificationTargetItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String snsTopicArn;
    private final Type type;

    private NotificationTargetItem(BuilderImpl builder) {
        this.snsTopicArn = builder.snsTopicArn;
        this.type = builder.type;
    }

    public final String snsTopicArn() {
        return this.snsTopicArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationTargetItem)) {
            return false;
        }
        NotificationTargetItem other = (NotificationTargetItem)obj;
        return Objects.equals(this.snsTopicArn(), other.snsTopicArn());
    }

    public final String toString() {
        return ToString.builder((String)"NotificationTargetItem").add("SnsTopicArn", (Object)this.snsTopicArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "snsTopicArn": {
                return Optional.ofNullable(clazz.cast(this.snsTopicArn()));
            }
        }
        return Optional.empty();
    }

    public static NotificationTargetItem fromSnsTopicArn(String snsTopicArn) {
        return (NotificationTargetItem)NotificationTargetItem.builder().snsTopicArn(snsTopicArn).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("snsTopicArn", SNS_TOPIC_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NotificationTargetItem, T> g) {
        return obj -> g.apply((NotificationTargetItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        SNS_TOPIC_ARN,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String snsTopicArn;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationTargetItem model) {
            this.snsTopicArn(model.snsTopicArn);
        }

        public final String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            String oldValue = this.snsTopicArn;
            this.snsTopicArn = snsTopicArn;
            this.handleUnionValueChange(Type.SNS_TOPIC_ARN, oldValue, this.snsTopicArn);
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            String oldValue = this.snsTopicArn;
            this.snsTopicArn = snsTopicArn;
            this.handleUnionValueChange(Type.SNS_TOPIC_ARN, oldValue, this.snsTopicArn);
            return this;
        }

        public NotificationTargetItem build() {
            return new NotificationTargetItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NotificationTargetItem> {
        public Builder snsTopicArn(String var1);
    }
}

