/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmincidents.model.ChatChannel;
import software.amazon.awssdk.services.ssmincidents.model.IncidentRecordStatus;
import software.amazon.awssdk.services.ssmincidents.model.NotificationTargetItem;
import software.amazon.awssdk.services.ssmincidents.model.NotificationTargetSetCopier;
import software.amazon.awssdk.services.ssmincidents.model.SsmIncidentsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateIncidentRecordRequest
extends SsmIncidentsRequest
implements ToCopyableBuilder<Builder, UpdateIncidentRecordRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(UpdateIncidentRecordRequest.getter(UpdateIncidentRecordRequest::arn)).setter(UpdateIncidentRecordRequest.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<ChatChannel> CHAT_CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("chatChannel").getter(UpdateIncidentRecordRequest.getter(UpdateIncidentRecordRequest::chatChannel)).setter(UpdateIncidentRecordRequest.setter(Builder::chatChannel)).constructor(ChatChannel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chatChannel").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateIncidentRecordRequest.getter(UpdateIncidentRecordRequest::clientToken)).setter(UpdateIncidentRecordRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Integer> IMPACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("impact").getter(UpdateIncidentRecordRequest.getter(UpdateIncidentRecordRequest::impact)).setter(UpdateIncidentRecordRequest.setter(Builder::impact)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impact").build()}).build();
    private static final SdkField<List<NotificationTargetItem>> NOTIFICATION_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("notificationTargets").getter(UpdateIncidentRecordRequest.getter(UpdateIncidentRecordRequest::notificationTargets)).setter(UpdateIncidentRecordRequest.setter(Builder::notificationTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NotificationTargetItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UpdateIncidentRecordRequest.getter(UpdateIncidentRecordRequest::statusAsString)).setter(UpdateIncidentRecordRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("summary").getter(UpdateIncidentRecordRequest.getter(UpdateIncidentRecordRequest::summary)).setter(UpdateIncidentRecordRequest.setter(Builder::summary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summary").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(UpdateIncidentRecordRequest.getter(UpdateIncidentRecordRequest::title)).setter(UpdateIncidentRecordRequest.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CHAT_CHANNEL_FIELD, CLIENT_TOKEN_FIELD, IMPACT_FIELD, NOTIFICATION_TARGETS_FIELD, STATUS_FIELD, SUMMARY_FIELD, TITLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateIncidentRecordRequest.memberNameToFieldInitializer();
    private final String arn;
    private final ChatChannel chatChannel;
    private final String clientToken;
    private final Integer impact;
    private final List<NotificationTargetItem> notificationTargets;
    private final String status;
    private final String summary;
    private final String title;

    private UpdateIncidentRecordRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.chatChannel = builder.chatChannel;
        this.clientToken = builder.clientToken;
        this.impact = builder.impact;
        this.notificationTargets = builder.notificationTargets;
        this.status = builder.status;
        this.summary = builder.summary;
        this.title = builder.title;
    }

    public final String arn() {
        return this.arn;
    }

    public final ChatChannel chatChannel() {
        return this.chatChannel;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Integer impact() {
        return this.impact;
    }

    public final boolean hasNotificationTargets() {
        return this.notificationTargets != null && !(this.notificationTargets instanceof SdkAutoConstructList);
    }

    public final List<NotificationTargetItem> notificationTargets() {
        return this.notificationTargets;
    }

    public final IncidentRecordStatus status() {
        return IncidentRecordStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String summary() {
        return this.summary;
    }

    public final String title() {
        return this.title;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.chatChannel());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.impact());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotificationTargets() ? this.notificationTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.summary());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIncidentRecordRequest)) {
            return false;
        }
        UpdateIncidentRecordRequest other = (UpdateIncidentRecordRequest)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.chatChannel(), other.chatChannel()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.impact(), other.impact()) && this.hasNotificationTargets() == other.hasNotificationTargets() && Objects.equals(this.notificationTargets(), other.notificationTargets()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.summary(), other.summary()) && Objects.equals(this.title(), other.title());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateIncidentRecordRequest").add("Arn", (Object)this.arn()).add("ChatChannel", (Object)this.chatChannel()).add("ClientToken", (Object)this.clientToken()).add("Impact", (Object)this.impact()).add("NotificationTargets", this.hasNotificationTargets() ? this.notificationTargets() : null).add("Status", (Object)this.statusAsString()).add("Summary", (Object)this.summary()).add("Title", (Object)this.title()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "chatChannel": {
                return Optional.ofNullable(clazz.cast(this.chatChannel()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "impact": {
                return Optional.ofNullable(clazz.cast(this.impact()));
            }
            case "notificationTargets": {
                return Optional.ofNullable(clazz.cast(this.notificationTargets()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "summary": {
                return Optional.ofNullable(clazz.cast(this.summary()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("chatChannel", CHAT_CHANNEL_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("impact", IMPACT_FIELD);
        map.put("notificationTargets", NOTIFICATION_TARGETS_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("summary", SUMMARY_FIELD);
        map.put("title", TITLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateIncidentRecordRequest, T> g) {
        return obj -> g.apply((UpdateIncidentRecordRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmIncidentsRequest.BuilderImpl
    implements Builder {
        private String arn;
        private ChatChannel chatChannel;
        private String clientToken;
        private Integer impact;
        private List<NotificationTargetItem> notificationTargets = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String summary;
        private String title;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIncidentRecordRequest model) {
            super(model);
            this.arn(model.arn);
            this.chatChannel(model.chatChannel);
            this.clientToken(model.clientToken);
            this.impact(model.impact);
            this.notificationTargets(model.notificationTargets);
            this.status(model.status);
            this.summary(model.summary);
            this.title(model.title);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final ChatChannel.Builder getChatChannel() {
            return this.chatChannel != null ? this.chatChannel.toBuilder() : null;
        }

        public final void setChatChannel(ChatChannel.BuilderImpl chatChannel) {
            this.chatChannel = chatChannel != null ? chatChannel.build() : null;
        }

        @Override
        public final Builder chatChannel(ChatChannel chatChannel) {
            this.chatChannel = chatChannel;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Integer getImpact() {
            return this.impact;
        }

        public final void setImpact(Integer impact) {
            this.impact = impact;
        }

        @Override
        public final Builder impact(Integer impact) {
            this.impact = impact;
            return this;
        }

        public final List<NotificationTargetItem.Builder> getNotificationTargets() {
            List<NotificationTargetItem.Builder> result = NotificationTargetSetCopier.copyToBuilder(this.notificationTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotificationTargets(Collection<NotificationTargetItem.BuilderImpl> notificationTargets) {
            this.notificationTargets = NotificationTargetSetCopier.copyFromBuilder(notificationTargets);
        }

        @Override
        public final Builder notificationTargets(Collection<NotificationTargetItem> notificationTargets) {
            this.notificationTargets = NotificationTargetSetCopier.copy(notificationTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationTargets(NotificationTargetItem ... notificationTargets) {
            this.notificationTargets(Arrays.asList(notificationTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationTargets(Consumer<NotificationTargetItem.Builder> ... notificationTargets) {
            this.notificationTargets(Stream.of(notificationTargets).map(c -> (NotificationTargetItem)((NotificationTargetItem.Builder)NotificationTargetItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IncidentRecordStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSummary() {
            return this.summary;
        }

        public final void setSummary(String summary) {
            this.summary = summary;
        }

        @Override
        public final Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIncidentRecordRequest build() {
            return new UpdateIncidentRecordRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmIncidentsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateIncidentRecordRequest> {
        public Builder arn(String var1);

        public Builder chatChannel(ChatChannel var1);

        default public Builder chatChannel(Consumer<ChatChannel.Builder> chatChannel) {
            return this.chatChannel((ChatChannel)((ChatChannel.Builder)ChatChannel.builder().applyMutation(chatChannel)).build());
        }

        public Builder clientToken(String var1);

        public Builder impact(Integer var1);

        public Builder notificationTargets(Collection<NotificationTargetItem> var1);

        public Builder notificationTargets(NotificationTargetItem ... var1);

        public Builder notificationTargets(Consumer<NotificationTargetItem.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(IncidentRecordStatus var1);

        public Builder summary(String var1);

        public Builder title(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

