/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssoadmin.model.TokenIssuerAudiencesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthorizedTokenIssuer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthorizedTokenIssuer> {
    private static final SdkField<List<String>> AUTHORIZED_AUDIENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AuthorizedAudiences").getter(AuthorizedTokenIssuer.getter(AuthorizedTokenIssuer::authorizedAudiences)).setter(AuthorizedTokenIssuer.setter(Builder::authorizedAudiences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedAudiences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TRUSTED_TOKEN_ISSUER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrustedTokenIssuerArn").getter(AuthorizedTokenIssuer.getter(AuthorizedTokenIssuer::trustedTokenIssuerArn)).setter(AuthorizedTokenIssuer.setter(Builder::trustedTokenIssuerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedTokenIssuerArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZED_AUDIENCES_FIELD, TRUSTED_TOKEN_ISSUER_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AuthorizedAudiences", AUTHORIZED_AUDIENCES_FIELD);
            this.put("TrustedTokenIssuerArn", TRUSTED_TOKEN_ISSUER_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> authorizedAudiences;
    private final String trustedTokenIssuerArn;

    private AuthorizedTokenIssuer(BuilderImpl builder) {
        this.authorizedAudiences = builder.authorizedAudiences;
        this.trustedTokenIssuerArn = builder.trustedTokenIssuerArn;
    }

    public final boolean hasAuthorizedAudiences() {
        return this.authorizedAudiences != null && !(this.authorizedAudiences instanceof SdkAutoConstructList);
    }

    public final List<String> authorizedAudiences() {
        return this.authorizedAudiences;
    }

    public final String trustedTokenIssuerArn() {
        return this.trustedTokenIssuerArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthorizedAudiences() ? this.authorizedAudiences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.trustedTokenIssuerArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizedTokenIssuer)) {
            return false;
        }
        AuthorizedTokenIssuer other = (AuthorizedTokenIssuer)obj;
        return this.hasAuthorizedAudiences() == other.hasAuthorizedAudiences() && Objects.equals(this.authorizedAudiences(), other.authorizedAudiences()) && Objects.equals(this.trustedTokenIssuerArn(), other.trustedTokenIssuerArn());
    }

    public final String toString() {
        return ToString.builder((String)"AuthorizedTokenIssuer").add("AuthorizedAudiences", this.hasAuthorizedAudiences() ? this.authorizedAudiences() : null).add("TrustedTokenIssuerArn", (Object)this.trustedTokenIssuerArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthorizedAudiences": {
                return Optional.ofNullable(clazz.cast(this.authorizedAudiences()));
            }
            case "TrustedTokenIssuerArn": {
                return Optional.ofNullable(clazz.cast(this.trustedTokenIssuerArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AuthorizedTokenIssuer, T> g) {
        return obj -> g.apply((AuthorizedTokenIssuer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> authorizedAudiences = DefaultSdkAutoConstructList.getInstance();
        private String trustedTokenIssuerArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizedTokenIssuer model) {
            this.authorizedAudiences(model.authorizedAudiences);
            this.trustedTokenIssuerArn(model.trustedTokenIssuerArn);
        }

        public final Collection<String> getAuthorizedAudiences() {
            if (this.authorizedAudiences instanceof SdkAutoConstructList) {
                return null;
            }
            return this.authorizedAudiences;
        }

        public final void setAuthorizedAudiences(Collection<String> authorizedAudiences) {
            this.authorizedAudiences = TokenIssuerAudiencesCopier.copy(authorizedAudiences);
        }

        @Override
        public final Builder authorizedAudiences(Collection<String> authorizedAudiences) {
            this.authorizedAudiences = TokenIssuerAudiencesCopier.copy(authorizedAudiences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedAudiences(String ... authorizedAudiences) {
            this.authorizedAudiences(Arrays.asList(authorizedAudiences));
            return this;
        }

        public final String getTrustedTokenIssuerArn() {
            return this.trustedTokenIssuerArn;
        }

        public final void setTrustedTokenIssuerArn(String trustedTokenIssuerArn) {
            this.trustedTokenIssuerArn = trustedTokenIssuerArn;
        }

        @Override
        public final Builder trustedTokenIssuerArn(String trustedTokenIssuerArn) {
            this.trustedTokenIssuerArn = trustedTokenIssuerArn;
            return this;
        }

        public AuthorizedTokenIssuer build() {
            return new AuthorizedTokenIssuer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthorizedTokenIssuer> {
        public Builder authorizedAudiences(Collection<String> var1);

        public Builder authorizedAudiences(String ... var1);

        public Builder trustedTokenIssuerArn(String var1);
    }
}

