/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that describes an application that uses IAM Identity Center for access management.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Application implements SdkPojo, Serializable, ToCopyableBuilder<Application.Builder, Application> {
    private static final SdkField<String> APPLICATION_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationAccount").getter(getter(Application::applicationAccount))
            .setter(setter(Builder::applicationAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationAccount").build())
            .build();

    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationArn").getter(getter(Application::applicationArn)).setter(setter(Builder::applicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").build()).build();

    private static final SdkField<String> APPLICATION_PROVIDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationProviderArn").getter(getter(Application::applicationProviderArn))
            .setter(setter(Builder::applicationProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationProviderArn").build())
            .build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedDate").getter(getter(Application::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Application::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceArn").getter(getter(Application::instanceArn)).setter(setter(Builder::instanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Application::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<PortalOptions> PORTAL_OPTIONS_FIELD = SdkField
            .<PortalOptions> builder(MarshallingType.SDK_POJO).memberName("PortalOptions")
            .getter(getter(Application::portalOptions)).setter(setter(Builder::portalOptions))
            .constructor(PortalOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortalOptions").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Application::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ACCOUNT_FIELD,
            APPLICATION_ARN_FIELD, APPLICATION_PROVIDER_ARN_FIELD, CREATED_DATE_FIELD, DESCRIPTION_FIELD, INSTANCE_ARN_FIELD,
            NAME_FIELD, PORTAL_OPTIONS_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String applicationAccount;

    private final String applicationArn;

    private final String applicationProviderArn;

    private final Instant createdDate;

    private final String description;

    private final String instanceArn;

    private final String name;

    private final PortalOptions portalOptions;

    private final String status;

    private Application(BuilderImpl builder) {
        this.applicationAccount = builder.applicationAccount;
        this.applicationArn = builder.applicationArn;
        this.applicationProviderArn = builder.applicationProviderArn;
        this.createdDate = builder.createdDate;
        this.description = builder.description;
        this.instanceArn = builder.instanceArn;
        this.name = builder.name;
        this.portalOptions = builder.portalOptions;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Web Services account ID number of the application.
     * </p>
     * 
     * @return The Amazon Web Services account ID number of the application.
     */
    public final String applicationAccount() {
        return applicationAccount;
    }

    /**
     * <p>
     * The ARN of the application.
     * </p>
     * 
     * @return The ARN of the application.
     */
    public final String applicationArn() {
        return applicationArn;
    }

    /**
     * <p>
     * The ARN of the application provider for this application.
     * </p>
     * 
     * @return The ARN of the application provider for this application.
     */
    public final String applicationProviderArn() {
        return applicationProviderArn;
    }

    /**
     * <p>
     * The date and time when the application was originally created.
     * </p>
     * 
     * @return The date and time when the application was originally created.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The description of the application.
     * </p>
     * 
     * @return The description of the application.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ARN of the instance of IAM Identity Center that is configured with this application.
     * </p>
     * 
     * @return The ARN of the instance of IAM Identity Center that is configured with this application.
     */
    public final String instanceArn() {
        return instanceArn;
    }

    /**
     * <p>
     * The name of the application.
     * </p>
     * 
     * @return The name of the application.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A structure that describes the options for the access portal associated with this application.
     * </p>
     * 
     * @return A structure that describes the options for the access portal associated with this application.
     */
    public final PortalOptions portalOptions() {
        return portalOptions;
    }

    /**
     * <p>
     * The current status of the application in this instance of IAM Identity Center.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the application in this instance of IAM Identity Center.
     * @see ApplicationStatus
     */
    public final ApplicationStatus status() {
        return ApplicationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the application in this instance of IAM Identity Center.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the application in this instance of IAM Identity Center.
     * @see ApplicationStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationAccount());
        hashCode = 31 * hashCode + Objects.hashCode(applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(applicationProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(portalOptions());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Application)) {
            return false;
        }
        Application other = (Application) obj;
        return Objects.equals(applicationAccount(), other.applicationAccount())
                && Objects.equals(applicationArn(), other.applicationArn())
                && Objects.equals(applicationProviderArn(), other.applicationProviderArn())
                && Objects.equals(createdDate(), other.createdDate()) && Objects.equals(description(), other.description())
                && Objects.equals(instanceArn(), other.instanceArn()) && Objects.equals(name(), other.name())
                && Objects.equals(portalOptions(), other.portalOptions())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Application").add("ApplicationAccount", applicationAccount())
                .add("ApplicationArn", applicationArn()).add("ApplicationProviderArn", applicationProviderArn())
                .add("CreatedDate", createdDate()).add("Description", description()).add("InstanceArn", instanceArn())
                .add("Name", name()).add("PortalOptions", portalOptions()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationAccount":
            return Optional.ofNullable(clazz.cast(applicationAccount()));
        case "ApplicationArn":
            return Optional.ofNullable(clazz.cast(applicationArn()));
        case "ApplicationProviderArn":
            return Optional.ofNullable(clazz.cast(applicationProviderArn()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "InstanceArn":
            return Optional.ofNullable(clazz.cast(instanceArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "PortalOptions":
            return Optional.ofNullable(clazz.cast(portalOptions()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationAccount", APPLICATION_ACCOUNT_FIELD);
        map.put("ApplicationArn", APPLICATION_ARN_FIELD);
        map.put("ApplicationProviderArn", APPLICATION_PROVIDER_ARN_FIELD);
        map.put("CreatedDate", CREATED_DATE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("InstanceArn", INSTANCE_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("PortalOptions", PORTAL_OPTIONS_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Application, T> g) {
        return obj -> g.apply((Application) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Application> {
        /**
         * <p>
         * The Amazon Web Services account ID number of the application.
         * </p>
         * 
         * @param applicationAccount
         *        The Amazon Web Services account ID number of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationAccount(String applicationAccount);

        /**
         * <p>
         * The ARN of the application.
         * </p>
         * 
         * @param applicationArn
         *        The ARN of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationArn(String applicationArn);

        /**
         * <p>
         * The ARN of the application provider for this application.
         * </p>
         * 
         * @param applicationProviderArn
         *        The ARN of the application provider for this application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationProviderArn(String applicationProviderArn);

        /**
         * <p>
         * The date and time when the application was originally created.
         * </p>
         * 
         * @param createdDate
         *        The date and time when the application was originally created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The description of the application.
         * </p>
         * 
         * @param description
         *        The description of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ARN of the instance of IAM Identity Center that is configured with this application.
         * </p>
         * 
         * @param instanceArn
         *        The ARN of the instance of IAM Identity Center that is configured with this application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceArn(String instanceArn);

        /**
         * <p>
         * The name of the application.
         * </p>
         * 
         * @param name
         *        The name of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A structure that describes the options for the access portal associated with this application.
         * </p>
         * 
         * @param portalOptions
         *        A structure that describes the options for the access portal associated with this application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalOptions(PortalOptions portalOptions);

        /**
         * <p>
         * A structure that describes the options for the access portal associated with this application.
         * </p>
         * This is a convenience method that creates an instance of the {@link PortalOptions.Builder} avoiding the need
         * to create one manually via {@link PortalOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PortalOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #portalOptions(PortalOptions)}.
         * 
         * @param portalOptions
         *        a consumer that will call methods on {@link PortalOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portalOptions(PortalOptions)
         */
        default Builder portalOptions(Consumer<PortalOptions.Builder> portalOptions) {
            return portalOptions(PortalOptions.builder().applyMutation(portalOptions).build());
        }

        /**
         * <p>
         * The current status of the application in this instance of IAM Identity Center.
         * </p>
         * 
         * @param status
         *        The current status of the application in this instance of IAM Identity Center.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the application in this instance of IAM Identity Center.
         * </p>
         * 
         * @param status
         *        The current status of the application in this instance of IAM Identity Center.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder status(ApplicationStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String applicationAccount;

        private String applicationArn;

        private String applicationProviderArn;

        private Instant createdDate;

        private String description;

        private String instanceArn;

        private String name;

        private PortalOptions portalOptions;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(Application model) {
            applicationAccount(model.applicationAccount);
            applicationArn(model.applicationArn);
            applicationProviderArn(model.applicationProviderArn);
            createdDate(model.createdDate);
            description(model.description);
            instanceArn(model.instanceArn);
            name(model.name);
            portalOptions(model.portalOptions);
            status(model.status);
        }

        public final String getApplicationAccount() {
            return applicationAccount;
        }

        public final void setApplicationAccount(String applicationAccount) {
            this.applicationAccount = applicationAccount;
        }

        @Override
        public final Builder applicationAccount(String applicationAccount) {
            this.applicationAccount = applicationAccount;
            return this;
        }

        public final String getApplicationArn() {
            return applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getApplicationProviderArn() {
            return applicationProviderArn;
        }

        public final void setApplicationProviderArn(String applicationProviderArn) {
            this.applicationProviderArn = applicationProviderArn;
        }

        @Override
        public final Builder applicationProviderArn(String applicationProviderArn) {
            this.applicationProviderArn = applicationProviderArn;
            return this;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getInstanceArn() {
            return instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PortalOptions.Builder getPortalOptions() {
            return portalOptions != null ? portalOptions.toBuilder() : null;
        }

        public final void setPortalOptions(PortalOptions.BuilderImpl portalOptions) {
            this.portalOptions = portalOptions != null ? portalOptions.build() : null;
        }

        @Override
        public final Builder portalOptions(PortalOptions portalOptions) {
            this.portalOptions = portalOptions;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApplicationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Application build() {
            return new Application(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
