/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that describes a filter for applications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListApplicationsFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ListApplicationsFilter.Builder, ListApplicationsFilter> {
    private static final SdkField<String> APPLICATION_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationAccount").getter(getter(ListApplicationsFilter::applicationAccount))
            .setter(setter(Builder::applicationAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationAccount").build())
            .build();

    private static final SdkField<String> APPLICATION_PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationProvider").getter(getter(ListApplicationsFilter::applicationProvider))
            .setter(setter(Builder::applicationProvider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationProvider").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ACCOUNT_FIELD,
            APPLICATION_PROVIDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String applicationAccount;

    private final String applicationProvider;

    private ListApplicationsFilter(BuilderImpl builder) {
        this.applicationAccount = builder.applicationAccount;
        this.applicationProvider = builder.applicationProvider;
    }

    /**
     * <p>
     * An Amazon Web Services account ID number that filters the results in the response.
     * </p>
     * 
     * @return An Amazon Web Services account ID number that filters the results in the response.
     */
    public final String applicationAccount() {
        return applicationAccount;
    }

    /**
     * <p>
     * The ARN of an application provider that can filter the results in the response.
     * </p>
     * 
     * @return The ARN of an application provider that can filter the results in the response.
     */
    public final String applicationProvider() {
        return applicationProvider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationAccount());
        hashCode = 31 * hashCode + Objects.hashCode(applicationProvider());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationsFilter)) {
            return false;
        }
        ListApplicationsFilter other = (ListApplicationsFilter) obj;
        return Objects.equals(applicationAccount(), other.applicationAccount())
                && Objects.equals(applicationProvider(), other.applicationProvider());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListApplicationsFilter").add("ApplicationAccount", applicationAccount())
                .add("ApplicationProvider", applicationProvider()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationAccount":
            return Optional.ofNullable(clazz.cast(applicationAccount()));
        case "ApplicationProvider":
            return Optional.ofNullable(clazz.cast(applicationProvider()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationAccount", APPLICATION_ACCOUNT_FIELD);
        map.put("ApplicationProvider", APPLICATION_PROVIDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationsFilter, T> g) {
        return obj -> g.apply((ListApplicationsFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListApplicationsFilter> {
        /**
         * <p>
         * An Amazon Web Services account ID number that filters the results in the response.
         * </p>
         * 
         * @param applicationAccount
         *        An Amazon Web Services account ID number that filters the results in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationAccount(String applicationAccount);

        /**
         * <p>
         * The ARN of an application provider that can filter the results in the response.
         * </p>
         * 
         * @param applicationProvider
         *        The ARN of an application provider that can filter the results in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationProvider(String applicationProvider);
    }

    static final class BuilderImpl implements Builder {
        private String applicationAccount;

        private String applicationProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationsFilter model) {
            applicationAccount(model.applicationAccount);
            applicationProvider(model.applicationProvider);
        }

        public final String getApplicationAccount() {
            return applicationAccount;
        }

        public final void setApplicationAccount(String applicationAccount) {
            this.applicationAccount = applicationAccount;
        }

        @Override
        public final Builder applicationAccount(String applicationAccount) {
            this.applicationAccount = applicationAccount;
            return this;
        }

        public final String getApplicationProvider() {
            return applicationProvider;
        }

        public final void setApplicationProvider(String applicationProvider) {
            this.applicationProvider = applicationProvider;
        }

        @Override
        public final Builder applicationProvider(String applicationProvider) {
            this.applicationProvider = applicationProvider;
            return this;
        }

        @Override
        public ListApplicationsFilter build() {
            return new ListApplicationsFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
