/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListManagedPoliciesInPermissionSetResponse extends SsoAdminResponse implements
        ToCopyableBuilder<ListManagedPoliciesInPermissionSetResponse.Builder, ListManagedPoliciesInPermissionSetResponse> {
    private static final SdkField<List<AttachedManagedPolicy>> ATTACHED_MANAGED_POLICIES_FIELD = SdkField
            .<List<AttachedManagedPolicy>> builder(MarshallingType.LIST)
            .memberName("AttachedManagedPolicies")
            .getter(getter(ListManagedPoliciesInPermissionSetResponse::attachedManagedPolicies))
            .setter(setter(Builder::attachedManagedPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachedManagedPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttachedManagedPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttachedManagedPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListManagedPoliciesInPermissionSetResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ATTACHED_MANAGED_POLICIES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AttachedManagedPolicy> attachedManagedPolicies;

    private final String nextToken;

    private ListManagedPoliciesInPermissionSetResponse(BuilderImpl builder) {
        super(builder);
        this.attachedManagedPolicies = builder.attachedManagedPolicies;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttachedManagedPolicies property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAttachedManagedPolicies() {
        return attachedManagedPolicies != null && !(attachedManagedPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of the <a>AttachedManagedPolicy</a> data type object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttachedManagedPolicies} method.
     * </p>
     * 
     * @return An array of the <a>AttachedManagedPolicy</a> data type object.
     */
    public final List<AttachedManagedPolicy> attachedManagedPolicies() {
        return attachedManagedPolicies;
    }

    /**
     * <p>
     * The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make
     * subsequent calls.
     * </p>
     * 
     * @return The pagination token for the list API. Initially the value is null. Use the output of previous API calls
     *         to make subsequent calls.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachedManagedPolicies() ? attachedManagedPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListManagedPoliciesInPermissionSetResponse)) {
            return false;
        }
        ListManagedPoliciesInPermissionSetResponse other = (ListManagedPoliciesInPermissionSetResponse) obj;
        return hasAttachedManagedPolicies() == other.hasAttachedManagedPolicies()
                && Objects.equals(attachedManagedPolicies(), other.attachedManagedPolicies())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListManagedPoliciesInPermissionSetResponse")
                .add("AttachedManagedPolicies", hasAttachedManagedPolicies() ? attachedManagedPolicies() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttachedManagedPolicies":
            return Optional.ofNullable(clazz.cast(attachedManagedPolicies()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AttachedManagedPolicies", ATTACHED_MANAGED_POLICIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListManagedPoliciesInPermissionSetResponse, T> g) {
        return obj -> g.apply((ListManagedPoliciesInPermissionSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListManagedPoliciesInPermissionSetResponse> {
        /**
         * <p>
         * An array of the <a>AttachedManagedPolicy</a> data type object.
         * </p>
         * 
         * @param attachedManagedPolicies
         *        An array of the <a>AttachedManagedPolicy</a> data type object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachedManagedPolicies(Collection<AttachedManagedPolicy> attachedManagedPolicies);

        /**
         * <p>
         * An array of the <a>AttachedManagedPolicy</a> data type object.
         * </p>
         * 
         * @param attachedManagedPolicies
         *        An array of the <a>AttachedManagedPolicy</a> data type object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachedManagedPolicies(AttachedManagedPolicy... attachedManagedPolicies);

        /**
         * <p>
         * An array of the <a>AttachedManagedPolicy</a> data type object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssoadmin.model.AttachedManagedPolicy.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ssoadmin.model.AttachedManagedPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssoadmin.model.AttachedManagedPolicy.Builder#build()} is called
         * immediately and its result is passed to {@link #attachedManagedPolicies(List<AttachedManagedPolicy>)}.
         * 
         * @param attachedManagedPolicies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssoadmin.model.AttachedManagedPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachedManagedPolicies(java.util.Collection<AttachedManagedPolicy>)
         */
        Builder attachedManagedPolicies(Consumer<AttachedManagedPolicy.Builder>... attachedManagedPolicies);

        /**
         * <p>
         * The pagination token for the list API. Initially the value is null. Use the output of previous API calls to
         * make subsequent calls.
         * </p>
         * 
         * @param nextToken
         *        The pagination token for the list API. Initially the value is null. Use the output of previous API
         *        calls to make subsequent calls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsoAdminResponse.BuilderImpl implements Builder {
        private List<AttachedManagedPolicy> attachedManagedPolicies = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListManagedPoliciesInPermissionSetResponse model) {
            super(model);
            attachedManagedPolicies(model.attachedManagedPolicies);
            nextToken(model.nextToken);
        }

        public final List<AttachedManagedPolicy.Builder> getAttachedManagedPolicies() {
            List<AttachedManagedPolicy.Builder> result = AttachedManagedPolicyListCopier
                    .copyToBuilder(this.attachedManagedPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachedManagedPolicies(Collection<AttachedManagedPolicy.BuilderImpl> attachedManagedPolicies) {
            this.attachedManagedPolicies = AttachedManagedPolicyListCopier.copyFromBuilder(attachedManagedPolicies);
        }

        @Override
        public final Builder attachedManagedPolicies(Collection<AttachedManagedPolicy> attachedManagedPolicies) {
            this.attachedManagedPolicies = AttachedManagedPolicyListCopier.copy(attachedManagedPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedManagedPolicies(AttachedManagedPolicy... attachedManagedPolicies) {
            attachedManagedPolicies(Arrays.asList(attachedManagedPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedManagedPolicies(Consumer<AttachedManagedPolicy.Builder>... attachedManagedPolicies) {
            attachedManagedPolicies(Stream.of(attachedManagedPolicies)
                    .map(c -> AttachedManagedPolicy.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListManagedPoliciesInPermissionSetResponse build() {
            return new ListManagedPoliciesInPermissionSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
