/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that describes details for an IAM Identity Center access scope that is associated with a resource server.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceServerScopeDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceServerScopeDetails.Builder, ResourceServerScopeDetails> {
    private static final SdkField<String> DETAILED_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetailedTitle").getter(getter(ResourceServerScopeDetails::detailedTitle))
            .setter(setter(Builder::detailedTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailedTitle").build()).build();

    private static final SdkField<String> LONG_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LongDescription").getter(getter(ResourceServerScopeDetails::longDescription))
            .setter(setter(Builder::longDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LongDescription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAILED_TITLE_FIELD,
            LONG_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String detailedTitle;

    private final String longDescription;

    private ResourceServerScopeDetails(BuilderImpl builder) {
        this.detailedTitle = builder.detailedTitle;
        this.longDescription = builder.longDescription;
    }

    /**
     * <p>
     * The title of an access scope for a resource server.
     * </p>
     * 
     * @return The title of an access scope for a resource server.
     */
    public final String detailedTitle() {
        return detailedTitle;
    }

    /**
     * <p>
     * The description of an access scope for a resource server.
     * </p>
     * 
     * @return The description of an access scope for a resource server.
     */
    public final String longDescription() {
        return longDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(detailedTitle());
        hashCode = 31 * hashCode + Objects.hashCode(longDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceServerScopeDetails)) {
            return false;
        }
        ResourceServerScopeDetails other = (ResourceServerScopeDetails) obj;
        return Objects.equals(detailedTitle(), other.detailedTitle())
                && Objects.equals(longDescription(), other.longDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceServerScopeDetails").add("DetailedTitle", detailedTitle())
                .add("LongDescription", longDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetailedTitle":
            return Optional.ofNullable(clazz.cast(detailedTitle()));
        case "LongDescription":
            return Optional.ofNullable(clazz.cast(longDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DetailedTitle", DETAILED_TITLE_FIELD);
        map.put("LongDescription", LONG_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceServerScopeDetails, T> g) {
        return obj -> g.apply((ResourceServerScopeDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceServerScopeDetails> {
        /**
         * <p>
         * The title of an access scope for a resource server.
         * </p>
         * 
         * @param detailedTitle
         *        The title of an access scope for a resource server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detailedTitle(String detailedTitle);

        /**
         * <p>
         * The description of an access scope for a resource server.
         * </p>
         * 
         * @param longDescription
         *        The description of an access scope for a resource server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longDescription(String longDescription);
    }

    static final class BuilderImpl implements Builder {
        private String detailedTitle;

        private String longDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceServerScopeDetails model) {
            detailedTitle(model.detailedTitle);
            longDescription(model.longDescription);
        }

        public final String getDetailedTitle() {
            return detailedTitle;
        }

        public final void setDetailedTitle(String detailedTitle) {
            this.detailedTitle = detailedTitle;
        }

        @Override
        public final Builder detailedTitle(String detailedTitle) {
            this.detailedTitle = detailedTitle;
            return this;
        }

        public final String getLongDescription() {
            return longDescription;
        }

        public final void setLongDescription(String longDescription) {
            this.longDescription = longDescription;
        }

        @Override
        public final Builder longDescription(String longDescription) {
            this.longDescription = longDescription;
            return this;
        }

        @Override
        public ResourceServerScopeDetails build() {
            return new ResourceServerScopeDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
