/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FileSystemAssociationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FileSystemAssociationSummary> {
    private static final SdkField<String> FILE_SYSTEM_ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemAssociationId").getter(FileSystemAssociationSummary.getter(FileSystemAssociationSummary::fileSystemAssociationId)).setter(FileSystemAssociationSummary.setter(Builder::fileSystemAssociationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemAssociationId").build()}).build();
    private static final SdkField<String> FILE_SYSTEM_ASSOCIATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemAssociationARN").getter(FileSystemAssociationSummary.getter(FileSystemAssociationSummary::fileSystemAssociationARN)).setter(FileSystemAssociationSummary.setter(Builder::fileSystemAssociationARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemAssociationARN").build()}).build();
    private static final SdkField<String> FILE_SYSTEM_ASSOCIATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemAssociationStatus").getter(FileSystemAssociationSummary.getter(FileSystemAssociationSummary::fileSystemAssociationStatus)).setter(FileSystemAssociationSummary.setter(Builder::fileSystemAssociationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemAssociationStatus").build()}).build();
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayARN").getter(FileSystemAssociationSummary.getter(FileSystemAssociationSummary::gatewayARN)).setter(FileSystemAssociationSummary.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ASSOCIATION_ID_FIELD, FILE_SYSTEM_ASSOCIATION_ARN_FIELD, FILE_SYSTEM_ASSOCIATION_STATUS_FIELD, GATEWAY_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FileSystemAssociationId", FILE_SYSTEM_ASSOCIATION_ID_FIELD);
            this.put("FileSystemAssociationARN", FILE_SYSTEM_ASSOCIATION_ARN_FIELD);
            this.put("FileSystemAssociationStatus", FILE_SYSTEM_ASSOCIATION_STATUS_FIELD);
            this.put("GatewayARN", GATEWAY_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String fileSystemAssociationId;
    private final String fileSystemAssociationARN;
    private final String fileSystemAssociationStatus;
    private final String gatewayARN;

    private FileSystemAssociationSummary(BuilderImpl builder) {
        this.fileSystemAssociationId = builder.fileSystemAssociationId;
        this.fileSystemAssociationARN = builder.fileSystemAssociationARN;
        this.fileSystemAssociationStatus = builder.fileSystemAssociationStatus;
        this.gatewayARN = builder.gatewayARN;
    }

    public final String fileSystemAssociationId() {
        return this.fileSystemAssociationId;
    }

    public final String fileSystemAssociationARN() {
        return this.fileSystemAssociationARN;
    }

    public final String fileSystemAssociationStatus() {
        return this.fileSystemAssociationStatus;
    }

    public final String gatewayARN() {
        return this.gatewayARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemAssociationARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemAssociationStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileSystemAssociationSummary)) {
            return false;
        }
        FileSystemAssociationSummary other = (FileSystemAssociationSummary)obj;
        return Objects.equals(this.fileSystemAssociationId(), other.fileSystemAssociationId()) && Objects.equals(this.fileSystemAssociationARN(), other.fileSystemAssociationARN()) && Objects.equals(this.fileSystemAssociationStatus(), other.fileSystemAssociationStatus()) && Objects.equals(this.gatewayARN(), other.gatewayARN());
    }

    public final String toString() {
        return ToString.builder((String)"FileSystemAssociationSummary").add("FileSystemAssociationId", (Object)this.fileSystemAssociationId()).add("FileSystemAssociationARN", (Object)this.fileSystemAssociationARN()).add("FileSystemAssociationStatus", (Object)this.fileSystemAssociationStatus()).add("GatewayARN", (Object)this.gatewayARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileSystemAssociationId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemAssociationId()));
            }
            case "FileSystemAssociationARN": {
                return Optional.ofNullable(clazz.cast(this.fileSystemAssociationARN()));
            }
            case "FileSystemAssociationStatus": {
                return Optional.ofNullable(clazz.cast(this.fileSystemAssociationStatus()));
            }
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FileSystemAssociationSummary, T> g) {
        return obj -> g.apply((FileSystemAssociationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fileSystemAssociationId;
        private String fileSystemAssociationARN;
        private String fileSystemAssociationStatus;
        private String gatewayARN;

        private BuilderImpl() {
        }

        private BuilderImpl(FileSystemAssociationSummary model) {
            this.fileSystemAssociationId(model.fileSystemAssociationId);
            this.fileSystemAssociationARN(model.fileSystemAssociationARN);
            this.fileSystemAssociationStatus(model.fileSystemAssociationStatus);
            this.gatewayARN(model.gatewayARN);
        }

        public final String getFileSystemAssociationId() {
            return this.fileSystemAssociationId;
        }

        public final void setFileSystemAssociationId(String fileSystemAssociationId) {
            this.fileSystemAssociationId = fileSystemAssociationId;
        }

        @Override
        public final Builder fileSystemAssociationId(String fileSystemAssociationId) {
            this.fileSystemAssociationId = fileSystemAssociationId;
            return this;
        }

        public final String getFileSystemAssociationARN() {
            return this.fileSystemAssociationARN;
        }

        public final void setFileSystemAssociationARN(String fileSystemAssociationARN) {
            this.fileSystemAssociationARN = fileSystemAssociationARN;
        }

        @Override
        public final Builder fileSystemAssociationARN(String fileSystemAssociationARN) {
            this.fileSystemAssociationARN = fileSystemAssociationARN;
            return this;
        }

        public final String getFileSystemAssociationStatus() {
            return this.fileSystemAssociationStatus;
        }

        public final void setFileSystemAssociationStatus(String fileSystemAssociationStatus) {
            this.fileSystemAssociationStatus = fileSystemAssociationStatus;
        }

        @Override
        public final Builder fileSystemAssociationStatus(String fileSystemAssociationStatus) {
            this.fileSystemAssociationStatus = fileSystemAssociationStatus;
            return this;
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public FileSystemAssociationSummary build() {
            return new FileSystemAssociationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FileSystemAssociationSummary> {
        public Builder fileSystemAssociationId(String var1);

        public Builder fileSystemAssociationARN(String var1);

        public Builder fileSystemAssociationStatus(String var1);

        public Builder gatewayARN(String var1);
    }
}

