/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains all informational fields associated with a cache report. Includes name, ARN, tags, status, progress,
 * filters, start time, and end time.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CacheReportInfo implements SdkPojo, Serializable, ToCopyableBuilder<CacheReportInfo.Builder, CacheReportInfo> {
    private static final SdkField<String> CACHE_REPORT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheReportARN").getter(getter(CacheReportInfo::cacheReportARN)).setter(setter(Builder::cacheReportARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheReportARN").build()).build();

    private static final SdkField<String> CACHE_REPORT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheReportStatus").getter(getter(CacheReportInfo::cacheReportStatusAsString))
            .setter(setter(Builder::cacheReportStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheReportStatus").build()).build();

    private static final SdkField<Integer> REPORT_COMPLETION_PERCENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ReportCompletionPercent").getter(getter(CacheReportInfo::reportCompletionPercent))
            .setter(setter(Builder::reportCompletionPercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportCompletionPercent").build())
            .build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(CacheReportInfo::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(CacheReportInfo::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<String> FILE_SHARE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileShareARN").getter(getter(CacheReportInfo::fileShareARN)).setter(setter(Builder::fileShareARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareARN").build()).build();

    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationARN").getter(getter(CacheReportInfo::locationARN)).setter(setter(Builder::locationARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationARN").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(CacheReportInfo::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<List<CacheReportFilter>> INCLUSION_FILTERS_FIELD = SdkField
            .<List<CacheReportFilter>> builder(MarshallingType.LIST)
            .memberName("InclusionFilters")
            .getter(getter(CacheReportInfo::inclusionFilters))
            .setter(setter(Builder::inclusionFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CacheReportFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CacheReportFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CacheReportFilter>> EXCLUSION_FILTERS_FIELD = SdkField
            .<List<CacheReportFilter>> builder(MarshallingType.LIST)
            .memberName("ExclusionFilters")
            .getter(getter(CacheReportInfo::exclusionFilters))
            .setter(setter(Builder::exclusionFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CacheReportFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CacheReportFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REPORT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReportName").getter(getter(CacheReportInfo::reportName)).setter(setter(Builder::reportName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportName").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CacheReportInfo::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CACHE_REPORT_ARN_FIELD, CACHE_REPORT_STATUS_FIELD, REPORT_COMPLETION_PERCENT_FIELD, END_TIME_FIELD,
                    ROLE_FIELD, FILE_SHARE_ARN_FIELD, LOCATION_ARN_FIELD, START_TIME_FIELD, INCLUSION_FILTERS_FIELD,
                    EXCLUSION_FILTERS_FIELD, REPORT_NAME_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String cacheReportARN;

    private final String cacheReportStatus;

    private final Integer reportCompletionPercent;

    private final Instant endTime;

    private final String role;

    private final String fileShareARN;

    private final String locationARN;

    private final Instant startTime;

    private final List<CacheReportFilter> inclusionFilters;

    private final List<CacheReportFilter> exclusionFilters;

    private final String reportName;

    private final List<Tag> tags;

    private CacheReportInfo(BuilderImpl builder) {
        this.cacheReportARN = builder.cacheReportARN;
        this.cacheReportStatus = builder.cacheReportStatus;
        this.reportCompletionPercent = builder.reportCompletionPercent;
        this.endTime = builder.endTime;
        this.role = builder.role;
        this.fileShareARN = builder.fileShareARN;
        this.locationARN = builder.locationARN;
        this.startTime = builder.startTime;
        this.inclusionFilters = builder.inclusionFilters;
        this.exclusionFilters = builder.exclusionFilters;
        this.reportName = builder.reportName;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the cache report you want to describe.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the cache report you want to describe.
     */
    public final String cacheReportARN() {
        return cacheReportARN;
    }

    /**
     * <p>
     * The status of the specified cache report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cacheReportStatus}
     * will return {@link CacheReportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #cacheReportStatusAsString}.
     * </p>
     * 
     * @return The status of the specified cache report.
     * @see CacheReportStatus
     */
    public final CacheReportStatus cacheReportStatus() {
        return CacheReportStatus.fromValue(cacheReportStatus);
    }

    /**
     * <p>
     * The status of the specified cache report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cacheReportStatus}
     * will return {@link CacheReportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #cacheReportStatusAsString}.
     * </p>
     * 
     * @return The status of the specified cache report.
     * @see CacheReportStatus
     */
    public final String cacheReportStatusAsString() {
        return cacheReportStatus;
    }

    /**
     * <p>
     * The percentage of the report generation process that has been completed at time of inquiry.
     * </p>
     * 
     * @return The percentage of the report generation process that has been completed at time of inquiry.
     */
    public final Integer reportCompletionPercent() {
        return reportCompletionPercent;
    }

    /**
     * <p>
     * The time at which the gateway stopped generating the cache report.
     * </p>
     * 
     * @return The time at which the gateway stopped generating the cache report.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * Returns the value of the Role property for this object.
     * 
     * @return The value of the Role property for this object.
     */
    public final String role() {
        return role;
    }

    /**
     * Returns the value of the FileShareARN property for this object.
     * 
     * @return The value of the FileShareARN property for this object.
     */
    public final String fileShareARN() {
        return fileShareARN;
    }

    /**
     * <p>
     * The ARN of the Amazon S3 bucket location where the cache report is saved.
     * </p>
     * 
     * @return The ARN of the Amazon S3 bucket location where the cache report is saved.
     */
    public final String locationARN() {
        return locationARN;
    }

    /**
     * <p>
     * The time at which the gateway started generating the cache report.
     * </p>
     * 
     * @return The time at which the gateway started generating the cache report.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the InclusionFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInclusionFilters() {
        return inclusionFilters != null && !(inclusionFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of filters and parameters that determine which files are included in the report.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInclusionFilters} method.
     * </p>
     * 
     * @return The list of filters and parameters that determine which files are included in the report.
     */
    public final List<CacheReportFilter> inclusionFilters() {
        return inclusionFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExclusionFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExclusionFilters() {
        return exclusionFilters != null && !(exclusionFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of filters and parameters that determine which files are excluded from the report.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExclusionFilters} method.
     * </p>
     * 
     * @return The list of filters and parameters that determine which files are excluded from the report.
     */
    public final List<CacheReportFilter> exclusionFilters() {
        return exclusionFilters;
    }

    /**
     * <p>
     * The file name of the completed cache report object stored in Amazon S3.
     * </p>
     * 
     * @return The file name of the completed cache report object stored in Amazon S3.
     */
    public final String reportName() {
        return reportName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of key/value tags associated with the report.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The list of key/value tags associated with the report.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cacheReportARN());
        hashCode = 31 * hashCode + Objects.hashCode(cacheReportStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reportCompletionPercent());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(fileShareARN());
        hashCode = 31 * hashCode + Objects.hashCode(locationARN());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasInclusionFilters() ? inclusionFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExclusionFilters() ? exclusionFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(reportName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheReportInfo)) {
            return false;
        }
        CacheReportInfo other = (CacheReportInfo) obj;
        return Objects.equals(cacheReportARN(), other.cacheReportARN())
                && Objects.equals(cacheReportStatusAsString(), other.cacheReportStatusAsString())
                && Objects.equals(reportCompletionPercent(), other.reportCompletionPercent())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(role(), other.role())
                && Objects.equals(fileShareARN(), other.fileShareARN()) && Objects.equals(locationARN(), other.locationARN())
                && Objects.equals(startTime(), other.startTime()) && hasInclusionFilters() == other.hasInclusionFilters()
                && Objects.equals(inclusionFilters(), other.inclusionFilters())
                && hasExclusionFilters() == other.hasExclusionFilters()
                && Objects.equals(exclusionFilters(), other.exclusionFilters())
                && Objects.equals(reportName(), other.reportName()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CacheReportInfo").add("CacheReportARN", cacheReportARN())
                .add("CacheReportStatus", cacheReportStatusAsString()).add("ReportCompletionPercent", reportCompletionPercent())
                .add("EndTime", endTime()).add("Role", role()).add("FileShareARN", fileShareARN())
                .add("LocationARN", locationARN()).add("StartTime", startTime())
                .add("InclusionFilters", hasInclusionFilters() ? inclusionFilters() : null)
                .add("ExclusionFilters", hasExclusionFilters() ? exclusionFilters() : null).add("ReportName", reportName())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CacheReportARN":
            return Optional.ofNullable(clazz.cast(cacheReportARN()));
        case "CacheReportStatus":
            return Optional.ofNullable(clazz.cast(cacheReportStatusAsString()));
        case "ReportCompletionPercent":
            return Optional.ofNullable(clazz.cast(reportCompletionPercent()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "FileShareARN":
            return Optional.ofNullable(clazz.cast(fileShareARN()));
        case "LocationARN":
            return Optional.ofNullable(clazz.cast(locationARN()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "InclusionFilters":
            return Optional.ofNullable(clazz.cast(inclusionFilters()));
        case "ExclusionFilters":
            return Optional.ofNullable(clazz.cast(exclusionFilters()));
        case "ReportName":
            return Optional.ofNullable(clazz.cast(reportName()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CacheReportARN", CACHE_REPORT_ARN_FIELD);
        map.put("CacheReportStatus", CACHE_REPORT_STATUS_FIELD);
        map.put("ReportCompletionPercent", REPORT_COMPLETION_PERCENT_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("Role", ROLE_FIELD);
        map.put("FileShareARN", FILE_SHARE_ARN_FIELD);
        map.put("LocationARN", LOCATION_ARN_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("InclusionFilters", INCLUSION_FILTERS_FIELD);
        map.put("ExclusionFilters", EXCLUSION_FILTERS_FIELD);
        map.put("ReportName", REPORT_NAME_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CacheReportInfo, T> g) {
        return obj -> g.apply((CacheReportInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CacheReportInfo> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the cache report you want to describe.
         * </p>
         * 
         * @param cacheReportARN
         *        The Amazon Resource Name (ARN) of the cache report you want to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheReportARN(String cacheReportARN);

        /**
         * <p>
         * The status of the specified cache report.
         * </p>
         * 
         * @param cacheReportStatus
         *        The status of the specified cache report.
         * @see CacheReportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CacheReportStatus
         */
        Builder cacheReportStatus(String cacheReportStatus);

        /**
         * <p>
         * The status of the specified cache report.
         * </p>
         * 
         * @param cacheReportStatus
         *        The status of the specified cache report.
         * @see CacheReportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CacheReportStatus
         */
        Builder cacheReportStatus(CacheReportStatus cacheReportStatus);

        /**
         * <p>
         * The percentage of the report generation process that has been completed at time of inquiry.
         * </p>
         * 
         * @param reportCompletionPercent
         *        The percentage of the report generation process that has been completed at time of inquiry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportCompletionPercent(Integer reportCompletionPercent);

        /**
         * <p>
         * The time at which the gateway stopped generating the cache report.
         * </p>
         * 
         * @param endTime
         *        The time at which the gateway stopped generating the cache report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * Sets the value of the Role property for this object.
         *
         * @param role
         *        The new value for the Role property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * Sets the value of the FileShareARN property for this object.
         *
         * @param fileShareARN
         *        The new value for the FileShareARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileShareARN(String fileShareARN);

        /**
         * <p>
         * The ARN of the Amazon S3 bucket location where the cache report is saved.
         * </p>
         * 
         * @param locationARN
         *        The ARN of the Amazon S3 bucket location where the cache report is saved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationARN(String locationARN);

        /**
         * <p>
         * The time at which the gateway started generating the cache report.
         * </p>
         * 
         * @param startTime
         *        The time at which the gateway started generating the cache report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The list of filters and parameters that determine which files are included in the report.
         * </p>
         * 
         * @param inclusionFilters
         *        The list of filters and parameters that determine which files are included in the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusionFilters(Collection<CacheReportFilter> inclusionFilters);

        /**
         * <p>
         * The list of filters and parameters that determine which files are included in the report.
         * </p>
         * 
         * @param inclusionFilters
         *        The list of filters and parameters that determine which files are included in the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusionFilters(CacheReportFilter... inclusionFilters);

        /**
         * <p>
         * The list of filters and parameters that determine which files are included in the report.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.storagegateway.model.CacheReportFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.storagegateway.model.CacheReportFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.storagegateway.model.CacheReportFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #inclusionFilters(List<CacheReportFilter>)}.
         * 
         * @param inclusionFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.storagegateway.model.CacheReportFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inclusionFilters(java.util.Collection<CacheReportFilter>)
         */
        Builder inclusionFilters(Consumer<CacheReportFilter.Builder>... inclusionFilters);

        /**
         * <p>
         * The list of filters and parameters that determine which files are excluded from the report.
         * </p>
         * 
         * @param exclusionFilters
         *        The list of filters and parameters that determine which files are excluded from the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusionFilters(Collection<CacheReportFilter> exclusionFilters);

        /**
         * <p>
         * The list of filters and parameters that determine which files are excluded from the report.
         * </p>
         * 
         * @param exclusionFilters
         *        The list of filters and parameters that determine which files are excluded from the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusionFilters(CacheReportFilter... exclusionFilters);

        /**
         * <p>
         * The list of filters and parameters that determine which files are excluded from the report.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.storagegateway.model.CacheReportFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.storagegateway.model.CacheReportFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.storagegateway.model.CacheReportFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #exclusionFilters(List<CacheReportFilter>)}.
         * 
         * @param exclusionFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.storagegateway.model.CacheReportFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exclusionFilters(java.util.Collection<CacheReportFilter>)
         */
        Builder exclusionFilters(Consumer<CacheReportFilter.Builder>... exclusionFilters);

        /**
         * <p>
         * The file name of the completed cache report object stored in Amazon S3.
         * </p>
         * 
         * @param reportName
         *        The file name of the completed cache report object stored in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportName(String reportName);

        /**
         * <p>
         * The list of key/value tags associated with the report.
         * </p>
         * 
         * @param tags
         *        The list of key/value tags associated with the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The list of key/value tags associated with the report.
         * </p>
         * 
         * @param tags
         *        The list of key/value tags associated with the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The list of key/value tags associated with the report.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.storagegateway.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.storagegateway.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.storagegateway.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.storagegateway.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String cacheReportARN;

        private String cacheReportStatus;

        private Integer reportCompletionPercent;

        private Instant endTime;

        private String role;

        private String fileShareARN;

        private String locationARN;

        private Instant startTime;

        private List<CacheReportFilter> inclusionFilters = DefaultSdkAutoConstructList.getInstance();

        private List<CacheReportFilter> exclusionFilters = DefaultSdkAutoConstructList.getInstance();

        private String reportName;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CacheReportInfo model) {
            cacheReportARN(model.cacheReportARN);
            cacheReportStatus(model.cacheReportStatus);
            reportCompletionPercent(model.reportCompletionPercent);
            endTime(model.endTime);
            role(model.role);
            fileShareARN(model.fileShareARN);
            locationARN(model.locationARN);
            startTime(model.startTime);
            inclusionFilters(model.inclusionFilters);
            exclusionFilters(model.exclusionFilters);
            reportName(model.reportName);
            tags(model.tags);
        }

        public final String getCacheReportARN() {
            return cacheReportARN;
        }

        public final void setCacheReportARN(String cacheReportARN) {
            this.cacheReportARN = cacheReportARN;
        }

        @Override
        public final Builder cacheReportARN(String cacheReportARN) {
            this.cacheReportARN = cacheReportARN;
            return this;
        }

        public final String getCacheReportStatus() {
            return cacheReportStatus;
        }

        public final void setCacheReportStatus(String cacheReportStatus) {
            this.cacheReportStatus = cacheReportStatus;
        }

        @Override
        public final Builder cacheReportStatus(String cacheReportStatus) {
            this.cacheReportStatus = cacheReportStatus;
            return this;
        }

        @Override
        public final Builder cacheReportStatus(CacheReportStatus cacheReportStatus) {
            this.cacheReportStatus(cacheReportStatus == null ? null : cacheReportStatus.toString());
            return this;
        }

        public final Integer getReportCompletionPercent() {
            return reportCompletionPercent;
        }

        public final void setReportCompletionPercent(Integer reportCompletionPercent) {
            this.reportCompletionPercent = reportCompletionPercent;
        }

        @Override
        public final Builder reportCompletionPercent(Integer reportCompletionPercent) {
            this.reportCompletionPercent = reportCompletionPercent;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final String getFileShareARN() {
            return fileShareARN;
        }

        public final void setFileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
        }

        @Override
        public final Builder fileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
            return this;
        }

        public final String getLocationARN() {
            return locationARN;
        }

        public final void setLocationARN(String locationARN) {
            this.locationARN = locationARN;
        }

        @Override
        public final Builder locationARN(String locationARN) {
            this.locationARN = locationARN;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final List<CacheReportFilter.Builder> getInclusionFilters() {
            List<CacheReportFilter.Builder> result = CacheReportFilterListCopier.copyToBuilder(this.inclusionFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInclusionFilters(Collection<CacheReportFilter.BuilderImpl> inclusionFilters) {
            this.inclusionFilters = CacheReportFilterListCopier.copyFromBuilder(inclusionFilters);
        }

        @Override
        public final Builder inclusionFilters(Collection<CacheReportFilter> inclusionFilters) {
            this.inclusionFilters = CacheReportFilterListCopier.copy(inclusionFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionFilters(CacheReportFilter... inclusionFilters) {
            inclusionFilters(Arrays.asList(inclusionFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionFilters(Consumer<CacheReportFilter.Builder>... inclusionFilters) {
            inclusionFilters(Stream.of(inclusionFilters).map(c -> CacheReportFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CacheReportFilter.Builder> getExclusionFilters() {
            List<CacheReportFilter.Builder> result = CacheReportFilterListCopier.copyToBuilder(this.exclusionFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExclusionFilters(Collection<CacheReportFilter.BuilderImpl> exclusionFilters) {
            this.exclusionFilters = CacheReportFilterListCopier.copyFromBuilder(exclusionFilters);
        }

        @Override
        public final Builder exclusionFilters(Collection<CacheReportFilter> exclusionFilters) {
            this.exclusionFilters = CacheReportFilterListCopier.copy(exclusionFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionFilters(CacheReportFilter... exclusionFilters) {
            exclusionFilters(Arrays.asList(exclusionFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionFilters(Consumer<CacheReportFilter.Builder>... exclusionFilters) {
            exclusionFilters(Stream.of(exclusionFilters).map(c -> CacheReportFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getReportName() {
            return reportName;
        }

        public final void setReportName(String reportName) {
            this.reportName = reportName;
        }

        @Override
        public final Builder reportName(String reportName) {
            this.reportName = reportName;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CacheReportInfo build() {
            return new CacheReportInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
