/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCacheReportResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<DescribeCacheReportResponse.Builder, DescribeCacheReportResponse> {
    private static final SdkField<CacheReportInfo> CACHE_REPORT_INFO_FIELD = SdkField
            .<CacheReportInfo> builder(MarshallingType.SDK_POJO).memberName("CacheReportInfo")
            .getter(getter(DescribeCacheReportResponse::cacheReportInfo)).setter(setter(Builder::cacheReportInfo))
            .constructor(CacheReportInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheReportInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_REPORT_INFO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final CacheReportInfo cacheReportInfo;

    private DescribeCacheReportResponse(BuilderImpl builder) {
        super(builder);
        this.cacheReportInfo = builder.cacheReportInfo;
    }

    /**
     * <p>
     * Contains all informational fields associated with a cache report. Includes name, ARN, tags, status, progress,
     * filters, start time, and end time.
     * </p>
     * 
     * @return Contains all informational fields associated with a cache report. Includes name, ARN, tags, status,
     *         progress, filters, start time, and end time.
     */
    public final CacheReportInfo cacheReportInfo() {
        return cacheReportInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cacheReportInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCacheReportResponse)) {
            return false;
        }
        DescribeCacheReportResponse other = (DescribeCacheReportResponse) obj;
        return Objects.equals(cacheReportInfo(), other.cacheReportInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCacheReportResponse").add("CacheReportInfo", cacheReportInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CacheReportInfo":
            return Optional.ofNullable(clazz.cast(cacheReportInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CacheReportInfo", CACHE_REPORT_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCacheReportResponse, T> g) {
        return obj -> g.apply((DescribeCacheReportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeCacheReportResponse> {
        /**
         * <p>
         * Contains all informational fields associated with a cache report. Includes name, ARN, tags, status, progress,
         * filters, start time, and end time.
         * </p>
         * 
         * @param cacheReportInfo
         *        Contains all informational fields associated with a cache report. Includes name, ARN, tags, status,
         *        progress, filters, start time, and end time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheReportInfo(CacheReportInfo cacheReportInfo);

        /**
         * <p>
         * Contains all informational fields associated with a cache report. Includes name, ARN, tags, status, progress,
         * filters, start time, and end time.
         * </p>
         * This is a convenience method that creates an instance of the {@link CacheReportInfo.Builder} avoiding the
         * need to create one manually via {@link CacheReportInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CacheReportInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #cacheReportInfo(CacheReportInfo)}.
         * 
         * @param cacheReportInfo
         *        a consumer that will call methods on {@link CacheReportInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheReportInfo(CacheReportInfo)
         */
        default Builder cacheReportInfo(Consumer<CacheReportInfo.Builder> cacheReportInfo) {
            return cacheReportInfo(CacheReportInfo.builder().applyMutation(cacheReportInfo).build());
        }
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private CacheReportInfo cacheReportInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCacheReportResponse model) {
            super(model);
            cacheReportInfo(model.cacheReportInfo);
        }

        public final CacheReportInfo.Builder getCacheReportInfo() {
            return cacheReportInfo != null ? cacheReportInfo.toBuilder() : null;
        }

        public final void setCacheReportInfo(CacheReportInfo.BuilderImpl cacheReportInfo) {
            this.cacheReportInfo = cacheReportInfo != null ? cacheReportInfo.build() : null;
        }

        @Override
        public final Builder cacheReportInfo(CacheReportInfo cacheReportInfo) {
            this.cacheReportInfo = cacheReportInfo;
            return this;
        }

        @Override
        public DescribeCacheReportResponse build() {
            return new DescribeCacheReportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
