/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSmbSettingsResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<DescribeSmbSettingsResponse.Builder, DescribeSmbSettingsResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayARN").getter(getter(DescribeSmbSettingsResponse::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(DescribeSmbSettingsResponse::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> ACTIVE_DIRECTORY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActiveDirectoryStatus").getter(getter(DescribeSmbSettingsResponse::activeDirectoryStatusAsString))
            .setter(setter(Builder::activeDirectoryStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDirectoryStatus").build())
            .build();

    private static final SdkField<Boolean> SMB_GUEST_PASSWORD_SET_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SMBGuestPasswordSet").getter(getter(DescribeSmbSettingsResponse::smbGuestPasswordSet))
            .setter(setter(Builder::smbGuestPasswordSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMBGuestPasswordSet").build())
            .build();

    private static final SdkField<String> SMB_SECURITY_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SMBSecurityStrategy").getter(getter(DescribeSmbSettingsResponse::smbSecurityStrategyAsString))
            .setter(setter(Builder::smbSecurityStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMBSecurityStrategy").build())
            .build();

    private static final SdkField<Boolean> FILE_SHARES_VISIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("FileSharesVisible").getter(getter(DescribeSmbSettingsResponse::fileSharesVisible))
            .setter(setter(Builder::fileSharesVisible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSharesVisible").build()).build();

    private static final SdkField<SMBLocalGroups> SMB_LOCAL_GROUPS_FIELD = SdkField
            .<SMBLocalGroups> builder(MarshallingType.SDK_POJO).memberName("SMBLocalGroups")
            .getter(getter(DescribeSmbSettingsResponse::smbLocalGroups)).setter(setter(Builder::smbLocalGroups))
            .constructor(SMBLocalGroups::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMBLocalGroups").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            DOMAIN_NAME_FIELD, ACTIVE_DIRECTORY_STATUS_FIELD, SMB_GUEST_PASSWORD_SET_FIELD, SMB_SECURITY_STRATEGY_FIELD,
            FILE_SHARES_VISIBLE_FIELD, SMB_LOCAL_GROUPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String gatewayARN;

    private final String domainName;

    private final String activeDirectoryStatus;

    private final Boolean smbGuestPasswordSet;

    private final String smbSecurityStrategy;

    private final Boolean fileSharesVisible;

    private final SMBLocalGroups smbLocalGroups;

    private DescribeSmbSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.domainName = builder.domainName;
        this.activeDirectoryStatus = builder.activeDirectoryStatus;
        this.smbGuestPasswordSet = builder.smbGuestPasswordSet;
        this.smbSecurityStrategy = builder.smbSecurityStrategy;
        this.fileSharesVisible = builder.fileSharesVisible;
        this.smbLocalGroups = builder.smbLocalGroups;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public final String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * The name of the domain that the gateway is joined to.
     * </p>
     * 
     * @return The name of the domain that the gateway is joined to.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * Indicates the status of a gateway that is a member of the Active Directory domain.
     * </p>
     * <note>
     * <p>
     * This field is only used as part of a <code>JoinDomain</code> request. It is not affected by Active Directory
     * connectivity changes that occur after the <code>JoinDomain</code> request succeeds.
     * </p>
     * </note>
     * <ul>
     * <li>
     * <p>
     * <code>ACCESS_DENIED</code>: Indicates that the <code>JoinDomain</code> operation failed due to an authentication
     * error.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DETACHED</code>: Indicates that gateway is not joined to a domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>JOINED</code>: Indicates that the gateway has successfully joined a domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>JOINING</code>: Indicates that a <code>JoinDomain</code> operation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NETWORK_ERROR</code>: Indicates that <code>JoinDomain</code> operation failed due to a network or
     * connectivity error.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TIMEOUT</code>: Indicates that the <code>JoinDomain</code> operation failed because the operation didn't
     * complete within the allotted time.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNKNOWN_ERROR</code>: Indicates that the <code>JoinDomain</code> operation failed due to another type of
     * error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #activeDirectoryStatus} will return {@link ActiveDirectoryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #activeDirectoryStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of a gateway that is a member of the Active Directory domain.</p> <note>
     *         <p>
     *         This field is only used as part of a <code>JoinDomain</code> request. It is not affected by Active
     *         Directory connectivity changes that occur after the <code>JoinDomain</code> request succeeds.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACCESS_DENIED</code>: Indicates that the <code>JoinDomain</code> operation failed due to an
     *         authentication error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DETACHED</code>: Indicates that gateway is not joined to a domain.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>JOINED</code>: Indicates that the gateway has successfully joined a domain.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>JOINING</code>: Indicates that a <code>JoinDomain</code> operation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NETWORK_ERROR</code>: Indicates that <code>JoinDomain</code> operation failed due to a network or
     *         connectivity error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TIMEOUT</code>: Indicates that the <code>JoinDomain</code> operation failed because the operation
     *         didn't complete within the allotted time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNKNOWN_ERROR</code>: Indicates that the <code>JoinDomain</code> operation failed due to another
     *         type of error.
     *         </p>
     *         </li>
     * @see ActiveDirectoryStatus
     */
    public final ActiveDirectoryStatus activeDirectoryStatus() {
        return ActiveDirectoryStatus.fromValue(activeDirectoryStatus);
    }

    /**
     * <p>
     * Indicates the status of a gateway that is a member of the Active Directory domain.
     * </p>
     * <note>
     * <p>
     * This field is only used as part of a <code>JoinDomain</code> request. It is not affected by Active Directory
     * connectivity changes that occur after the <code>JoinDomain</code> request succeeds.
     * </p>
     * </note>
     * <ul>
     * <li>
     * <p>
     * <code>ACCESS_DENIED</code>: Indicates that the <code>JoinDomain</code> operation failed due to an authentication
     * error.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DETACHED</code>: Indicates that gateway is not joined to a domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>JOINED</code>: Indicates that the gateway has successfully joined a domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>JOINING</code>: Indicates that a <code>JoinDomain</code> operation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NETWORK_ERROR</code>: Indicates that <code>JoinDomain</code> operation failed due to a network or
     * connectivity error.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TIMEOUT</code>: Indicates that the <code>JoinDomain</code> operation failed because the operation didn't
     * complete within the allotted time.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNKNOWN_ERROR</code>: Indicates that the <code>JoinDomain</code> operation failed due to another type of
     * error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #activeDirectoryStatus} will return {@link ActiveDirectoryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #activeDirectoryStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of a gateway that is a member of the Active Directory domain.</p> <note>
     *         <p>
     *         This field is only used as part of a <code>JoinDomain</code> request. It is not affected by Active
     *         Directory connectivity changes that occur after the <code>JoinDomain</code> request succeeds.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACCESS_DENIED</code>: Indicates that the <code>JoinDomain</code> operation failed due to an
     *         authentication error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DETACHED</code>: Indicates that gateway is not joined to a domain.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>JOINED</code>: Indicates that the gateway has successfully joined a domain.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>JOINING</code>: Indicates that a <code>JoinDomain</code> operation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NETWORK_ERROR</code>: Indicates that <code>JoinDomain</code> operation failed due to a network or
     *         connectivity error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TIMEOUT</code>: Indicates that the <code>JoinDomain</code> operation failed because the operation
     *         didn't complete within the allotted time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNKNOWN_ERROR</code>: Indicates that the <code>JoinDomain</code> operation failed due to another
     *         type of error.
     *         </p>
     *         </li>
     * @see ActiveDirectoryStatus
     */
    public final String activeDirectoryStatusAsString() {
        return activeDirectoryStatus;
    }

    /**
     * <p>
     * This value is <code>true</code> if a password for the guest user <code>smbguest</code> is set, otherwise
     * <code>false</code>. Only supported for S3 File Gateways.
     * </p>
     * <p>
     * Valid Values: <code>true</code> | <code>false</code>
     * </p>
     * 
     * @return This value is <code>true</code> if a password for the guest user <code>smbguest</code> is set, otherwise
     *         <code>false</code>. Only supported for S3 File Gateways.</p>
     *         <p>
     *         Valid Values: <code>true</code> | <code>false</code>
     */
    public final Boolean smbGuestPasswordSet() {
        return smbGuestPasswordSet;
    }

    /**
     * <p>
     * The type of security strategy that was specified for file gateway.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ClientSpecified</code>: If you choose this option, requests are established based on what is negotiated by
     * the client. This option is recommended when you want to maximize compatibility across different clients in your
     * environment. Supported only for S3 File Gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MandatorySigning</code>: If you choose this option, File Gateway only allows connections from SMBv2 or
     * SMBv3 clients that have signing turned on. This option works with SMB clients on Microsoft Windows Vista, Windows
     * Server 2008, or later.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MandatoryEncryption</code>: If you choose this option, File Gateway only allows connections from SMBv3
     * clients that have encryption turned on. Both 256-bit and 128-bit algorithms are allowed. This option is
     * recommended for environments that handle sensitive data. It works with SMB clients on Microsoft Windows 8,
     * Windows Server 2012, or later.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MandatoryEncryptionNoAes128</code>: If you choose this option, File Gateway only allows connections from
     * SMBv3 clients that use 256-bit AES encryption algorithms. 128-bit algorithms are not allowed. This option is
     * recommended for environments that handle sensitive data. It works with SMB clients on Microsoft Windows 8,
     * Windows Server 2012, or later.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #smbSecurityStrategy} will return {@link SMBSecurityStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #smbSecurityStrategyAsString}.
     * </p>
     * 
     * @return The type of security strategy that was specified for file gateway.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ClientSpecified</code>: If you choose this option, requests are established based on what is
     *         negotiated by the client. This option is recommended when you want to maximize compatibility across
     *         different clients in your environment. Supported only for S3 File Gateway.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MandatorySigning</code>: If you choose this option, File Gateway only allows connections from SMBv2
     *         or SMBv3 clients that have signing turned on. This option works with SMB clients on Microsoft Windows
     *         Vista, Windows Server 2008, or later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MandatoryEncryption</code>: If you choose this option, File Gateway only allows connections from
     *         SMBv3 clients that have encryption turned on. Both 256-bit and 128-bit algorithms are allowed. This
     *         option is recommended for environments that handle sensitive data. It works with SMB clients on Microsoft
     *         Windows 8, Windows Server 2012, or later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MandatoryEncryptionNoAes128</code>: If you choose this option, File Gateway only allows connections
     *         from SMBv3 clients that use 256-bit AES encryption algorithms. 128-bit algorithms are not allowed. This
     *         option is recommended for environments that handle sensitive data. It works with SMB clients on Microsoft
     *         Windows 8, Windows Server 2012, or later.
     *         </p>
     *         </li>
     * @see SMBSecurityStrategy
     */
    public final SMBSecurityStrategy smbSecurityStrategy() {
        return SMBSecurityStrategy.fromValue(smbSecurityStrategy);
    }

    /**
     * <p>
     * The type of security strategy that was specified for file gateway.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ClientSpecified</code>: If you choose this option, requests are established based on what is negotiated by
     * the client. This option is recommended when you want to maximize compatibility across different clients in your
     * environment. Supported only for S3 File Gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MandatorySigning</code>: If you choose this option, File Gateway only allows connections from SMBv2 or
     * SMBv3 clients that have signing turned on. This option works with SMB clients on Microsoft Windows Vista, Windows
     * Server 2008, or later.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MandatoryEncryption</code>: If you choose this option, File Gateway only allows connections from SMBv3
     * clients that have encryption turned on. Both 256-bit and 128-bit algorithms are allowed. This option is
     * recommended for environments that handle sensitive data. It works with SMB clients on Microsoft Windows 8,
     * Windows Server 2012, or later.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MandatoryEncryptionNoAes128</code>: If you choose this option, File Gateway only allows connections from
     * SMBv3 clients that use 256-bit AES encryption algorithms. 128-bit algorithms are not allowed. This option is
     * recommended for environments that handle sensitive data. It works with SMB clients on Microsoft Windows 8,
     * Windows Server 2012, or later.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #smbSecurityStrategy} will return {@link SMBSecurityStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #smbSecurityStrategyAsString}.
     * </p>
     * 
     * @return The type of security strategy that was specified for file gateway.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ClientSpecified</code>: If you choose this option, requests are established based on what is
     *         negotiated by the client. This option is recommended when you want to maximize compatibility across
     *         different clients in your environment. Supported only for S3 File Gateway.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MandatorySigning</code>: If you choose this option, File Gateway only allows connections from SMBv2
     *         or SMBv3 clients that have signing turned on. This option works with SMB clients on Microsoft Windows
     *         Vista, Windows Server 2008, or later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MandatoryEncryption</code>: If you choose this option, File Gateway only allows connections from
     *         SMBv3 clients that have encryption turned on. Both 256-bit and 128-bit algorithms are allowed. This
     *         option is recommended for environments that handle sensitive data. It works with SMB clients on Microsoft
     *         Windows 8, Windows Server 2012, or later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MandatoryEncryptionNoAes128</code>: If you choose this option, File Gateway only allows connections
     *         from SMBv3 clients that use 256-bit AES encryption algorithms. 128-bit algorithms are not allowed. This
     *         option is recommended for environments that handle sensitive data. It works with SMB clients on Microsoft
     *         Windows 8, Windows Server 2012, or later.
     *         </p>
     *         </li>
     * @see SMBSecurityStrategy
     */
    public final String smbSecurityStrategyAsString() {
        return smbSecurityStrategy;
    }

    /**
     * <p>
     * The shares on this gateway appear when listing shares. Only supported for S3 File Gateways.
     * </p>
     * 
     * @return The shares on this gateway appear when listing shares. Only supported for S3 File Gateways.
     */
    public final Boolean fileSharesVisible() {
        return fileSharesVisible;
    }

    /**
     * <p>
     * A list of Active Directory users and groups that have special permissions for SMB file shares on the gateway.
     * </p>
     * 
     * @return A list of Active Directory users and groups that have special permissions for SMB file shares on the
     *         gateway.
     */
    public final SMBLocalGroups smbLocalGroups() {
        return smbLocalGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(activeDirectoryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(smbGuestPasswordSet());
        hashCode = 31 * hashCode + Objects.hashCode(smbSecurityStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fileSharesVisible());
        hashCode = 31 * hashCode + Objects.hashCode(smbLocalGroups());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSmbSettingsResponse)) {
            return false;
        }
        DescribeSmbSettingsResponse other = (DescribeSmbSettingsResponse) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && Objects.equals(domainName(), other.domainName())
                && Objects.equals(activeDirectoryStatusAsString(), other.activeDirectoryStatusAsString())
                && Objects.equals(smbGuestPasswordSet(), other.smbGuestPasswordSet())
                && Objects.equals(smbSecurityStrategyAsString(), other.smbSecurityStrategyAsString())
                && Objects.equals(fileSharesVisible(), other.fileSharesVisible())
                && Objects.equals(smbLocalGroups(), other.smbLocalGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSmbSettingsResponse").add("GatewayARN", gatewayARN()).add("DomainName", domainName())
                .add("ActiveDirectoryStatus", activeDirectoryStatusAsString()).add("SMBGuestPasswordSet", smbGuestPasswordSet())
                .add("SMBSecurityStrategy", smbSecurityStrategyAsString()).add("FileSharesVisible", fileSharesVisible())
                .add("SMBLocalGroups", smbLocalGroups()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "ActiveDirectoryStatus":
            return Optional.ofNullable(clazz.cast(activeDirectoryStatusAsString()));
        case "SMBGuestPasswordSet":
            return Optional.ofNullable(clazz.cast(smbGuestPasswordSet()));
        case "SMBSecurityStrategy":
            return Optional.ofNullable(clazz.cast(smbSecurityStrategyAsString()));
        case "FileSharesVisible":
            return Optional.ofNullable(clazz.cast(fileSharesVisible()));
        case "SMBLocalGroups":
            return Optional.ofNullable(clazz.cast(smbLocalGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GatewayARN", GATEWAY_ARN_FIELD);
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("ActiveDirectoryStatus", ACTIVE_DIRECTORY_STATUS_FIELD);
        map.put("SMBGuestPasswordSet", SMB_GUEST_PASSWORD_SET_FIELD);
        map.put("SMBSecurityStrategy", SMB_SECURITY_STRATEGY_FIELD);
        map.put("FileSharesVisible", FILE_SHARES_VISIBLE_FIELD);
        map.put("SMBLocalGroups", SMB_LOCAL_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSmbSettingsResponse, T> g) {
        return obj -> g.apply((DescribeSmbSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSmbSettingsResponse> {
        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * The name of the domain that the gateway is joined to.
         * </p>
         * 
         * @param domainName
         *        The name of the domain that the gateway is joined to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * Indicates the status of a gateway that is a member of the Active Directory domain.
         * </p>
         * <note>
         * <p>
         * This field is only used as part of a <code>JoinDomain</code> request. It is not affected by Active Directory
         * connectivity changes that occur after the <code>JoinDomain</code> request succeeds.
         * </p>
         * </note>
         * <ul>
         * <li>
         * <p>
         * <code>ACCESS_DENIED</code>: Indicates that the <code>JoinDomain</code> operation failed due to an
         * authentication error.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DETACHED</code>: Indicates that gateway is not joined to a domain.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>JOINED</code>: Indicates that the gateway has successfully joined a domain.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>JOINING</code>: Indicates that a <code>JoinDomain</code> operation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NETWORK_ERROR</code>: Indicates that <code>JoinDomain</code> operation failed due to a network or
         * connectivity error.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TIMEOUT</code>: Indicates that the <code>JoinDomain</code> operation failed because the operation
         * didn't complete within the allotted time.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNKNOWN_ERROR</code>: Indicates that the <code>JoinDomain</code> operation failed due to another type
         * of error.
         * </p>
         * </li>
         * </ul>
         * 
         * @param activeDirectoryStatus
         *        Indicates the status of a gateway that is a member of the Active Directory domain.</p> <note>
         *        <p>
         *        This field is only used as part of a <code>JoinDomain</code> request. It is not affected by Active
         *        Directory connectivity changes that occur after the <code>JoinDomain</code> request succeeds.
         *        </p>
         *        </note>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACCESS_DENIED</code>: Indicates that the <code>JoinDomain</code> operation failed due to an
         *        authentication error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DETACHED</code>: Indicates that gateway is not joined to a domain.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>JOINED</code>: Indicates that the gateway has successfully joined a domain.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>JOINING</code>: Indicates that a <code>JoinDomain</code> operation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NETWORK_ERROR</code>: Indicates that <code>JoinDomain</code> operation failed due to a network
         *        or connectivity error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TIMEOUT</code>: Indicates that the <code>JoinDomain</code> operation failed because the
         *        operation didn't complete within the allotted time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNKNOWN_ERROR</code>: Indicates that the <code>JoinDomain</code> operation failed due to another
         *        type of error.
         *        </p>
         *        </li>
         * @see ActiveDirectoryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActiveDirectoryStatus
         */
        Builder activeDirectoryStatus(String activeDirectoryStatus);

        /**
         * <p>
         * Indicates the status of a gateway that is a member of the Active Directory domain.
         * </p>
         * <note>
         * <p>
         * This field is only used as part of a <code>JoinDomain</code> request. It is not affected by Active Directory
         * connectivity changes that occur after the <code>JoinDomain</code> request succeeds.
         * </p>
         * </note>
         * <ul>
         * <li>
         * <p>
         * <code>ACCESS_DENIED</code>: Indicates that the <code>JoinDomain</code> operation failed due to an
         * authentication error.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DETACHED</code>: Indicates that gateway is not joined to a domain.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>JOINED</code>: Indicates that the gateway has successfully joined a domain.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>JOINING</code>: Indicates that a <code>JoinDomain</code> operation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NETWORK_ERROR</code>: Indicates that <code>JoinDomain</code> operation failed due to a network or
         * connectivity error.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TIMEOUT</code>: Indicates that the <code>JoinDomain</code> operation failed because the operation
         * didn't complete within the allotted time.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNKNOWN_ERROR</code>: Indicates that the <code>JoinDomain</code> operation failed due to another type
         * of error.
         * </p>
         * </li>
         * </ul>
         * 
         * @param activeDirectoryStatus
         *        Indicates the status of a gateway that is a member of the Active Directory domain.</p> <note>
         *        <p>
         *        This field is only used as part of a <code>JoinDomain</code> request. It is not affected by Active
         *        Directory connectivity changes that occur after the <code>JoinDomain</code> request succeeds.
         *        </p>
         *        </note>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACCESS_DENIED</code>: Indicates that the <code>JoinDomain</code> operation failed due to an
         *        authentication error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DETACHED</code>: Indicates that gateway is not joined to a domain.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>JOINED</code>: Indicates that the gateway has successfully joined a domain.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>JOINING</code>: Indicates that a <code>JoinDomain</code> operation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NETWORK_ERROR</code>: Indicates that <code>JoinDomain</code> operation failed due to a network
         *        or connectivity error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TIMEOUT</code>: Indicates that the <code>JoinDomain</code> operation failed because the
         *        operation didn't complete within the allotted time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNKNOWN_ERROR</code>: Indicates that the <code>JoinDomain</code> operation failed due to another
         *        type of error.
         *        </p>
         *        </li>
         * @see ActiveDirectoryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActiveDirectoryStatus
         */
        Builder activeDirectoryStatus(ActiveDirectoryStatus activeDirectoryStatus);

        /**
         * <p>
         * This value is <code>true</code> if a password for the guest user <code>smbguest</code> is set, otherwise
         * <code>false</code>. Only supported for S3 File Gateways.
         * </p>
         * <p>
         * Valid Values: <code>true</code> | <code>false</code>
         * </p>
         * 
         * @param smbGuestPasswordSet
         *        This value is <code>true</code> if a password for the guest user <code>smbguest</code> is set,
         *        otherwise <code>false</code>. Only supported for S3 File Gateways.</p>
         *        <p>
         *        Valid Values: <code>true</code> | <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smbGuestPasswordSet(Boolean smbGuestPasswordSet);

        /**
         * <p>
         * The type of security strategy that was specified for file gateway.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ClientSpecified</code>: If you choose this option, requests are established based on what is negotiated
         * by the client. This option is recommended when you want to maximize compatibility across different clients in
         * your environment. Supported only for S3 File Gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MandatorySigning</code>: If you choose this option, File Gateway only allows connections from SMBv2 or
         * SMBv3 clients that have signing turned on. This option works with SMB clients on Microsoft Windows Vista,
         * Windows Server 2008, or later.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MandatoryEncryption</code>: If you choose this option, File Gateway only allows connections from SMBv3
         * clients that have encryption turned on. Both 256-bit and 128-bit algorithms are allowed. This option is
         * recommended for environments that handle sensitive data. It works with SMB clients on Microsoft Windows 8,
         * Windows Server 2012, or later.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MandatoryEncryptionNoAes128</code>: If you choose this option, File Gateway only allows connections
         * from SMBv3 clients that use 256-bit AES encryption algorithms. 128-bit algorithms are not allowed. This
         * option is recommended for environments that handle sensitive data. It works with SMB clients on Microsoft
         * Windows 8, Windows Server 2012, or later.
         * </p>
         * </li>
         * </ul>
         * 
         * @param smbSecurityStrategy
         *        The type of security strategy that was specified for file gateway.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ClientSpecified</code>: If you choose this option, requests are established based on what is
         *        negotiated by the client. This option is recommended when you want to maximize compatibility across
         *        different clients in your environment. Supported only for S3 File Gateway.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MandatorySigning</code>: If you choose this option, File Gateway only allows connections from
         *        SMBv2 or SMBv3 clients that have signing turned on. This option works with SMB clients on Microsoft
         *        Windows Vista, Windows Server 2008, or later.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MandatoryEncryption</code>: If you choose this option, File Gateway only allows connections from
         *        SMBv3 clients that have encryption turned on. Both 256-bit and 128-bit algorithms are allowed. This
         *        option is recommended for environments that handle sensitive data. It works with SMB clients on
         *        Microsoft Windows 8, Windows Server 2012, or later.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MandatoryEncryptionNoAes128</code>: If you choose this option, File Gateway only allows
         *        connections from SMBv3 clients that use 256-bit AES encryption algorithms. 128-bit algorithms are not
         *        allowed. This option is recommended for environments that handle sensitive data. It works with SMB
         *        clients on Microsoft Windows 8, Windows Server 2012, or later.
         *        </p>
         *        </li>
         * @see SMBSecurityStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SMBSecurityStrategy
         */
        Builder smbSecurityStrategy(String smbSecurityStrategy);

        /**
         * <p>
         * The type of security strategy that was specified for file gateway.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ClientSpecified</code>: If you choose this option, requests are established based on what is negotiated
         * by the client. This option is recommended when you want to maximize compatibility across different clients in
         * your environment. Supported only for S3 File Gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MandatorySigning</code>: If you choose this option, File Gateway only allows connections from SMBv2 or
         * SMBv3 clients that have signing turned on. This option works with SMB clients on Microsoft Windows Vista,
         * Windows Server 2008, or later.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MandatoryEncryption</code>: If you choose this option, File Gateway only allows connections from SMBv3
         * clients that have encryption turned on. Both 256-bit and 128-bit algorithms are allowed. This option is
         * recommended for environments that handle sensitive data. It works with SMB clients on Microsoft Windows 8,
         * Windows Server 2012, or later.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MandatoryEncryptionNoAes128</code>: If you choose this option, File Gateway only allows connections
         * from SMBv3 clients that use 256-bit AES encryption algorithms. 128-bit algorithms are not allowed. This
         * option is recommended for environments that handle sensitive data. It works with SMB clients on Microsoft
         * Windows 8, Windows Server 2012, or later.
         * </p>
         * </li>
         * </ul>
         * 
         * @param smbSecurityStrategy
         *        The type of security strategy that was specified for file gateway.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ClientSpecified</code>: If you choose this option, requests are established based on what is
         *        negotiated by the client. This option is recommended when you want to maximize compatibility across
         *        different clients in your environment. Supported only for S3 File Gateway.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MandatorySigning</code>: If you choose this option, File Gateway only allows connections from
         *        SMBv2 or SMBv3 clients that have signing turned on. This option works with SMB clients on Microsoft
         *        Windows Vista, Windows Server 2008, or later.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MandatoryEncryption</code>: If you choose this option, File Gateway only allows connections from
         *        SMBv3 clients that have encryption turned on. Both 256-bit and 128-bit algorithms are allowed. This
         *        option is recommended for environments that handle sensitive data. It works with SMB clients on
         *        Microsoft Windows 8, Windows Server 2012, or later.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MandatoryEncryptionNoAes128</code>: If you choose this option, File Gateway only allows
         *        connections from SMBv3 clients that use 256-bit AES encryption algorithms. 128-bit algorithms are not
         *        allowed. This option is recommended for environments that handle sensitive data. It works with SMB
         *        clients on Microsoft Windows 8, Windows Server 2012, or later.
         *        </p>
         *        </li>
         * @see SMBSecurityStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SMBSecurityStrategy
         */
        Builder smbSecurityStrategy(SMBSecurityStrategy smbSecurityStrategy);

        /**
         * <p>
         * The shares on this gateway appear when listing shares. Only supported for S3 File Gateways.
         * </p>
         * 
         * @param fileSharesVisible
         *        The shares on this gateway appear when listing shares. Only supported for S3 File Gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSharesVisible(Boolean fileSharesVisible);

        /**
         * <p>
         * A list of Active Directory users and groups that have special permissions for SMB file shares on the gateway.
         * </p>
         * 
         * @param smbLocalGroups
         *        A list of Active Directory users and groups that have special permissions for SMB file shares on the
         *        gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smbLocalGroups(SMBLocalGroups smbLocalGroups);

        /**
         * <p>
         * A list of Active Directory users and groups that have special permissions for SMB file shares on the gateway.
         * </p>
         * This is a convenience method that creates an instance of the {@link SMBLocalGroups.Builder} avoiding the need
         * to create one manually via {@link SMBLocalGroups#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SMBLocalGroups.Builder#build()} is called immediately and its
         * result is passed to {@link #smbLocalGroups(SMBLocalGroups)}.
         * 
         * @param smbLocalGroups
         *        a consumer that will call methods on {@link SMBLocalGroups.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smbLocalGroups(SMBLocalGroups)
         */
        default Builder smbLocalGroups(Consumer<SMBLocalGroups.Builder> smbLocalGroups) {
            return smbLocalGroups(SMBLocalGroups.builder().applyMutation(smbLocalGroups).build());
        }
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private String gatewayARN;

        private String domainName;

        private String activeDirectoryStatus;

        private Boolean smbGuestPasswordSet;

        private String smbSecurityStrategy;

        private Boolean fileSharesVisible;

        private SMBLocalGroups smbLocalGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSmbSettingsResponse model) {
            super(model);
            gatewayARN(model.gatewayARN);
            domainName(model.domainName);
            activeDirectoryStatus(model.activeDirectoryStatus);
            smbGuestPasswordSet(model.smbGuestPasswordSet);
            smbSecurityStrategy(model.smbSecurityStrategy);
            fileSharesVisible(model.fileSharesVisible);
            smbLocalGroups(model.smbLocalGroups);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getActiveDirectoryStatus() {
            return activeDirectoryStatus;
        }

        public final void setActiveDirectoryStatus(String activeDirectoryStatus) {
            this.activeDirectoryStatus = activeDirectoryStatus;
        }

        @Override
        public final Builder activeDirectoryStatus(String activeDirectoryStatus) {
            this.activeDirectoryStatus = activeDirectoryStatus;
            return this;
        }

        @Override
        public final Builder activeDirectoryStatus(ActiveDirectoryStatus activeDirectoryStatus) {
            this.activeDirectoryStatus(activeDirectoryStatus == null ? null : activeDirectoryStatus.toString());
            return this;
        }

        public final Boolean getSmbGuestPasswordSet() {
            return smbGuestPasswordSet;
        }

        public final void setSmbGuestPasswordSet(Boolean smbGuestPasswordSet) {
            this.smbGuestPasswordSet = smbGuestPasswordSet;
        }

        @Override
        public final Builder smbGuestPasswordSet(Boolean smbGuestPasswordSet) {
            this.smbGuestPasswordSet = smbGuestPasswordSet;
            return this;
        }

        public final String getSmbSecurityStrategy() {
            return smbSecurityStrategy;
        }

        public final void setSmbSecurityStrategy(String smbSecurityStrategy) {
            this.smbSecurityStrategy = smbSecurityStrategy;
        }

        @Override
        public final Builder smbSecurityStrategy(String smbSecurityStrategy) {
            this.smbSecurityStrategy = smbSecurityStrategy;
            return this;
        }

        @Override
        public final Builder smbSecurityStrategy(SMBSecurityStrategy smbSecurityStrategy) {
            this.smbSecurityStrategy(smbSecurityStrategy == null ? null : smbSecurityStrategy.toString());
            return this;
        }

        public final Boolean getFileSharesVisible() {
            return fileSharesVisible;
        }

        public final void setFileSharesVisible(Boolean fileSharesVisible) {
            this.fileSharesVisible = fileSharesVisible;
        }

        @Override
        public final Builder fileSharesVisible(Boolean fileSharesVisible) {
            this.fileSharesVisible = fileSharesVisible;
            return this;
        }

        public final SMBLocalGroups.Builder getSmbLocalGroups() {
            return smbLocalGroups != null ? smbLocalGroups.toBuilder() : null;
        }

        public final void setSmbLocalGroups(SMBLocalGroups.BuilderImpl smbLocalGroups) {
            this.smbLocalGroups = smbLocalGroups != null ? smbLocalGroups.build() : null;
        }

        @Override
        public final Builder smbLocalGroups(SMBLocalGroups smbLocalGroups) {
            this.smbLocalGroups = smbLocalGroups;
            return this;
        }

        @Override
        public DescribeSmbSettingsResponse build() {
            return new DescribeSmbSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
