/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a gateway's local disk.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Disk implements SdkPojo, Serializable, ToCopyableBuilder<Disk.Builder, Disk> {
    private static final SdkField<String> DISK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("DiskId")
            .getter(getter(Disk::diskId)).setter(setter(Builder::diskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskId").build()).build();

    private static final SdkField<String> DISK_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DiskPath").getter(getter(Disk::diskPath)).setter(setter(Builder::diskPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskPath").build()).build();

    private static final SdkField<String> DISK_NODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DiskNode").getter(getter(Disk::diskNode)).setter(setter(Builder::diskNode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskNode").build()).build();

    private static final SdkField<String> DISK_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DiskStatus").getter(getter(Disk::diskStatus)).setter(setter(Builder::diskStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskStatus").build()).build();

    private static final SdkField<Long> DISK_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DiskSizeInBytes").getter(getter(Disk::diskSizeInBytes)).setter(setter(Builder::diskSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskSizeInBytes").build()).build();

    private static final SdkField<String> DISK_ALLOCATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DiskAllocationType").getter(getter(Disk::diskAllocationType))
            .setter(setter(Builder::diskAllocationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskAllocationType").build())
            .build();

    private static final SdkField<String> DISK_ALLOCATION_RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DiskAllocationResource").getter(getter(Disk::diskAllocationResource))
            .setter(setter(Builder::diskAllocationResource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskAllocationResource").build())
            .build();

    private static final SdkField<List<String>> DISK_ATTRIBUTE_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DiskAttributeList")
            .getter(getter(Disk::diskAttributeList))
            .setter(setter(Builder::diskAttributeList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskAttributeList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISK_ID_FIELD,
            DISK_PATH_FIELD, DISK_NODE_FIELD, DISK_STATUS_FIELD, DISK_SIZE_IN_BYTES_FIELD, DISK_ALLOCATION_TYPE_FIELD,
            DISK_ALLOCATION_RESOURCE_FIELD, DISK_ATTRIBUTE_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String diskId;

    private final String diskPath;

    private final String diskNode;

    private final String diskStatus;

    private final Long diskSizeInBytes;

    private final String diskAllocationType;

    private final String diskAllocationResource;

    private final List<String> diskAttributeList;

    private Disk(BuilderImpl builder) {
        this.diskId = builder.diskId;
        this.diskPath = builder.diskPath;
        this.diskNode = builder.diskNode;
        this.diskStatus = builder.diskStatus;
        this.diskSizeInBytes = builder.diskSizeInBytes;
        this.diskAllocationType = builder.diskAllocationType;
        this.diskAllocationResource = builder.diskAllocationResource;
        this.diskAttributeList = builder.diskAttributeList;
    }

    /**
     * <p>
     * The unique device ID or other distinguishing data that identifies a local disk.
     * </p>
     * 
     * @return The unique device ID or other distinguishing data that identifies a local disk.
     */
    public final String diskId() {
        return diskId;
    }

    /**
     * <p>
     * The path of a local disk in the gateway virtual machine (VM).
     * </p>
     * 
     * @return The path of a local disk in the gateway virtual machine (VM).
     */
    public final String diskPath() {
        return diskPath;
    }

    /**
     * <p>
     * The device node of a local disk as assigned by the virtualization environment.
     * </p>
     * 
     * @return The device node of a local disk as assigned by the virtualization environment.
     */
    public final String diskNode() {
        return diskNode;
    }

    /**
     * <p>
     * A value that represents the status of a local disk.
     * </p>
     * 
     * @return A value that represents the status of a local disk.
     */
    public final String diskStatus() {
        return diskStatus;
    }

    /**
     * <p>
     * The local disk size in bytes.
     * </p>
     * 
     * @return The local disk size in bytes.
     */
    public final Long diskSizeInBytes() {
        return diskSizeInBytes;
    }

    /**
     * Returns the value of the DiskAllocationType property for this object.
     * 
     * @return The value of the DiskAllocationType property for this object.
     */
    public final String diskAllocationType() {
        return diskAllocationType;
    }

    /**
     * <p>
     * The iSCSI qualified name (IQN) that is defined for a disk. This field is not included in the response if the
     * local disk is not defined as an iSCSI target. The format of this field is
     * <i>targetIqn::LUNNumber::region-volumeId</i>.
     * </p>
     * 
     * @return The iSCSI qualified name (IQN) that is defined for a disk. This field is not included in the response if
     *         the local disk is not defined as an iSCSI target. The format of this field is
     *         <i>targetIqn::LUNNumber::region-volumeId</i>.
     */
    public final String diskAllocationResource() {
        return diskAllocationResource;
    }

    /**
     * For responses, this returns true if the service returned a value for the DiskAttributeList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDiskAttributeList() {
        return diskAttributeList != null && !(diskAttributeList instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the DiskAttributeList property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDiskAttributeList} method.
     * </p>
     * 
     * @return The value of the DiskAttributeList property for this object.
     */
    public final List<String> diskAttributeList() {
        return diskAttributeList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(diskId());
        hashCode = 31 * hashCode + Objects.hashCode(diskPath());
        hashCode = 31 * hashCode + Objects.hashCode(diskNode());
        hashCode = 31 * hashCode + Objects.hashCode(diskStatus());
        hashCode = 31 * hashCode + Objects.hashCode(diskSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(diskAllocationType());
        hashCode = 31 * hashCode + Objects.hashCode(diskAllocationResource());
        hashCode = 31 * hashCode + Objects.hashCode(hasDiskAttributeList() ? diskAttributeList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Disk)) {
            return false;
        }
        Disk other = (Disk) obj;
        return Objects.equals(diskId(), other.diskId()) && Objects.equals(diskPath(), other.diskPath())
                && Objects.equals(diskNode(), other.diskNode()) && Objects.equals(diskStatus(), other.diskStatus())
                && Objects.equals(diskSizeInBytes(), other.diskSizeInBytes())
                && Objects.equals(diskAllocationType(), other.diskAllocationType())
                && Objects.equals(diskAllocationResource(), other.diskAllocationResource())
                && hasDiskAttributeList() == other.hasDiskAttributeList()
                && Objects.equals(diskAttributeList(), other.diskAttributeList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Disk").add("DiskId", diskId()).add("DiskPath", diskPath()).add("DiskNode", diskNode())
                .add("DiskStatus", diskStatus()).add("DiskSizeInBytes", diskSizeInBytes())
                .add("DiskAllocationType", diskAllocationType()).add("DiskAllocationResource", diskAllocationResource())
                .add("DiskAttributeList", hasDiskAttributeList() ? diskAttributeList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DiskId":
            return Optional.ofNullable(clazz.cast(diskId()));
        case "DiskPath":
            return Optional.ofNullable(clazz.cast(diskPath()));
        case "DiskNode":
            return Optional.ofNullable(clazz.cast(diskNode()));
        case "DiskStatus":
            return Optional.ofNullable(clazz.cast(diskStatus()));
        case "DiskSizeInBytes":
            return Optional.ofNullable(clazz.cast(diskSizeInBytes()));
        case "DiskAllocationType":
            return Optional.ofNullable(clazz.cast(diskAllocationType()));
        case "DiskAllocationResource":
            return Optional.ofNullable(clazz.cast(diskAllocationResource()));
        case "DiskAttributeList":
            return Optional.ofNullable(clazz.cast(diskAttributeList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DiskId", DISK_ID_FIELD);
        map.put("DiskPath", DISK_PATH_FIELD);
        map.put("DiskNode", DISK_NODE_FIELD);
        map.put("DiskStatus", DISK_STATUS_FIELD);
        map.put("DiskSizeInBytes", DISK_SIZE_IN_BYTES_FIELD);
        map.put("DiskAllocationType", DISK_ALLOCATION_TYPE_FIELD);
        map.put("DiskAllocationResource", DISK_ALLOCATION_RESOURCE_FIELD);
        map.put("DiskAttributeList", DISK_ATTRIBUTE_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Disk, T> g) {
        return obj -> g.apply((Disk) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Disk> {
        /**
         * <p>
         * The unique device ID or other distinguishing data that identifies a local disk.
         * </p>
         * 
         * @param diskId
         *        The unique device ID or other distinguishing data that identifies a local disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskId(String diskId);

        /**
         * <p>
         * The path of a local disk in the gateway virtual machine (VM).
         * </p>
         * 
         * @param diskPath
         *        The path of a local disk in the gateway virtual machine (VM).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskPath(String diskPath);

        /**
         * <p>
         * The device node of a local disk as assigned by the virtualization environment.
         * </p>
         * 
         * @param diskNode
         *        The device node of a local disk as assigned by the virtualization environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskNode(String diskNode);

        /**
         * <p>
         * A value that represents the status of a local disk.
         * </p>
         * 
         * @param diskStatus
         *        A value that represents the status of a local disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskStatus(String diskStatus);

        /**
         * <p>
         * The local disk size in bytes.
         * </p>
         * 
         * @param diskSizeInBytes
         *        The local disk size in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskSizeInBytes(Long diskSizeInBytes);

        /**
         * Sets the value of the DiskAllocationType property for this object.
         *
         * @param diskAllocationType
         *        The new value for the DiskAllocationType property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskAllocationType(String diskAllocationType);

        /**
         * <p>
         * The iSCSI qualified name (IQN) that is defined for a disk. This field is not included in the response if the
         * local disk is not defined as an iSCSI target. The format of this field is
         * <i>targetIqn::LUNNumber::region-volumeId</i>.
         * </p>
         * 
         * @param diskAllocationResource
         *        The iSCSI qualified name (IQN) that is defined for a disk. This field is not included in the response
         *        if the local disk is not defined as an iSCSI target. The format of this field is
         *        <i>targetIqn::LUNNumber::region-volumeId</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskAllocationResource(String diskAllocationResource);

        /**
         * Sets the value of the DiskAttributeList property for this object.
         *
         * @param diskAttributeList
         *        The new value for the DiskAttributeList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskAttributeList(Collection<String> diskAttributeList);

        /**
         * Sets the value of the DiskAttributeList property for this object.
         *
         * @param diskAttributeList
         *        The new value for the DiskAttributeList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskAttributeList(String... diskAttributeList);
    }

    static final class BuilderImpl implements Builder {
        private String diskId;

        private String diskPath;

        private String diskNode;

        private String diskStatus;

        private Long diskSizeInBytes;

        private String diskAllocationType;

        private String diskAllocationResource;

        private List<String> diskAttributeList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Disk model) {
            diskId(model.diskId);
            diskPath(model.diskPath);
            diskNode(model.diskNode);
            diskStatus(model.diskStatus);
            diskSizeInBytes(model.diskSizeInBytes);
            diskAllocationType(model.diskAllocationType);
            diskAllocationResource(model.diskAllocationResource);
            diskAttributeList(model.diskAttributeList);
        }

        public final String getDiskId() {
            return diskId;
        }

        public final void setDiskId(String diskId) {
            this.diskId = diskId;
        }

        @Override
        public final Builder diskId(String diskId) {
            this.diskId = diskId;
            return this;
        }

        public final String getDiskPath() {
            return diskPath;
        }

        public final void setDiskPath(String diskPath) {
            this.diskPath = diskPath;
        }

        @Override
        public final Builder diskPath(String diskPath) {
            this.diskPath = diskPath;
            return this;
        }

        public final String getDiskNode() {
            return diskNode;
        }

        public final void setDiskNode(String diskNode) {
            this.diskNode = diskNode;
        }

        @Override
        public final Builder diskNode(String diskNode) {
            this.diskNode = diskNode;
            return this;
        }

        public final String getDiskStatus() {
            return diskStatus;
        }

        public final void setDiskStatus(String diskStatus) {
            this.diskStatus = diskStatus;
        }

        @Override
        public final Builder diskStatus(String diskStatus) {
            this.diskStatus = diskStatus;
            return this;
        }

        public final Long getDiskSizeInBytes() {
            return diskSizeInBytes;
        }

        public final void setDiskSizeInBytes(Long diskSizeInBytes) {
            this.diskSizeInBytes = diskSizeInBytes;
        }

        @Override
        public final Builder diskSizeInBytes(Long diskSizeInBytes) {
            this.diskSizeInBytes = diskSizeInBytes;
            return this;
        }

        public final String getDiskAllocationType() {
            return diskAllocationType;
        }

        public final void setDiskAllocationType(String diskAllocationType) {
            this.diskAllocationType = diskAllocationType;
        }

        @Override
        public final Builder diskAllocationType(String diskAllocationType) {
            this.diskAllocationType = diskAllocationType;
            return this;
        }

        public final String getDiskAllocationResource() {
            return diskAllocationResource;
        }

        public final void setDiskAllocationResource(String diskAllocationResource) {
            this.diskAllocationResource = diskAllocationResource;
        }

        @Override
        public final Builder diskAllocationResource(String diskAllocationResource) {
            this.diskAllocationResource = diskAllocationResource;
            return this;
        }

        public final Collection<String> getDiskAttributeList() {
            if (diskAttributeList instanceof SdkAutoConstructList) {
                return null;
            }
            return diskAttributeList;
        }

        public final void setDiskAttributeList(Collection<String> diskAttributeList) {
            this.diskAttributeList = DiskAttributeListCopier.copy(diskAttributeList);
        }

        @Override
        public final Builder diskAttributeList(Collection<String> diskAttributeList) {
            this.diskAttributeList = DiskAttributeListCopier.copy(diskAttributeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskAttributeList(String... diskAttributeList) {
            diskAttributeList(Arrays.asList(diskAttributeList));
            return this;
        }

        @Override
        public Disk build() {
            return new Disk(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
