/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON object containing the following fields:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>ListVolumesOutput$Marker</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ListVolumesOutput$VolumeInfos</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVolumesResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<ListVolumesResponse.Builder, ListVolumesResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayARN").getter(getter(ListVolumesResponse::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListVolumesResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<VolumeInfo>> VOLUME_INFOS_FIELD = SdkField
            .<List<VolumeInfo>> builder(MarshallingType.LIST)
            .memberName("VolumeInfos")
            .getter(getter(ListVolumesResponse::volumeInfos))
            .setter(setter(Builder::volumeInfos))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeInfos").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VolumeInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(VolumeInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            MARKER_FIELD, VOLUME_INFOS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String gatewayARN;

    private final String marker;

    private final List<VolumeInfo> volumeInfos;

    private ListVolumesResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.marker = builder.marker;
        this.volumeInfos = builder.volumeInfos;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public final String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * Use the marker in your next request to continue pagination of iSCSI volumes. If there are no more volumes to
     * list, this field does not appear in the response body.
     * </p>
     * 
     * @return Use the marker in your next request to continue pagination of iSCSI volumes. If there are no more volumes
     *         to list, this field does not appear in the response body.
     */
    public final String marker() {
        return marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the VolumeInfos property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVolumeInfos() {
        return volumeInfos != null && !(volumeInfos instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <a>VolumeInfo</a> objects, where each object describes an iSCSI volume. If no volumes are defined for
     * the gateway, then <code>VolumeInfos</code> is an empty array "[]".
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVolumeInfos} method.
     * </p>
     * 
     * @return An array of <a>VolumeInfo</a> objects, where each object describes an iSCSI volume. If no volumes are
     *         defined for the gateway, then <code>VolumeInfos</code> is an empty array "[]".
     */
    public final List<VolumeInfo> volumeInfos() {
        return volumeInfos;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasVolumeInfos() ? volumeInfos() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVolumesResponse)) {
            return false;
        }
        ListVolumesResponse other = (ListVolumesResponse) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && Objects.equals(marker(), other.marker())
                && hasVolumeInfos() == other.hasVolumeInfos() && Objects.equals(volumeInfos(), other.volumeInfos());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListVolumesResponse").add("GatewayARN", gatewayARN()).add("Marker", marker())
                .add("VolumeInfos", hasVolumeInfos() ? volumeInfos() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "VolumeInfos":
            return Optional.ofNullable(clazz.cast(volumeInfos()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GatewayARN", GATEWAY_ARN_FIELD);
        map.put("Marker", MARKER_FIELD);
        map.put("VolumeInfos", VOLUME_INFOS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListVolumesResponse, T> g) {
        return obj -> g.apply((ListVolumesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListVolumesResponse> {
        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * Use the marker in your next request to continue pagination of iSCSI volumes. If there are no more volumes to
         * list, this field does not appear in the response body.
         * </p>
         * 
         * @param marker
         *        Use the marker in your next request to continue pagination of iSCSI volumes. If there are no more
         *        volumes to list, this field does not appear in the response body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * An array of <a>VolumeInfo</a> objects, where each object describes an iSCSI volume. If no volumes are defined
         * for the gateway, then <code>VolumeInfos</code> is an empty array "[]".
         * </p>
         * 
         * @param volumeInfos
         *        An array of <a>VolumeInfo</a> objects, where each object describes an iSCSI volume. If no volumes are
         *        defined for the gateway, then <code>VolumeInfos</code> is an empty array "[]".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeInfos(Collection<VolumeInfo> volumeInfos);

        /**
         * <p>
         * An array of <a>VolumeInfo</a> objects, where each object describes an iSCSI volume. If no volumes are defined
         * for the gateway, then <code>VolumeInfos</code> is an empty array "[]".
         * </p>
         * 
         * @param volumeInfos
         *        An array of <a>VolumeInfo</a> objects, where each object describes an iSCSI volume. If no volumes are
         *        defined for the gateway, then <code>VolumeInfos</code> is an empty array "[]".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeInfos(VolumeInfo... volumeInfos);

        /**
         * <p>
         * An array of <a>VolumeInfo</a> objects, where each object describes an iSCSI volume. If no volumes are defined
         * for the gateway, then <code>VolumeInfos</code> is an empty array "[]".
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.storagegateway.model.VolumeInfo.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.storagegateway.model.VolumeInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.storagegateway.model.VolumeInfo.Builder#build()} is called immediately
         * and its result is passed to {@link #volumeInfos(List<VolumeInfo>)}.
         * 
         * @param volumeInfos
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.storagegateway.model.VolumeInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumeInfos(java.util.Collection<VolumeInfo>)
         */
        Builder volumeInfos(Consumer<VolumeInfo.Builder>... volumeInfos);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private String gatewayARN;

        private String marker;

        private List<VolumeInfo> volumeInfos = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVolumesResponse model) {
            super(model);
            gatewayARN(model.gatewayARN);
            marker(model.marker);
            volumeInfos(model.volumeInfos);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<VolumeInfo.Builder> getVolumeInfos() {
            List<VolumeInfo.Builder> result = VolumeInfosCopier.copyToBuilder(this.volumeInfos);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumeInfos(Collection<VolumeInfo.BuilderImpl> volumeInfos) {
            this.volumeInfos = VolumeInfosCopier.copyFromBuilder(volumeInfos);
        }

        @Override
        public final Builder volumeInfos(Collection<VolumeInfo> volumeInfos) {
            this.volumeInfos = VolumeInfosCopier.copy(volumeInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeInfos(VolumeInfo... volumeInfos) {
            volumeInfos(Arrays.asList(volumeInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeInfos(Consumer<VolumeInfo.Builder>... volumeInfos) {
            volumeInfos(Stream.of(volumeInfos).map(c -> VolumeInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListVolumesResponse build() {
            return new ListVolumesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
