/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a gateway's network interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkInterface implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkInterface.Builder, NetworkInterface> {
    private static final SdkField<String> IPV4_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Ipv4Address").getter(getter(NetworkInterface::ipv4Address)).setter(setter(Builder::ipv4Address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4Address").build()).build();

    private static final SdkField<String> MAC_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MacAddress").getter(getter(NetworkInterface::macAddress)).setter(setter(Builder::macAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacAddress").build()).build();

    private static final SdkField<String> IPV6_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Ipv6Address").getter(getter(NetworkInterface::ipv6Address)).setter(setter(Builder::ipv6Address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Address").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPV4_ADDRESS_FIELD,
            MAC_ADDRESS_FIELD, IPV6_ADDRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ipv4Address;

    private final String macAddress;

    private final String ipv6Address;

    private NetworkInterface(BuilderImpl builder) {
        this.ipv4Address = builder.ipv4Address;
        this.macAddress = builder.macAddress;
        this.ipv6Address = builder.ipv6Address;
    }

    /**
     * <p>
     * The Internet Protocol version 4 (IPv4) address of the interface.
     * </p>
     * 
     * @return The Internet Protocol version 4 (IPv4) address of the interface.
     */
    public final String ipv4Address() {
        return ipv4Address;
    }

    /**
     * <p>
     * The Media Access Control (MAC) address of the interface.
     * </p>
     * <note>
     * <p>
     * This is currently unsupported and will not be returned in output.
     * </p>
     * </note>
     * 
     * @return The Media Access Control (MAC) address of the interface.</p> <note>
     *         <p>
     *         This is currently unsupported and will not be returned in output.
     *         </p>
     */
    public final String macAddress() {
        return macAddress;
    }

    /**
     * <p>
     * The Internet Protocol version 6 (IPv6) address of the interface. <i>Currently not supported</i>.
     * </p>
     * 
     * @return The Internet Protocol version 6 (IPv6) address of the interface. <i>Currently not supported</i>.
     */
    public final String ipv6Address() {
        return ipv6Address;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipv4Address());
        hashCode = 31 * hashCode + Objects.hashCode(macAddress());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6Address());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface other = (NetworkInterface) obj;
        return Objects.equals(ipv4Address(), other.ipv4Address()) && Objects.equals(macAddress(), other.macAddress())
                && Objects.equals(ipv6Address(), other.ipv6Address());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkInterface").add("Ipv4Address", ipv4Address()).add("MacAddress", macAddress())
                .add("Ipv6Address", ipv6Address()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ipv4Address":
            return Optional.ofNullable(clazz.cast(ipv4Address()));
        case "MacAddress":
            return Optional.ofNullable(clazz.cast(macAddress()));
        case "Ipv6Address":
            return Optional.ofNullable(clazz.cast(ipv6Address()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Ipv4Address", IPV4_ADDRESS_FIELD);
        map.put("MacAddress", MAC_ADDRESS_FIELD);
        map.put("Ipv6Address", IPV6_ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkInterface, T> g) {
        return obj -> g.apply((NetworkInterface) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkInterface> {
        /**
         * <p>
         * The Internet Protocol version 4 (IPv4) address of the interface.
         * </p>
         * 
         * @param ipv4Address
         *        The Internet Protocol version 4 (IPv4) address of the interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4Address(String ipv4Address);

        /**
         * <p>
         * The Media Access Control (MAC) address of the interface.
         * </p>
         * <note>
         * <p>
         * This is currently unsupported and will not be returned in output.
         * </p>
         * </note>
         * 
         * @param macAddress
         *        The Media Access Control (MAC) address of the interface.</p> <note>
         *        <p>
         *        This is currently unsupported and will not be returned in output.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macAddress(String macAddress);

        /**
         * <p>
         * The Internet Protocol version 6 (IPv6) address of the interface. <i>Currently not supported</i>.
         * </p>
         * 
         * @param ipv6Address
         *        The Internet Protocol version 6 (IPv6) address of the interface. <i>Currently not supported</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Address(String ipv6Address);
    }

    static final class BuilderImpl implements Builder {
        private String ipv4Address;

        private String macAddress;

        private String ipv6Address;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterface model) {
            ipv4Address(model.ipv4Address);
            macAddress(model.macAddress);
            ipv6Address(model.ipv6Address);
        }

        public final String getIpv4Address() {
            return ipv4Address;
        }

        public final void setIpv4Address(String ipv4Address) {
            this.ipv4Address = ipv4Address;
        }

        @Override
        public final Builder ipv4Address(String ipv4Address) {
            this.ipv4Address = ipv4Address;
            return this;
        }

        public final String getMacAddress() {
            return macAddress;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final String getIpv6Address() {
            return ipv6Address;
        }

        public final void setIpv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
        }

        @Override
        public final Builder ipv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
            return this;
        }

        @Override
        public NetworkInterface build() {
            return new NetworkInterface(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
