/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * RefreshCacheOutput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RefreshCacheResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<RefreshCacheResponse.Builder, RefreshCacheResponse> {
    private static final SdkField<String> FILE_SHARE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileShareARN").getter(getter(RefreshCacheResponse::fileShareARN)).setter(setter(Builder::fileShareARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareARN").build()).build();

    private static final SdkField<String> NOTIFICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotificationId").getter(getter(RefreshCacheResponse::notificationId))
            .setter(setter(Builder::notificationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SHARE_ARN_FIELD,
            NOTIFICATION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String fileShareARN;

    private final String notificationId;

    private RefreshCacheResponse(BuilderImpl builder) {
        super(builder);
        this.fileShareARN = builder.fileShareARN;
        this.notificationId = builder.notificationId;
    }

    /**
     * Returns the value of the FileShareARN property for this object.
     * 
     * @return The value of the FileShareARN property for this object.
     */
    public final String fileShareARN() {
        return fileShareARN;
    }

    /**
     * Returns the value of the NotificationId property for this object.
     * 
     * @return The value of the NotificationId property for this object.
     */
    public final String notificationId() {
        return notificationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fileShareARN());
        hashCode = 31 * hashCode + Objects.hashCode(notificationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefreshCacheResponse)) {
            return false;
        }
        RefreshCacheResponse other = (RefreshCacheResponse) obj;
        return Objects.equals(fileShareARN(), other.fileShareARN()) && Objects.equals(notificationId(), other.notificationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RefreshCacheResponse").add("FileShareARN", fileShareARN())
                .add("NotificationId", notificationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileShareARN":
            return Optional.ofNullable(clazz.cast(fileShareARN()));
        case "NotificationId":
            return Optional.ofNullable(clazz.cast(notificationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FileShareARN", FILE_SHARE_ARN_FIELD);
        map.put("NotificationId", NOTIFICATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RefreshCacheResponse, T> g) {
        return obj -> g.apply((RefreshCacheResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, RefreshCacheResponse> {
        /**
         * Sets the value of the FileShareARN property for this object.
         *
         * @param fileShareARN
         *        The new value for the FileShareARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileShareARN(String fileShareARN);

        /**
         * Sets the value of the NotificationId property for this object.
         *
         * @param notificationId
         *        The new value for the NotificationId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationId(String notificationId);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private String fileShareARN;

        private String notificationId;

        private BuilderImpl() {
        }

        private BuilderImpl(RefreshCacheResponse model) {
            super(model);
            fileShareARN(model.fileShareARN);
            notificationId(model.notificationId);
        }

        public final String getFileShareARN() {
            return fileShareARN;
        }

        public final void setFileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
        }

        @Override
        public final Builder fileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
            return this;
        }

        public final String getNotificationId() {
            return notificationId;
        }

        public final void setNotificationId(String notificationId) {
            this.notificationId = notificationId;
        }

        @Override
        public final Builder notificationId(String notificationId) {
            this.notificationId = notificationId;
            return this;
        }

        @Override
        public RefreshCacheResponse build() {
            return new RefreshCacheResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
