/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of Active Directory users and groups that have special permissions for SMB file shares on the gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SMBLocalGroups implements SdkPojo, Serializable, ToCopyableBuilder<SMBLocalGroups.Builder, SMBLocalGroups> {
    private static final SdkField<List<String>> GATEWAY_ADMINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("GatewayAdmins")
            .getter(getter(SMBLocalGroups::gatewayAdmins))
            .setter(setter(Builder::gatewayAdmins))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayAdmins").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ADMINS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> gatewayAdmins;

    private SMBLocalGroups(BuilderImpl builder) {
        this.gatewayAdmins = builder.gatewayAdmins;
    }

    /**
     * For responses, this returns true if the service returned a value for the GatewayAdmins property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGatewayAdmins() {
        return gatewayAdmins != null && !(gatewayAdmins instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Active Directory users and groups that have local Gateway Admin permissions. Acceptable formats
     * include: <code>DOMAIN\User1</code>, <code>user1</code>, <code>DOMAIN\group1</code>, and <code>group1</code>.
     * </p>
     * <p>
     * Gateway Admins can use the Shared Folders Microsoft Management Console snap-in to force-close files that are open
     * and locked.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGatewayAdmins} method.
     * </p>
     * 
     * @return A list of Active Directory users and groups that have local Gateway Admin permissions. Acceptable formats
     *         include: <code>DOMAIN\User1</code>, <code>user1</code>, <code>DOMAIN\group1</code>, and
     *         <code>group1</code>.</p>
     *         <p>
     *         Gateway Admins can use the Shared Folders Microsoft Management Console snap-in to force-close files that
     *         are open and locked.
     */
    public final List<String> gatewayAdmins() {
        return gatewayAdmins;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasGatewayAdmins() ? gatewayAdmins() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SMBLocalGroups)) {
            return false;
        }
        SMBLocalGroups other = (SMBLocalGroups) obj;
        return hasGatewayAdmins() == other.hasGatewayAdmins() && Objects.equals(gatewayAdmins(), other.gatewayAdmins());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SMBLocalGroups").add("GatewayAdmins", hasGatewayAdmins() ? gatewayAdmins() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayAdmins":
            return Optional.ofNullable(clazz.cast(gatewayAdmins()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GatewayAdmins", GATEWAY_ADMINS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SMBLocalGroups, T> g) {
        return obj -> g.apply((SMBLocalGroups) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SMBLocalGroups> {
        /**
         * <p>
         * A list of Active Directory users and groups that have local Gateway Admin permissions. Acceptable formats
         * include: <code>DOMAIN\User1</code>, <code>user1</code>, <code>DOMAIN\group1</code>, and <code>group1</code>.
         * </p>
         * <p>
         * Gateway Admins can use the Shared Folders Microsoft Management Console snap-in to force-close files that are
         * open and locked.
         * </p>
         * 
         * @param gatewayAdmins
         *        A list of Active Directory users and groups that have local Gateway Admin permissions. Acceptable
         *        formats include: <code>DOMAIN\User1</code>, <code>user1</code>, <code>DOMAIN\group1</code>, and
         *        <code>group1</code>.</p>
         *        <p>
         *        Gateway Admins can use the Shared Folders Microsoft Management Console snap-in to force-close files
         *        that are open and locked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayAdmins(Collection<String> gatewayAdmins);

        /**
         * <p>
         * A list of Active Directory users and groups that have local Gateway Admin permissions. Acceptable formats
         * include: <code>DOMAIN\User1</code>, <code>user1</code>, <code>DOMAIN\group1</code>, and <code>group1</code>.
         * </p>
         * <p>
         * Gateway Admins can use the Shared Folders Microsoft Management Console snap-in to force-close files that are
         * open and locked.
         * </p>
         * 
         * @param gatewayAdmins
         *        A list of Active Directory users and groups that have local Gateway Admin permissions. Acceptable
         *        formats include: <code>DOMAIN\User1</code>, <code>user1</code>, <code>DOMAIN\group1</code>, and
         *        <code>group1</code>.</p>
         *        <p>
         *        Gateway Admins can use the Shared Folders Microsoft Management Console snap-in to force-close files
         *        that are open and locked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayAdmins(String... gatewayAdmins);
    }

    static final class BuilderImpl implements Builder {
        private List<String> gatewayAdmins = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SMBLocalGroups model) {
            gatewayAdmins(model.gatewayAdmins);
        }

        public final Collection<String> getGatewayAdmins() {
            if (gatewayAdmins instanceof SdkAutoConstructList) {
                return null;
            }
            return gatewayAdmins;
        }

        public final void setGatewayAdmins(Collection<String> gatewayAdmins) {
            this.gatewayAdmins = UserListCopier.copy(gatewayAdmins);
        }

        @Override
        public final Builder gatewayAdmins(Collection<String> gatewayAdmins) {
            this.gatewayAdmins = UserListCopier.copy(gatewayAdmins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayAdmins(String... gatewayAdmins) {
            gatewayAdmins(Arrays.asList(gatewayAdmins));
            return this;
        }

        @Override
        public SMBLocalGroups build() {
            return new SMBLocalGroups(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
