/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of variables indicating the software update preferences for the gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SoftwareUpdatePreferences implements SdkPojo, Serializable,
        ToCopyableBuilder<SoftwareUpdatePreferences.Builder, SoftwareUpdatePreferences> {
    private static final SdkField<String> AUTOMATIC_UPDATE_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutomaticUpdatePolicy").getter(getter(SoftwareUpdatePreferences::automaticUpdatePolicyAsString))
            .setter(setter(Builder::automaticUpdatePolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticUpdatePolicy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(AUTOMATIC_UPDATE_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String automaticUpdatePolicy;

    private SoftwareUpdatePreferences(BuilderImpl builder) {
        this.automaticUpdatePolicy = builder.automaticUpdatePolicy;
    }

    /**
     * <p>
     * Indicates the automatic update policy for a gateway.
     * </p>
     * <p>
     * <code>ALL_VERSIONS</code> - Enables regular gateway maintenance updates.
     * </p>
     * <p>
     * <code>EMERGENCY_VERSIONS_ONLY</code> - Disables regular gateway maintenance updates. The gateway will still
     * receive emergency version updates on rare occasions if necessary to remedy highly critical security or durability
     * issues. You will be notified before an emergency version update is applied. These updates are applied during your
     * gateway's scheduled maintenance window.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #automaticUpdatePolicy} will return {@link AutomaticUpdatePolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #automaticUpdatePolicyAsString}.
     * </p>
     * 
     * @return Indicates the automatic update policy for a gateway.</p>
     *         <p>
     *         <code>ALL_VERSIONS</code> - Enables regular gateway maintenance updates.
     *         </p>
     *         <p>
     *         <code>EMERGENCY_VERSIONS_ONLY</code> - Disables regular gateway maintenance updates. The gateway will
     *         still receive emergency version updates on rare occasions if necessary to remedy highly critical security
     *         or durability issues. You will be notified before an emergency version update is applied. These updates
     *         are applied during your gateway's scheduled maintenance window.
     * @see AutomaticUpdatePolicy
     */
    public final AutomaticUpdatePolicy automaticUpdatePolicy() {
        return AutomaticUpdatePolicy.fromValue(automaticUpdatePolicy);
    }

    /**
     * <p>
     * Indicates the automatic update policy for a gateway.
     * </p>
     * <p>
     * <code>ALL_VERSIONS</code> - Enables regular gateway maintenance updates.
     * </p>
     * <p>
     * <code>EMERGENCY_VERSIONS_ONLY</code> - Disables regular gateway maintenance updates. The gateway will still
     * receive emergency version updates on rare occasions if necessary to remedy highly critical security or durability
     * issues. You will be notified before an emergency version update is applied. These updates are applied during your
     * gateway's scheduled maintenance window.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #automaticUpdatePolicy} will return {@link AutomaticUpdatePolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #automaticUpdatePolicyAsString}.
     * </p>
     * 
     * @return Indicates the automatic update policy for a gateway.</p>
     *         <p>
     *         <code>ALL_VERSIONS</code> - Enables regular gateway maintenance updates.
     *         </p>
     *         <p>
     *         <code>EMERGENCY_VERSIONS_ONLY</code> - Disables regular gateway maintenance updates. The gateway will
     *         still receive emergency version updates on rare occasions if necessary to remedy highly critical security
     *         or durability issues. You will be notified before an emergency version update is applied. These updates
     *         are applied during your gateway's scheduled maintenance window.
     * @see AutomaticUpdatePolicy
     */
    public final String automaticUpdatePolicyAsString() {
        return automaticUpdatePolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(automaticUpdatePolicyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SoftwareUpdatePreferences)) {
            return false;
        }
        SoftwareUpdatePreferences other = (SoftwareUpdatePreferences) obj;
        return Objects.equals(automaticUpdatePolicyAsString(), other.automaticUpdatePolicyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SoftwareUpdatePreferences").add("AutomaticUpdatePolicy", automaticUpdatePolicyAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutomaticUpdatePolicy":
            return Optional.ofNullable(clazz.cast(automaticUpdatePolicyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AutomaticUpdatePolicy", AUTOMATIC_UPDATE_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SoftwareUpdatePreferences, T> g) {
        return obj -> g.apply((SoftwareUpdatePreferences) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SoftwareUpdatePreferences> {
        /**
         * <p>
         * Indicates the automatic update policy for a gateway.
         * </p>
         * <p>
         * <code>ALL_VERSIONS</code> - Enables regular gateway maintenance updates.
         * </p>
         * <p>
         * <code>EMERGENCY_VERSIONS_ONLY</code> - Disables regular gateway maintenance updates. The gateway will still
         * receive emergency version updates on rare occasions if necessary to remedy highly critical security or
         * durability issues. You will be notified before an emergency version update is applied. These updates are
         * applied during your gateway's scheduled maintenance window.
         * </p>
         * 
         * @param automaticUpdatePolicy
         *        Indicates the automatic update policy for a gateway.</p>
         *        <p>
         *        <code>ALL_VERSIONS</code> - Enables regular gateway maintenance updates.
         *        </p>
         *        <p>
         *        <code>EMERGENCY_VERSIONS_ONLY</code> - Disables regular gateway maintenance updates. The gateway will
         *        still receive emergency version updates on rare occasions if necessary to remedy highly critical
         *        security or durability issues. You will be notified before an emergency version update is applied.
         *        These updates are applied during your gateway's scheduled maintenance window.
         * @see AutomaticUpdatePolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomaticUpdatePolicy
         */
        Builder automaticUpdatePolicy(String automaticUpdatePolicy);

        /**
         * <p>
         * Indicates the automatic update policy for a gateway.
         * </p>
         * <p>
         * <code>ALL_VERSIONS</code> - Enables regular gateway maintenance updates.
         * </p>
         * <p>
         * <code>EMERGENCY_VERSIONS_ONLY</code> - Disables regular gateway maintenance updates. The gateway will still
         * receive emergency version updates on rare occasions if necessary to remedy highly critical security or
         * durability issues. You will be notified before an emergency version update is applied. These updates are
         * applied during your gateway's scheduled maintenance window.
         * </p>
         * 
         * @param automaticUpdatePolicy
         *        Indicates the automatic update policy for a gateway.</p>
         *        <p>
         *        <code>ALL_VERSIONS</code> - Enables regular gateway maintenance updates.
         *        </p>
         *        <p>
         *        <code>EMERGENCY_VERSIONS_ONLY</code> - Disables regular gateway maintenance updates. The gateway will
         *        still receive emergency version updates on rare occasions if necessary to remedy highly critical
         *        security or durability issues. You will be notified before an emergency version update is applied.
         *        These updates are applied during your gateway's scheduled maintenance window.
         * @see AutomaticUpdatePolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomaticUpdatePolicy
         */
        Builder automaticUpdatePolicy(AutomaticUpdatePolicy automaticUpdatePolicy);
    }

    static final class BuilderImpl implements Builder {
        private String automaticUpdatePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(SoftwareUpdatePreferences model) {
            automaticUpdatePolicy(model.automaticUpdatePolicy);
        }

        public final String getAutomaticUpdatePolicy() {
            return automaticUpdatePolicy;
        }

        public final void setAutomaticUpdatePolicy(String automaticUpdatePolicy) {
            this.automaticUpdatePolicy = automaticUpdatePolicy;
        }

        @Override
        public final Builder automaticUpdatePolicy(String automaticUpdatePolicy) {
            this.automaticUpdatePolicy = automaticUpdatePolicy;
            return this;
        }

        @Override
        public final Builder automaticUpdatePolicy(AutomaticUpdatePolicy automaticUpdatePolicy) {
            this.automaticUpdatePolicy(automaticUpdatePolicy == null ? null : automaticUpdatePolicy.toString());
            return this;
        }

        @Override
        public SoftwareUpdatePreferences build() {
            return new SoftwareUpdatePreferences(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
