/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartCacheReportRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<StartCacheReportRequest.Builder, StartCacheReportRequest> {
    private static final SdkField<String> FILE_SHARE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileShareARN").getter(getter(StartCacheReportRequest::fileShareARN))
            .setter(setter(Builder::fileShareARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareARN").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(StartCacheReportRequest::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationARN").getter(getter(StartCacheReportRequest::locationARN)).setter(setter(Builder::locationARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationARN").build()).build();

    private static final SdkField<String> BUCKET_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketRegion").getter(getter(StartCacheReportRequest::bucketRegion))
            .setter(setter(Builder::bucketRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketRegion").build()).build();

    private static final SdkField<String> VPC_ENDPOINT_DNS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VPCEndpointDNSName").getter(getter(StartCacheReportRequest::vpcEndpointDNSName))
            .setter(setter(Builder::vpcEndpointDNSName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCEndpointDNSName").build())
            .build();

    private static final SdkField<List<CacheReportFilter>> INCLUSION_FILTERS_FIELD = SdkField
            .<List<CacheReportFilter>> builder(MarshallingType.LIST)
            .memberName("InclusionFilters")
            .getter(getter(StartCacheReportRequest::inclusionFilters))
            .setter(setter(Builder::inclusionFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CacheReportFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CacheReportFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CacheReportFilter>> EXCLUSION_FILTERS_FIELD = SdkField
            .<List<CacheReportFilter>> builder(MarshallingType.LIST)
            .memberName("ExclusionFilters")
            .getter(getter(StartCacheReportRequest::exclusionFilters))
            .setter(setter(Builder::exclusionFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CacheReportFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CacheReportFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(StartCacheReportRequest::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(StartCacheReportRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SHARE_ARN_FIELD,
            ROLE_FIELD, LOCATION_ARN_FIELD, BUCKET_REGION_FIELD, VPC_ENDPOINT_DNS_NAME_FIELD, INCLUSION_FILTERS_FIELD,
            EXCLUSION_FILTERS_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String fileShareARN;

    private final String role;

    private final String locationARN;

    private final String bucketRegion;

    private final String vpcEndpointDNSName;

    private final List<CacheReportFilter> inclusionFilters;

    private final List<CacheReportFilter> exclusionFilters;

    private final String clientToken;

    private final List<Tag> tags;

    private StartCacheReportRequest(BuilderImpl builder) {
        super(builder);
        this.fileShareARN = builder.fileShareARN;
        this.role = builder.role;
        this.locationARN = builder.locationARN;
        this.bucketRegion = builder.bucketRegion;
        this.vpcEndpointDNSName = builder.vpcEndpointDNSName;
        this.inclusionFilters = builder.inclusionFilters;
        this.exclusionFilters = builder.exclusionFilters;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * Returns the value of the FileShareARN property for this object.
     * 
     * @return The value of the FileShareARN property for this object.
     */
    public final String fileShareARN() {
        return fileShareARN;
    }

    /**
     * <p>
     * The ARN of the IAM role used when saving the cache report to Amazon S3.
     * </p>
     * 
     * @return The ARN of the IAM role used when saving the cache report to Amazon S3.
     */
    public final String role() {
        return role;
    }

    /**
     * <p>
     * The ARN of the Amazon S3 bucket where the cache report will be saved.
     * </p>
     * <note>
     * <p>
     * We do not recommend saving the cache report to the same Amazon S3 bucket for which you are generating the report.
     * </p>
     * <p>
     * This field does not accept access point ARNs.
     * </p>
     * </note>
     * 
     * @return The ARN of the Amazon S3 bucket where the cache report will be saved.</p> <note>
     *         <p>
     *         We do not recommend saving the cache report to the same Amazon S3 bucket for which you are generating the
     *         report.
     *         </p>
     *         <p>
     *         This field does not accept access point ARNs.
     *         </p>
     */
    public final String locationARN() {
        return locationARN;
    }

    /**
     * <p>
     * The Amazon Web Services Region of the Amazon S3 bucket associated with the file share for which you want to
     * generate the cache report.
     * </p>
     * 
     * @return The Amazon Web Services Region of the Amazon S3 bucket associated with the file share for which you want
     *         to generate the cache report.
     */
    public final String bucketRegion() {
        return bucketRegion;
    }

    /**
     * <p>
     * The DNS name of the VPC endpoint associated with the Amazon S3 where you want to save the cache report. Optional.
     * </p>
     * 
     * @return The DNS name of the VPC endpoint associated with the Amazon S3 where you want to save the cache report.
     *         Optional.
     */
    public final String vpcEndpointDNSName() {
        return vpcEndpointDNSName;
    }

    /**
     * For responses, this returns true if the service returned a value for the InclusionFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInclusionFilters() {
        return inclusionFilters != null && !(inclusionFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of filters and parameters that determine which files are included in the report. You must specify at
     * least one value for <code>InclusionFilters</code> or <code>ExclusionFilters</code> in a
     * <code>StartCacheReport</code> request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInclusionFilters} method.
     * </p>
     * 
     * @return The list of filters and parameters that determine which files are included in the report. You must
     *         specify at least one value for <code>InclusionFilters</code> or <code>ExclusionFilters</code> in a
     *         <code>StartCacheReport</code> request.
     */
    public final List<CacheReportFilter> inclusionFilters() {
        return inclusionFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExclusionFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExclusionFilters() {
        return exclusionFilters != null && !(exclusionFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of filters and parameters that determine which files are excluded from the report. You must specify at
     * least one value for <code>InclusionFilters</code> or <code>ExclusionFilters</code> in a
     * <code>StartCacheReport</code> request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExclusionFilters} method.
     * </p>
     * 
     * @return The list of filters and parameters that determine which files are excluded from the report. You must
     *         specify at least one value for <code>InclusionFilters</code> or <code>ExclusionFilters</code> in a
     *         <code>StartCacheReport</code> request.
     */
    public final List<CacheReportFilter> exclusionFilters() {
        return exclusionFilters;
    }

    /**
     * <p>
     * A unique identifier that you use to ensure idempotent report generation if you need to retry an unsuccessful
     * <code>StartCacheReport</code> request. If you retry a request, use the same <code>ClientToken</code> you
     * specified in the initial request.
     * </p>
     * 
     * @return A unique identifier that you use to ensure idempotent report generation if you need to retry an
     *         unsuccessful <code>StartCacheReport</code> request. If you retry a request, use the same
     *         <code>ClientToken</code> you specified in the initial request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of up to 50 key/value tags that you can assign to the cache report. Using tags can help you categorize
     * your reports and more easily locate them in search results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of up to 50 key/value tags that you can assign to the cache report. Using tags can help you
     *         categorize your reports and more easily locate them in search results.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fileShareARN());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(locationARN());
        hashCode = 31 * hashCode + Objects.hashCode(bucketRegion());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointDNSName());
        hashCode = 31 * hashCode + Objects.hashCode(hasInclusionFilters() ? inclusionFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExclusionFilters() ? exclusionFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCacheReportRequest)) {
            return false;
        }
        StartCacheReportRequest other = (StartCacheReportRequest) obj;
        return Objects.equals(fileShareARN(), other.fileShareARN()) && Objects.equals(role(), other.role())
                && Objects.equals(locationARN(), other.locationARN()) && Objects.equals(bucketRegion(), other.bucketRegion())
                && Objects.equals(vpcEndpointDNSName(), other.vpcEndpointDNSName())
                && hasInclusionFilters() == other.hasInclusionFilters()
                && Objects.equals(inclusionFilters(), other.inclusionFilters())
                && hasExclusionFilters() == other.hasExclusionFilters()
                && Objects.equals(exclusionFilters(), other.exclusionFilters())
                && Objects.equals(clientToken(), other.clientToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartCacheReportRequest").add("FileShareARN", fileShareARN()).add("Role", role())
                .add("LocationARN", locationARN()).add("BucketRegion", bucketRegion())
                .add("VPCEndpointDNSName", vpcEndpointDNSName())
                .add("InclusionFilters", hasInclusionFilters() ? inclusionFilters() : null)
                .add("ExclusionFilters", hasExclusionFilters() ? exclusionFilters() : null).add("ClientToken", clientToken())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileShareARN":
            return Optional.ofNullable(clazz.cast(fileShareARN()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "LocationARN":
            return Optional.ofNullable(clazz.cast(locationARN()));
        case "BucketRegion":
            return Optional.ofNullable(clazz.cast(bucketRegion()));
        case "VPCEndpointDNSName":
            return Optional.ofNullable(clazz.cast(vpcEndpointDNSName()));
        case "InclusionFilters":
            return Optional.ofNullable(clazz.cast(inclusionFilters()));
        case "ExclusionFilters":
            return Optional.ofNullable(clazz.cast(exclusionFilters()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FileShareARN", FILE_SHARE_ARN_FIELD);
        map.put("Role", ROLE_FIELD);
        map.put("LocationARN", LOCATION_ARN_FIELD);
        map.put("BucketRegion", BUCKET_REGION_FIELD);
        map.put("VPCEndpointDNSName", VPC_ENDPOINT_DNS_NAME_FIELD);
        map.put("InclusionFilters", INCLUSION_FILTERS_FIELD);
        map.put("ExclusionFilters", EXCLUSION_FILTERS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartCacheReportRequest, T> g) {
        return obj -> g.apply((StartCacheReportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartCacheReportRequest> {
        /**
         * Sets the value of the FileShareARN property for this object.
         *
         * @param fileShareARN
         *        The new value for the FileShareARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileShareARN(String fileShareARN);

        /**
         * <p>
         * The ARN of the IAM role used when saving the cache report to Amazon S3.
         * </p>
         * 
         * @param role
         *        The ARN of the IAM role used when saving the cache report to Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * The ARN of the Amazon S3 bucket where the cache report will be saved.
         * </p>
         * <note>
         * <p>
         * We do not recommend saving the cache report to the same Amazon S3 bucket for which you are generating the
         * report.
         * </p>
         * <p>
         * This field does not accept access point ARNs.
         * </p>
         * </note>
         * 
         * @param locationARN
         *        The ARN of the Amazon S3 bucket where the cache report will be saved.</p> <note>
         *        <p>
         *        We do not recommend saving the cache report to the same Amazon S3 bucket for which you are generating
         *        the report.
         *        </p>
         *        <p>
         *        This field does not accept access point ARNs.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationARN(String locationARN);

        /**
         * <p>
         * The Amazon Web Services Region of the Amazon S3 bucket associated with the file share for which you want to
         * generate the cache report.
         * </p>
         * 
         * @param bucketRegion
         *        The Amazon Web Services Region of the Amazon S3 bucket associated with the file share for which you
         *        want to generate the cache report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketRegion(String bucketRegion);

        /**
         * <p>
         * The DNS name of the VPC endpoint associated with the Amazon S3 where you want to save the cache report.
         * Optional.
         * </p>
         * 
         * @param vpcEndpointDNSName
         *        The DNS name of the VPC endpoint associated with the Amazon S3 where you want to save the cache
         *        report. Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointDNSName(String vpcEndpointDNSName);

        /**
         * <p>
         * The list of filters and parameters that determine which files are included in the report. You must specify at
         * least one value for <code>InclusionFilters</code> or <code>ExclusionFilters</code> in a
         * <code>StartCacheReport</code> request.
         * </p>
         * 
         * @param inclusionFilters
         *        The list of filters and parameters that determine which files are included in the report. You must
         *        specify at least one value for <code>InclusionFilters</code> or <code>ExclusionFilters</code> in a
         *        <code>StartCacheReport</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusionFilters(Collection<CacheReportFilter> inclusionFilters);

        /**
         * <p>
         * The list of filters and parameters that determine which files are included in the report. You must specify at
         * least one value for <code>InclusionFilters</code> or <code>ExclusionFilters</code> in a
         * <code>StartCacheReport</code> request.
         * </p>
         * 
         * @param inclusionFilters
         *        The list of filters and parameters that determine which files are included in the report. You must
         *        specify at least one value for <code>InclusionFilters</code> or <code>ExclusionFilters</code> in a
         *        <code>StartCacheReport</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusionFilters(CacheReportFilter... inclusionFilters);

        /**
         * <p>
         * The list of filters and parameters that determine which files are included in the report. You must specify at
         * least one value for <code>InclusionFilters</code> or <code>ExclusionFilters</code> in a
         * <code>StartCacheReport</code> request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.storagegateway.model.CacheReportFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.storagegateway.model.CacheReportFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.storagegateway.model.CacheReportFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #inclusionFilters(List<CacheReportFilter>)}.
         * 
         * @param inclusionFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.storagegateway.model.CacheReportFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inclusionFilters(java.util.Collection<CacheReportFilter>)
         */
        Builder inclusionFilters(Consumer<CacheReportFilter.Builder>... inclusionFilters);

        /**
         * <p>
         * The list of filters and parameters that determine which files are excluded from the report. You must specify
         * at least one value for <code>InclusionFilters</code> or <code>ExclusionFilters</code> in a
         * <code>StartCacheReport</code> request.
         * </p>
         * 
         * @param exclusionFilters
         *        The list of filters and parameters that determine which files are excluded from the report. You must
         *        specify at least one value for <code>InclusionFilters</code> or <code>ExclusionFilters</code> in a
         *        <code>StartCacheReport</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusionFilters(Collection<CacheReportFilter> exclusionFilters);

        /**
         * <p>
         * The list of filters and parameters that determine which files are excluded from the report. You must specify
         * at least one value for <code>InclusionFilters</code> or <code>ExclusionFilters</code> in a
         * <code>StartCacheReport</code> request.
         * </p>
         * 
         * @param exclusionFilters
         *        The list of filters and parameters that determine which files are excluded from the report. You must
         *        specify at least one value for <code>InclusionFilters</code> or <code>ExclusionFilters</code> in a
         *        <code>StartCacheReport</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusionFilters(CacheReportFilter... exclusionFilters);

        /**
         * <p>
         * The list of filters and parameters that determine which files are excluded from the report. You must specify
         * at least one value for <code>InclusionFilters</code> or <code>ExclusionFilters</code> in a
         * <code>StartCacheReport</code> request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.storagegateway.model.CacheReportFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.storagegateway.model.CacheReportFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.storagegateway.model.CacheReportFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #exclusionFilters(List<CacheReportFilter>)}.
         * 
         * @param exclusionFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.storagegateway.model.CacheReportFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exclusionFilters(java.util.Collection<CacheReportFilter>)
         */
        Builder exclusionFilters(Consumer<CacheReportFilter.Builder>... exclusionFilters);

        /**
         * <p>
         * A unique identifier that you use to ensure idempotent report generation if you need to retry an unsuccessful
         * <code>StartCacheReport</code> request. If you retry a request, use the same <code>ClientToken</code> you
         * specified in the initial request.
         * </p>
         * 
         * @param clientToken
         *        A unique identifier that you use to ensure idempotent report generation if you need to retry an
         *        unsuccessful <code>StartCacheReport</code> request. If you retry a request, use the same
         *        <code>ClientToken</code> you specified in the initial request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A list of up to 50 key/value tags that you can assign to the cache report. Using tags can help you categorize
         * your reports and more easily locate them in search results.
         * </p>
         * 
         * @param tags
         *        A list of up to 50 key/value tags that you can assign to the cache report. Using tags can help you
         *        categorize your reports and more easily locate them in search results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of up to 50 key/value tags that you can assign to the cache report. Using tags can help you categorize
         * your reports and more easily locate them in search results.
         * </p>
         * 
         * @param tags
         *        A list of up to 50 key/value tags that you can assign to the cache report. Using tags can help you
         *        categorize your reports and more easily locate them in search results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of up to 50 key/value tags that you can assign to the cache report. Using tags can help you categorize
         * your reports and more easily locate them in search results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.storagegateway.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.storagegateway.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.storagegateway.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.storagegateway.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String fileShareARN;

        private String role;

        private String locationARN;

        private String bucketRegion;

        private String vpcEndpointDNSName;

        private List<CacheReportFilter> inclusionFilters = DefaultSdkAutoConstructList.getInstance();

        private List<CacheReportFilter> exclusionFilters = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartCacheReportRequest model) {
            super(model);
            fileShareARN(model.fileShareARN);
            role(model.role);
            locationARN(model.locationARN);
            bucketRegion(model.bucketRegion);
            vpcEndpointDNSName(model.vpcEndpointDNSName);
            inclusionFilters(model.inclusionFilters);
            exclusionFilters(model.exclusionFilters);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getFileShareARN() {
            return fileShareARN;
        }

        public final void setFileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
        }

        @Override
        public final Builder fileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final String getLocationARN() {
            return locationARN;
        }

        public final void setLocationARN(String locationARN) {
            this.locationARN = locationARN;
        }

        @Override
        public final Builder locationARN(String locationARN) {
            this.locationARN = locationARN;
            return this;
        }

        public final String getBucketRegion() {
            return bucketRegion;
        }

        public final void setBucketRegion(String bucketRegion) {
            this.bucketRegion = bucketRegion;
        }

        @Override
        public final Builder bucketRegion(String bucketRegion) {
            this.bucketRegion = bucketRegion;
            return this;
        }

        public final String getVpcEndpointDNSName() {
            return vpcEndpointDNSName;
        }

        public final void setVpcEndpointDNSName(String vpcEndpointDNSName) {
            this.vpcEndpointDNSName = vpcEndpointDNSName;
        }

        @Override
        public final Builder vpcEndpointDNSName(String vpcEndpointDNSName) {
            this.vpcEndpointDNSName = vpcEndpointDNSName;
            return this;
        }

        public final List<CacheReportFilter.Builder> getInclusionFilters() {
            List<CacheReportFilter.Builder> result = CacheReportFilterListCopier.copyToBuilder(this.inclusionFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInclusionFilters(Collection<CacheReportFilter.BuilderImpl> inclusionFilters) {
            this.inclusionFilters = CacheReportFilterListCopier.copyFromBuilder(inclusionFilters);
        }

        @Override
        public final Builder inclusionFilters(Collection<CacheReportFilter> inclusionFilters) {
            this.inclusionFilters = CacheReportFilterListCopier.copy(inclusionFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionFilters(CacheReportFilter... inclusionFilters) {
            inclusionFilters(Arrays.asList(inclusionFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionFilters(Consumer<CacheReportFilter.Builder>... inclusionFilters) {
            inclusionFilters(Stream.of(inclusionFilters).map(c -> CacheReportFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CacheReportFilter.Builder> getExclusionFilters() {
            List<CacheReportFilter.Builder> result = CacheReportFilterListCopier.copyToBuilder(this.exclusionFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExclusionFilters(Collection<CacheReportFilter.BuilderImpl> exclusionFilters) {
            this.exclusionFilters = CacheReportFilterListCopier.copyFromBuilder(exclusionFilters);
        }

        @Override
        public final Builder exclusionFilters(Collection<CacheReportFilter> exclusionFilters) {
            this.exclusionFilters = CacheReportFilterListCopier.copy(exclusionFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionFilters(CacheReportFilter... exclusionFilters) {
            exclusionFilters(Arrays.asList(exclusionFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionFilters(Consumer<CacheReportFilter.Builder>... exclusionFilters) {
            exclusionFilters(Stream.of(exclusionFilters).map(c -> CacheReportFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartCacheReportRequest build() {
            return new StartCacheReportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
