/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON object containing the Amazon Resource Name (ARN) of the updated storage volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSnapshotScheduleResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<UpdateSnapshotScheduleResponse.Builder, UpdateSnapshotScheduleResponse> {
    private static final SdkField<String> VOLUME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeARN").getter(getter(UpdateSnapshotScheduleResponse::volumeARN)).setter(setter(Builder::volumeARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String volumeARN;

    private UpdateSnapshotScheduleResponse(BuilderImpl builder) {
        super(builder);
        this.volumeARN = builder.volumeARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a> operation to return a list of gateway
     * volumes.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a> operation to return a list of
     *         gateway volumes.
     */
    public final String volumeARN() {
        return volumeARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(volumeARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSnapshotScheduleResponse)) {
            return false;
        }
        UpdateSnapshotScheduleResponse other = (UpdateSnapshotScheduleResponse) obj;
        return Objects.equals(volumeARN(), other.volumeARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSnapshotScheduleResponse").add("VolumeARN", volumeARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeARN":
            return Optional.ofNullable(clazz.cast(volumeARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VolumeARN", VOLUME_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSnapshotScheduleResponse, T> g) {
        return obj -> g.apply((UpdateSnapshotScheduleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateSnapshotScheduleResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a> operation to return a list of
         * gateway volumes.
         * </p>
         * 
         * @param volumeARN
         *        The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a> operation to return a list of
         *        gateway volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeARN(String volumeARN);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private String volumeARN;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSnapshotScheduleResponse model) {
            super(model);
            volumeARN(model.volumeARN);
        }

        public final String getVolumeARN() {
            return volumeARN;
        }

        public final void setVolumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
        }

        @Override
        public final Builder volumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
            return this;
        }

        @Override
        public UpdateSnapshotScheduleResponse build() {
            return new UpdateSnapshotScheduleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
