/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A code and name pair that represents the severity level of a support case. The available values depend on the support
 * plan for the account. For more information, see <a
 * href="https://docs.aws.amazon.com/awssupport/latest/user/case-management.html#choosing-severity">Choosing a
 * severity</a> in the <i>Amazon Web Services Support User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SeverityLevel implements SdkPojo, Serializable, ToCopyableBuilder<SeverityLevel.Builder, SeverityLevel> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("code")
            .getter(getter(SeverityLevel::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(SeverityLevel::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String code;

    private final String name;

    private SeverityLevel(BuilderImpl builder) {
        this.code = builder.code;
        this.name = builder.name;
    }

    /**
     * <p>
     * The code for case severity level.
     * </p>
     * <p>
     * Valid values: <code>low</code> | <code>normal</code> | <code>high</code> | <code>urgent</code> |
     * <code>critical</code>
     * </p>
     * 
     * @return The code for case severity level.</p>
     *         <p>
     *         Valid values: <code>low</code> | <code>normal</code> | <code>high</code> | <code>urgent</code> |
     *         <code>critical</code>
     */
    public final String code() {
        return code;
    }

    /**
     * <p>
     * The name of the severity level that corresponds to the severity level code.
     * </p>
     * <note>
     * <p>
     * The values returned by the API are different from the values that appear in the Amazon Web Services Support
     * Center. For example, the API uses the code <code>low</code>, but the name appears as General guidance in Support
     * Center.
     * </p>
     * <p>
     * The following are the API code names and how they appear in the console:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>low</code> - General guidance
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>normal</code> - System impaired
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>high</code> - Production system impaired
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>urgent</code> - Production system down
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>critical</code> - Business-critical system down
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/awssupport/latest/user/case-management.html#choosing-severity">Choosing a
     * severity</a> in the <i>Amazon Web Services Support User Guide</i>.
     * </p>
     * 
     * @return The name of the severity level that corresponds to the severity level code.</p> <note>
     *         <p>
     *         The values returned by the API are different from the values that appear in the Amazon Web Services
     *         Support Center. For example, the API uses the code <code>low</code>, but the name appears as General
     *         guidance in Support Center.
     *         </p>
     *         <p>
     *         The following are the API code names and how they appear in the console:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>low</code> - General guidance
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>normal</code> - System impaired
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>high</code> - Production system impaired
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>urgent</code> - Production system down
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>critical</code> - Business-critical system down
     *         </p>
     *         </li>
     *         </ul>
     *         </note>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/awssupport/latest/user/case-management.html#choosing-severity">Choosing
     *         a severity</a> in the <i>Amazon Web Services Support User Guide</i>.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SeverityLevel)) {
            return false;
        }
        SeverityLevel other = (SeverityLevel) obj;
        return Objects.equals(code(), other.code()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SeverityLevel").add("Code", code()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "code":
            return Optional.ofNullable(clazz.cast(code()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("code", CODE_FIELD);
        map.put("name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SeverityLevel, T> g) {
        return obj -> g.apply((SeverityLevel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SeverityLevel> {
        /**
         * <p>
         * The code for case severity level.
         * </p>
         * <p>
         * Valid values: <code>low</code> | <code>normal</code> | <code>high</code> | <code>urgent</code> |
         * <code>critical</code>
         * </p>
         * 
         * @param code
         *        The code for case severity level.</p>
         *        <p>
         *        Valid values: <code>low</code> | <code>normal</code> | <code>high</code> | <code>urgent</code> |
         *        <code>critical</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * The name of the severity level that corresponds to the severity level code.
         * </p>
         * <note>
         * <p>
         * The values returned by the API are different from the values that appear in the Amazon Web Services Support
         * Center. For example, the API uses the code <code>low</code>, but the name appears as General guidance in
         * Support Center.
         * </p>
         * <p>
         * The following are the API code names and how they appear in the console:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>low</code> - General guidance
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>normal</code> - System impaired
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>high</code> - Production system impaired
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>urgent</code> - Production system down
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>critical</code> - Business-critical system down
         * </p>
         * </li>
         * </ul>
         * </note>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/awssupport/latest/user/case-management.html#choosing-severity">Choosing a
         * severity</a> in the <i>Amazon Web Services Support User Guide</i>.
         * </p>
         * 
         * @param name
         *        The name of the severity level that corresponds to the severity level code.</p> <note>
         *        <p>
         *        The values returned by the API are different from the values that appear in the Amazon Web Services
         *        Support Center. For example, the API uses the code <code>low</code>, but the name appears as General
         *        guidance in Support Center.
         *        </p>
         *        <p>
         *        The following are the API code names and how they appear in the console:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>low</code> - General guidance
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>normal</code> - System impaired
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>high</code> - Production system impaired
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>urgent</code> - Production system down
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>critical</code> - Business-critical system down
         *        </p>
         *        </li>
         *        </ul>
         *        </note>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/awssupport/latest/user/case-management.html#choosing-severity"
         *        >Choosing a severity</a> in the <i>Amazon Web Services Support User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(SeverityLevel model) {
            code(model.code);
            name(model.name);
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public SeverityLevel build() {
            return new SeverityLevel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
