/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON-formatted object that contains the CommunicationTypeOptions for creating a case for a certain communication
 * channel. It is contained in the response from a <a>DescribeCreateCaseOptions</a> request.
 * <b>CommunicationTypeOptions</b> contains the following fields:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <b>datesWithoutSupport</b> - A JSON-formatted list containing date and time ranges for periods without support in UTC
 * time. Date and time format is RFC 3339 : 'yyyy-MM-dd'T'HH:mm:ss.SSSZZ'.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>supportedHours</b> - A JSON-formatted list containing time ranges when support are available. Time format is RFC
 * 3339 : 'HH:mm:ss.SSS'.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>type</b> - A string value indicating the communication type that the aforementioned rules apply to. At the moment
 * the type value can assume one of 3 values at the moment <code>chat</code>, <code>web</code> and <code>call</code>.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CommunicationTypeOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<CommunicationTypeOptions.Builder, CommunicationTypeOptions> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CommunicationTypeOptions::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<List<SupportedHour>> SUPPORTED_HOURS_FIELD = SdkField
            .<List<SupportedHour>> builder(MarshallingType.LIST)
            .memberName("supportedHours")
            .getter(getter(CommunicationTypeOptions::supportedHours))
            .setter(setter(Builder::supportedHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedHours").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SupportedHour> builder(MarshallingType.SDK_POJO)
                                            .constructor(SupportedHour::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DateInterval>> DATES_WITHOUT_SUPPORT_FIELD = SdkField
            .<List<DateInterval>> builder(MarshallingType.LIST)
            .memberName("datesWithoutSupport")
            .getter(getter(CommunicationTypeOptions::datesWithoutSupport))
            .setter(setter(Builder::datesWithoutSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datesWithoutSupport").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DateInterval> builder(MarshallingType.SDK_POJO)
                                            .constructor(DateInterval::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            SUPPORTED_HOURS_FIELD, DATES_WITHOUT_SUPPORT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final List<SupportedHour> supportedHours;

    private final List<DateInterval> datesWithoutSupport;

    private CommunicationTypeOptions(BuilderImpl builder) {
        this.type = builder.type;
        this.supportedHours = builder.supportedHours;
        this.datesWithoutSupport = builder.datesWithoutSupport;
    }

    /**
     * <p>
     * A string value indicating the communication type. At the moment the type value can assume one of 3 values at the
     * moment chat, web and call.
     * </p>
     * 
     * @return A string value indicating the communication type. At the moment the type value can assume one of 3 values
     *         at the moment chat, web and call.
     */
    public final String type() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedHours property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSupportedHours() {
        return supportedHours != null && !(supportedHours instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A JSON-formatted list containing time ranges when support is available.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedHours} method.
     * </p>
     * 
     * @return A JSON-formatted list containing time ranges when support is available.
     */
    public final List<SupportedHour> supportedHours() {
        return supportedHours;
    }

    /**
     * For responses, this returns true if the service returned a value for the DatesWithoutSupport property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDatesWithoutSupport() {
        return datesWithoutSupport != null && !(datesWithoutSupport instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A JSON-formatted list containing date and time ranges for periods without support
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDatesWithoutSupport} method.
     * </p>
     * 
     * @return A JSON-formatted list containing date and time ranges for periods without support
     */
    public final List<DateInterval> datesWithoutSupport() {
        return datesWithoutSupport;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedHours() ? supportedHours() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDatesWithoutSupport() ? datesWithoutSupport() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommunicationTypeOptions)) {
            return false;
        }
        CommunicationTypeOptions other = (CommunicationTypeOptions) obj;
        return Objects.equals(type(), other.type()) && hasSupportedHours() == other.hasSupportedHours()
                && Objects.equals(supportedHours(), other.supportedHours())
                && hasDatesWithoutSupport() == other.hasDatesWithoutSupport()
                && Objects.equals(datesWithoutSupport(), other.datesWithoutSupport());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CommunicationTypeOptions").add("Type", type())
                .add("SupportedHours", hasSupportedHours() ? supportedHours() : null)
                .add("DatesWithoutSupport", hasDatesWithoutSupport() ? datesWithoutSupport() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "supportedHours":
            return Optional.ofNullable(clazz.cast(supportedHours()));
        case "datesWithoutSupport":
            return Optional.ofNullable(clazz.cast(datesWithoutSupport()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("supportedHours", SUPPORTED_HOURS_FIELD);
        map.put("datesWithoutSupport", DATES_WITHOUT_SUPPORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CommunicationTypeOptions, T> g) {
        return obj -> g.apply((CommunicationTypeOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CommunicationTypeOptions> {
        /**
         * <p>
         * A string value indicating the communication type. At the moment the type value can assume one of 3 values at
         * the moment chat, web and call.
         * </p>
         * 
         * @param type
         *        A string value indicating the communication type. At the moment the type value can assume one of 3
         *        values at the moment chat, web and call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * A JSON-formatted list containing time ranges when support is available.
         * </p>
         * 
         * @param supportedHours
         *        A JSON-formatted list containing time ranges when support is available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedHours(Collection<SupportedHour> supportedHours);

        /**
         * <p>
         * A JSON-formatted list containing time ranges when support is available.
         * </p>
         * 
         * @param supportedHours
         *        A JSON-formatted list containing time ranges when support is available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedHours(SupportedHour... supportedHours);

        /**
         * <p>
         * A JSON-formatted list containing time ranges when support is available.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.support.model.SupportedHour.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.support.model.SupportedHour#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.support.model.SupportedHour.Builder#build()} is called immediately and
         * its result is passed to {@link #supportedHours(List<SupportedHour>)}.
         * 
         * @param supportedHours
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.support.model.SupportedHour.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #supportedHours(java.util.Collection<SupportedHour>)
         */
        Builder supportedHours(Consumer<SupportedHour.Builder>... supportedHours);

        /**
         * <p>
         * A JSON-formatted list containing date and time ranges for periods without support
         * </p>
         * 
         * @param datesWithoutSupport
         *        A JSON-formatted list containing date and time ranges for periods without support
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datesWithoutSupport(Collection<DateInterval> datesWithoutSupport);

        /**
         * <p>
         * A JSON-formatted list containing date and time ranges for periods without support
         * </p>
         * 
         * @param datesWithoutSupport
         *        A JSON-formatted list containing date and time ranges for periods without support
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datesWithoutSupport(DateInterval... datesWithoutSupport);

        /**
         * <p>
         * A JSON-formatted list containing date and time ranges for periods without support
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.support.model.DateInterval.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.support.model.DateInterval#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.support.model.DateInterval.Builder#build()} is called immediately and
         * its result is passed to {@link #datesWithoutSupport(List<DateInterval>)}.
         * 
         * @param datesWithoutSupport
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.support.model.DateInterval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datesWithoutSupport(java.util.Collection<DateInterval>)
         */
        Builder datesWithoutSupport(Consumer<DateInterval.Builder>... datesWithoutSupport);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private List<SupportedHour> supportedHours = DefaultSdkAutoConstructList.getInstance();

        private List<DateInterval> datesWithoutSupport = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CommunicationTypeOptions model) {
            type(model.type);
            supportedHours(model.supportedHours);
            datesWithoutSupport(model.datesWithoutSupport);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final List<SupportedHour.Builder> getSupportedHours() {
            List<SupportedHour.Builder> result = SupportedHoursListCopier.copyToBuilder(this.supportedHours);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportedHours(Collection<SupportedHour.BuilderImpl> supportedHours) {
            this.supportedHours = SupportedHoursListCopier.copyFromBuilder(supportedHours);
        }

        @Override
        public final Builder supportedHours(Collection<SupportedHour> supportedHours) {
            this.supportedHours = SupportedHoursListCopier.copy(supportedHours);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedHours(SupportedHour... supportedHours) {
            supportedHours(Arrays.asList(supportedHours));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedHours(Consumer<SupportedHour.Builder>... supportedHours) {
            supportedHours(Stream.of(supportedHours).map(c -> SupportedHour.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<DateInterval.Builder> getDatesWithoutSupport() {
            List<DateInterval.Builder> result = DatesWithoutSupportListCopier.copyToBuilder(this.datesWithoutSupport);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatesWithoutSupport(Collection<DateInterval.BuilderImpl> datesWithoutSupport) {
            this.datesWithoutSupport = DatesWithoutSupportListCopier.copyFromBuilder(datesWithoutSupport);
        }

        @Override
        public final Builder datesWithoutSupport(Collection<DateInterval> datesWithoutSupport) {
            this.datesWithoutSupport = DatesWithoutSupportListCopier.copy(datesWithoutSupport);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datesWithoutSupport(DateInterval... datesWithoutSupport) {
            datesWithoutSupport(Arrays.asList(datesWithoutSupport));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datesWithoutSupport(Consumer<DateInterval.Builder>... datesWithoutSupport) {
            datesWithoutSupport(Stream.of(datesWithoutSupport).map(c -> DateInterval.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CommunicationTypeOptions build() {
            return new CommunicationTypeOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
