/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure representing a screenshot that is used as a baseline during visual monitoring comparisons made by the
 * canary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BaseScreenshot implements SdkPojo, Serializable, ToCopyableBuilder<BaseScreenshot.Builder, BaseScreenshot> {
    private static final SdkField<String> SCREENSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScreenshotName").getter(getter(BaseScreenshot::screenshotName)).setter(setter(Builder::screenshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScreenshotName").build()).build();

    private static final SdkField<List<String>> IGNORE_COORDINATES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IgnoreCoordinates")
            .getter(getter(BaseScreenshot::ignoreCoordinates))
            .setter(setter(Builder::ignoreCoordinates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IgnoreCoordinates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCREENSHOT_NAME_FIELD,
            IGNORE_COORDINATES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String screenshotName;

    private final List<String> ignoreCoordinates;

    private BaseScreenshot(BuilderImpl builder) {
        this.screenshotName = builder.screenshotName;
        this.ignoreCoordinates = builder.ignoreCoordinates;
    }

    /**
     * <p>
     * The name of the screenshot. This is generated the first time the canary is run after the
     * <code>UpdateCanary</code> operation that specified for this canary to perform visual monitoring.
     * </p>
     * 
     * @return The name of the screenshot. This is generated the first time the canary is run after the
     *         <code>UpdateCanary</code> operation that specified for this canary to perform visual monitoring.
     */
    public final String screenshotName() {
        return screenshotName;
    }

    /**
     * For responses, this returns true if the service returned a value for the IgnoreCoordinates property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIgnoreCoordinates() {
        return ignoreCoordinates != null && !(ignoreCoordinates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Coordinates that define the part of a screen to ignore during screenshot comparisons. To obtain the coordinates
     * to use here, use the CloudWatch console to draw the boundaries on the screen. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/synthetics_canaries_deletion.html"> Editing
     * or deleting a canary</a>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIgnoreCoordinates} method.
     * </p>
     * 
     * @return Coordinates that define the part of a screen to ignore during screenshot comparisons. To obtain the
     *         coordinates to use here, use the CloudWatch console to draw the boundaries on the screen. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/synthetics_canaries_deletion.html">
     *         Editing or deleting a canary</a>
     */
    public final List<String> ignoreCoordinates() {
        return ignoreCoordinates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(screenshotName());
        hashCode = 31 * hashCode + Objects.hashCode(hasIgnoreCoordinates() ? ignoreCoordinates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseScreenshot)) {
            return false;
        }
        BaseScreenshot other = (BaseScreenshot) obj;
        return Objects.equals(screenshotName(), other.screenshotName()) && hasIgnoreCoordinates() == other.hasIgnoreCoordinates()
                && Objects.equals(ignoreCoordinates(), other.ignoreCoordinates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BaseScreenshot").add("ScreenshotName", screenshotName())
                .add("IgnoreCoordinates", hasIgnoreCoordinates() ? ignoreCoordinates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScreenshotName":
            return Optional.ofNullable(clazz.cast(screenshotName()));
        case "IgnoreCoordinates":
            return Optional.ofNullable(clazz.cast(ignoreCoordinates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ScreenshotName", SCREENSHOT_NAME_FIELD);
        map.put("IgnoreCoordinates", IGNORE_COORDINATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BaseScreenshot, T> g) {
        return obj -> g.apply((BaseScreenshot) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BaseScreenshot> {
        /**
         * <p>
         * The name of the screenshot. This is generated the first time the canary is run after the
         * <code>UpdateCanary</code> operation that specified for this canary to perform visual monitoring.
         * </p>
         * 
         * @param screenshotName
         *        The name of the screenshot. This is generated the first time the canary is run after the
         *        <code>UpdateCanary</code> operation that specified for this canary to perform visual monitoring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder screenshotName(String screenshotName);

        /**
         * <p>
         * Coordinates that define the part of a screen to ignore during screenshot comparisons. To obtain the
         * coordinates to use here, use the CloudWatch console to draw the boundaries on the screen. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/synthetics_canaries_deletion.html">
         * Editing or deleting a canary</a>
         * </p>
         * 
         * @param ignoreCoordinates
         *        Coordinates that define the part of a screen to ignore during screenshot comparisons. To obtain the
         *        coordinates to use here, use the CloudWatch console to draw the boundaries on the screen. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/synthetics_canaries_deletion.html">
         *        Editing or deleting a canary</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ignoreCoordinates(Collection<String> ignoreCoordinates);

        /**
         * <p>
         * Coordinates that define the part of a screen to ignore during screenshot comparisons. To obtain the
         * coordinates to use here, use the CloudWatch console to draw the boundaries on the screen. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/synthetics_canaries_deletion.html">
         * Editing or deleting a canary</a>
         * </p>
         * 
         * @param ignoreCoordinates
         *        Coordinates that define the part of a screen to ignore during screenshot comparisons. To obtain the
         *        coordinates to use here, use the CloudWatch console to draw the boundaries on the screen. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/synthetics_canaries_deletion.html">
         *        Editing or deleting a canary</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ignoreCoordinates(String... ignoreCoordinates);
    }

    static final class BuilderImpl implements Builder {
        private String screenshotName;

        private List<String> ignoreCoordinates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BaseScreenshot model) {
            screenshotName(model.screenshotName);
            ignoreCoordinates(model.ignoreCoordinates);
        }

        public final String getScreenshotName() {
            return screenshotName;
        }

        public final void setScreenshotName(String screenshotName) {
            this.screenshotName = screenshotName;
        }

        @Override
        public final Builder screenshotName(String screenshotName) {
            this.screenshotName = screenshotName;
            return this;
        }

        public final Collection<String> getIgnoreCoordinates() {
            if (ignoreCoordinates instanceof SdkAutoConstructList) {
                return null;
            }
            return ignoreCoordinates;
        }

        public final void setIgnoreCoordinates(Collection<String> ignoreCoordinates) {
            this.ignoreCoordinates = BaseScreenshotIgnoreCoordinatesCopier.copy(ignoreCoordinates);
        }

        @Override
        public final Builder ignoreCoordinates(Collection<String> ignoreCoordinates) {
            this.ignoreCoordinates = BaseScreenshotIgnoreCoordinatesCopier.copy(ignoreCoordinates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ignoreCoordinates(String... ignoreCoordinates) {
            ignoreCoordinates(Arrays.asList(ignoreCoordinates));
            return this;
        }

        @Override
        public BaseScreenshot build() {
            return new BaseScreenshot(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
