/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCanariesLastRunResponse extends SyntheticsResponse implements
        ToCopyableBuilder<DescribeCanariesLastRunResponse.Builder, DescribeCanariesLastRunResponse> {
    private static final SdkField<List<CanaryLastRun>> CANARIES_LAST_RUN_FIELD = SdkField
            .<List<CanaryLastRun>> builder(MarshallingType.LIST)
            .memberName("CanariesLastRun")
            .getter(getter(DescribeCanariesLastRunResponse::canariesLastRun))
            .setter(setter(Builder::canariesLastRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanariesLastRun").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CanaryLastRun> builder(MarshallingType.SDK_POJO)
                                            .constructor(CanaryLastRun::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeCanariesLastRunResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANARIES_LAST_RUN_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CanaryLastRun> canariesLastRun;

    private final String nextToken;

    private DescribeCanariesLastRunResponse(BuilderImpl builder) {
        super(builder);
        this.canariesLastRun = builder.canariesLastRun;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CanariesLastRun property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCanariesLastRun() {
        return canariesLastRun != null && !(canariesLastRun instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that contains the information from the most recent run of each canary.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCanariesLastRun} method.
     * </p>
     * 
     * @return An array that contains the information from the most recent run of each canary.
     */
    public final List<CanaryLastRun> canariesLastRun() {
        return canariesLastRun;
    }

    /**
     * <p>
     * A token that indicates that there is more data available. You can use this token in a subsequent
     * <code>DescribeCanariesLastRun</code> operation to retrieve the next set of results.
     * </p>
     * 
     * @return A token that indicates that there is more data available. You can use this token in a subsequent
     *         <code>DescribeCanariesLastRun</code> operation to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCanariesLastRun() ? canariesLastRun() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCanariesLastRunResponse)) {
            return false;
        }
        DescribeCanariesLastRunResponse other = (DescribeCanariesLastRunResponse) obj;
        return hasCanariesLastRun() == other.hasCanariesLastRun() && Objects.equals(canariesLastRun(), other.canariesLastRun())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCanariesLastRunResponse")
                .add("CanariesLastRun", hasCanariesLastRun() ? canariesLastRun() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CanariesLastRun":
            return Optional.ofNullable(clazz.cast(canariesLastRun()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CanariesLastRun", CANARIES_LAST_RUN_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCanariesLastRunResponse, T> g) {
        return obj -> g.apply((DescribeCanariesLastRunResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SyntheticsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeCanariesLastRunResponse> {
        /**
         * <p>
         * An array that contains the information from the most recent run of each canary.
         * </p>
         * 
         * @param canariesLastRun
         *        An array that contains the information from the most recent run of each canary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canariesLastRun(Collection<CanaryLastRun> canariesLastRun);

        /**
         * <p>
         * An array that contains the information from the most recent run of each canary.
         * </p>
         * 
         * @param canariesLastRun
         *        An array that contains the information from the most recent run of each canary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canariesLastRun(CanaryLastRun... canariesLastRun);

        /**
         * <p>
         * An array that contains the information from the most recent run of each canary.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.synthetics.model.CanaryLastRun.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.synthetics.model.CanaryLastRun#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.synthetics.model.CanaryLastRun.Builder#build()} is called immediately
         * and its result is passed to {@link #canariesLastRun(List<CanaryLastRun>)}.
         * 
         * @param canariesLastRun
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.synthetics.model.CanaryLastRun.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #canariesLastRun(java.util.Collection<CanaryLastRun>)
         */
        Builder canariesLastRun(Consumer<CanaryLastRun.Builder>... canariesLastRun);

        /**
         * <p>
         * A token that indicates that there is more data available. You can use this token in a subsequent
         * <code>DescribeCanariesLastRun</code> operation to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates that there is more data available. You can use this token in a subsequent
         *        <code>DescribeCanariesLastRun</code> operation to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SyntheticsResponse.BuilderImpl implements Builder {
        private List<CanaryLastRun> canariesLastRun = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCanariesLastRunResponse model) {
            super(model);
            canariesLastRun(model.canariesLastRun);
            nextToken(model.nextToken);
        }

        public final List<CanaryLastRun.Builder> getCanariesLastRun() {
            List<CanaryLastRun.Builder> result = CanariesLastRunCopier.copyToBuilder(this.canariesLastRun);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCanariesLastRun(Collection<CanaryLastRun.BuilderImpl> canariesLastRun) {
            this.canariesLastRun = CanariesLastRunCopier.copyFromBuilder(canariesLastRun);
        }

        @Override
        public final Builder canariesLastRun(Collection<CanaryLastRun> canariesLastRun) {
            this.canariesLastRun = CanariesLastRunCopier.copy(canariesLastRun);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder canariesLastRun(CanaryLastRun... canariesLastRun) {
            canariesLastRun(Arrays.asList(canariesLastRun));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder canariesLastRun(Consumer<CanaryLastRun.Builder>... canariesLastRun) {
            canariesLastRun(Stream.of(canariesLastRun).map(c -> CanaryLastRun.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeCanariesLastRunResponse build() {
            return new DescribeCanariesLastRunResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
