/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum BlockType {
    KEY_VALUE_SET("KEY_VALUE_SET"),

    PAGE("PAGE"),

    LINE("LINE"),

    WORD("WORD"),

    TABLE("TABLE"),

    CELL("CELL"),

    SELECTION_ELEMENT("SELECTION_ELEMENT"),

    MERGED_CELL("MERGED_CELL"),

    TITLE("TITLE"),

    QUERY("QUERY"),

    QUERY_RESULT("QUERY_RESULT"),

    SIGNATURE("SIGNATURE"),

    TABLE_TITLE("TABLE_TITLE"),

    TABLE_FOOTER("TABLE_FOOTER"),

    LAYOUT_TEXT("LAYOUT_TEXT"),

    LAYOUT_TITLE("LAYOUT_TITLE"),

    LAYOUT_HEADER("LAYOUT_HEADER"),

    LAYOUT_FOOTER("LAYOUT_FOOTER"),

    LAYOUT_SECTION_HEADER("LAYOUT_SECTION_HEADER"),

    LAYOUT_PAGE_NUMBER("LAYOUT_PAGE_NUMBER"),

    LAYOUT_LIST("LAYOUT_LIST"),

    LAYOUT_FIGURE("LAYOUT_FIGURE"),

    LAYOUT_TABLE("LAYOUT_TABLE"),

    LAYOUT_KEY_VALUE("LAYOUT_KEY_VALUE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BlockType> VALUE_MAP = EnumUtils.uniqueIndex(BlockType.class, BlockType::toString);

    private final String value;

    private BlockType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return BlockType corresponding to the value
     */
    public static BlockType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link BlockType}s
     */
    public static Set<BlockType> knownValues() {
        Set<BlockType> knownValues = EnumSet.allOf(BlockType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
