/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information regarding DocumentGroups and UndetectedDocumentTypes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LendingSummary implements SdkPojo, Serializable, ToCopyableBuilder<LendingSummary.Builder, LendingSummary> {
    private static final SdkField<List<DocumentGroup>> DOCUMENT_GROUPS_FIELD = SdkField
            .<List<DocumentGroup>> builder(MarshallingType.LIST)
            .memberName("DocumentGroups")
            .getter(getter(LendingSummary::documentGroups))
            .setter(setter(Builder::documentGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> UNDETECTED_DOCUMENT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UndetectedDocumentTypes")
            .getter(getter(LendingSummary::undetectedDocumentTypes))
            .setter(setter(Builder::undetectedDocumentTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UndetectedDocumentTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_GROUPS_FIELD,
            UNDETECTED_DOCUMENT_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<DocumentGroup> documentGroups;

    private final List<String> undetectedDocumentTypes;

    private LendingSummary(BuilderImpl builder) {
        this.documentGroups = builder.documentGroups;
        this.undetectedDocumentTypes = builder.undetectedDocumentTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the DocumentGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDocumentGroups() {
        return documentGroups != null && !(documentGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains an array of all DocumentGroup objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDocumentGroups} method.
     * </p>
     * 
     * @return Contains an array of all DocumentGroup objects.
     */
    public final List<DocumentGroup> documentGroups() {
        return documentGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the UndetectedDocumentTypes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasUndetectedDocumentTypes() {
        return undetectedDocumentTypes != null && !(undetectedDocumentTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * UndetectedDocumentTypes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUndetectedDocumentTypes} method.
     * </p>
     * 
     * @return UndetectedDocumentTypes.
     */
    public final List<String> undetectedDocumentTypes() {
        return undetectedDocumentTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDocumentGroups() ? documentGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUndetectedDocumentTypes() ? undetectedDocumentTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LendingSummary)) {
            return false;
        }
        LendingSummary other = (LendingSummary) obj;
        return hasDocumentGroups() == other.hasDocumentGroups() && Objects.equals(documentGroups(), other.documentGroups())
                && hasUndetectedDocumentTypes() == other.hasUndetectedDocumentTypes()
                && Objects.equals(undetectedDocumentTypes(), other.undetectedDocumentTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LendingSummary").add("DocumentGroups", hasDocumentGroups() ? documentGroups() : null)
                .add("UndetectedDocumentTypes", hasUndetectedDocumentTypes() ? undetectedDocumentTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentGroups":
            return Optional.ofNullable(clazz.cast(documentGroups()));
        case "UndetectedDocumentTypes":
            return Optional.ofNullable(clazz.cast(undetectedDocumentTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DocumentGroups", DOCUMENT_GROUPS_FIELD);
        map.put("UndetectedDocumentTypes", UNDETECTED_DOCUMENT_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LendingSummary, T> g) {
        return obj -> g.apply((LendingSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LendingSummary> {
        /**
         * <p>
         * Contains an array of all DocumentGroup objects.
         * </p>
         * 
         * @param documentGroups
         *        Contains an array of all DocumentGroup objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentGroups(Collection<DocumentGroup> documentGroups);

        /**
         * <p>
         * Contains an array of all DocumentGroup objects.
         * </p>
         * 
         * @param documentGroups
         *        Contains an array of all DocumentGroup objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentGroups(DocumentGroup... documentGroups);

        /**
         * <p>
         * Contains an array of all DocumentGroup objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.textract.model.DocumentGroup.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.textract.model.DocumentGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.textract.model.DocumentGroup.Builder#build()} is called immediately
         * and its result is passed to {@link #documentGroups(List<DocumentGroup>)}.
         * 
         * @param documentGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.textract.model.DocumentGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentGroups(java.util.Collection<DocumentGroup>)
         */
        Builder documentGroups(Consumer<DocumentGroup.Builder>... documentGroups);

        /**
         * <p>
         * UndetectedDocumentTypes.
         * </p>
         * 
         * @param undetectedDocumentTypes
         *        UndetectedDocumentTypes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder undetectedDocumentTypes(Collection<String> undetectedDocumentTypes);

        /**
         * <p>
         * UndetectedDocumentTypes.
         * </p>
         * 
         * @param undetectedDocumentTypes
         *        UndetectedDocumentTypes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder undetectedDocumentTypes(String... undetectedDocumentTypes);
    }

    static final class BuilderImpl implements Builder {
        private List<DocumentGroup> documentGroups = DefaultSdkAutoConstructList.getInstance();

        private List<String> undetectedDocumentTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LendingSummary model) {
            documentGroups(model.documentGroups);
            undetectedDocumentTypes(model.undetectedDocumentTypes);
        }

        public final List<DocumentGroup.Builder> getDocumentGroups() {
            List<DocumentGroup.Builder> result = DocumentGroupListCopier.copyToBuilder(this.documentGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentGroups(Collection<DocumentGroup.BuilderImpl> documentGroups) {
            this.documentGroups = DocumentGroupListCopier.copyFromBuilder(documentGroups);
        }

        @Override
        public final Builder documentGroups(Collection<DocumentGroup> documentGroups) {
            this.documentGroups = DocumentGroupListCopier.copy(documentGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentGroups(DocumentGroup... documentGroups) {
            documentGroups(Arrays.asList(documentGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentGroups(Consumer<DocumentGroup.Builder>... documentGroups) {
            documentGroups(Stream.of(documentGroups).map(c -> DocumentGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getUndetectedDocumentTypes() {
            if (undetectedDocumentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return undetectedDocumentTypes;
        }

        public final void setUndetectedDocumentTypes(Collection<String> undetectedDocumentTypes) {
            this.undetectedDocumentTypes = UndetectedDocumentTypeListCopier.copy(undetectedDocumentTypes);
        }

        @Override
        public final Builder undetectedDocumentTypes(Collection<String> undetectedDocumentTypes) {
            this.undetectedDocumentTypes = UndetectedDocumentTypeListCopier.copy(undetectedDocumentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder undetectedDocumentTypes(String... undetectedDocumentTypes) {
            undetectedDocumentTypes(Arrays.asList(undetectedDocumentTypes));
            return this;
        }

        @Override
        public LendingSummary build() {
            return new LendingSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
