/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueriesConfig implements SdkPojo, Serializable, ToCopyableBuilder<QueriesConfig.Builder, QueriesConfig> {
    private static final SdkField<List<Query>> QUERIES_FIELD = SdkField
            .<List<Query>> builder(MarshallingType.LIST)
            .memberName("Queries")
            .getter(getter(QueriesConfig::queries))
            .setter(setter(Builder::queries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Queries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Query> builder(MarshallingType.SDK_POJO)
                                            .constructor(Query::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Query> queries;

    private QueriesConfig(BuilderImpl builder) {
        this.queries = builder.queries;
    }

    /**
     * For responses, this returns true if the service returned a value for the Queries property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasQueries() {
        return queries != null && !(queries instanceof SdkAutoConstructList);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueries} method.
     * </p>
     * 
     * @return
     */
    public final List<Query> queries() {
        return queries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasQueries() ? queries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueriesConfig)) {
            return false;
        }
        QueriesConfig other = (QueriesConfig) obj;
        return hasQueries() == other.hasQueries() && Objects.equals(queries(), other.queries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueriesConfig").add("Queries", hasQueries() ? queries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Queries":
            return Optional.ofNullable(clazz.cast(queries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Queries", QUERIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueriesConfig, T> g) {
        return obj -> g.apply((QueriesConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueriesConfig> {
        /**
         * <p/>
         * 
         * @param queries
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queries(Collection<Query> queries);

        /**
         * <p/>
         * 
         * @param queries
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queries(Query... queries);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.textract.model.Query.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.textract.model.Query#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.textract.model.Query.Builder#build()} is called immediately and its
         * result is passed to {@link #queries(List<Query>)}.
         * 
         * @param queries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.textract.model.Query.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queries(java.util.Collection<Query>)
         */
        Builder queries(Consumer<Query.Builder>... queries);
    }

    static final class BuilderImpl implements Builder {
        private List<Query> queries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QueriesConfig model) {
            queries(model.queries);
        }

        public final List<Query.Builder> getQueries() {
            List<Query.Builder> result = QueriesCopier.copyToBuilder(this.queries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueries(Collection<Query.BuilderImpl> queries) {
            this.queries = QueriesCopier.copyFromBuilder(queries);
        }

        @Override
        public final Builder queries(Collection<Query> queries) {
            this.queries = QueriesCopier.copy(queries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queries(Query... queries) {
            queries(Arrays.asList(queries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queries(Consumer<Query.Builder>... queries) {
            queries(Stream.of(queries).map(c -> Query.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public QueriesConfig build() {
            return new QueriesConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
