/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartLendingAnalysisRequest extends TextractRequest implements
        ToCopyableBuilder<StartLendingAnalysisRequest.Builder, StartLendingAnalysisRequest> {
    private static final SdkField<DocumentLocation> DOCUMENT_LOCATION_FIELD = SdkField
            .<DocumentLocation> builder(MarshallingType.SDK_POJO).memberName("DocumentLocation")
            .getter(getter(StartLendingAnalysisRequest::documentLocation)).setter(setter(Builder::documentLocation))
            .constructor(DocumentLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentLocation").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken").getter(getter(StartLendingAnalysisRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build())
            .build();

    private static final SdkField<String> JOB_TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobTag")
            .getter(getter(StartLendingAnalysisRequest::jobTag)).setter(setter(Builder::jobTag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobTag").build()).build();

    private static final SdkField<NotificationChannel> NOTIFICATION_CHANNEL_FIELD = SdkField
            .<NotificationChannel> builder(MarshallingType.SDK_POJO).memberName("NotificationChannel")
            .getter(getter(StartLendingAnalysisRequest::notificationChannel)).setter(setter(Builder::notificationChannel))
            .constructor(NotificationChannel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationChannel").build())
            .build();

    private static final SdkField<OutputConfig> OUTPUT_CONFIG_FIELD = SdkField.<OutputConfig> builder(MarshallingType.SDK_POJO)
            .memberName("OutputConfig").getter(getter(StartLendingAnalysisRequest::outputConfig))
            .setter(setter(Builder::outputConfig)).constructor(OutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KMSKeyId").getter(getter(StartLendingAnalysisRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_LOCATION_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, JOB_TAG_FIELD, NOTIFICATION_CHANNEL_FIELD, OUTPUT_CONFIG_FIELD, KMS_KEY_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DocumentLocation documentLocation;

    private final String clientRequestToken;

    private final String jobTag;

    private final NotificationChannel notificationChannel;

    private final OutputConfig outputConfig;

    private final String kmsKeyId;

    private StartLendingAnalysisRequest(BuilderImpl builder) {
        super(builder);
        this.documentLocation = builder.documentLocation;
        this.clientRequestToken = builder.clientRequestToken;
        this.jobTag = builder.jobTag;
        this.notificationChannel = builder.notificationChannel;
        this.outputConfig = builder.outputConfig;
        this.kmsKeyId = builder.kmsKeyId;
    }

    /**
     * Returns the value of the DocumentLocation property for this object.
     * 
     * @return The value of the DocumentLocation property for this object.
     */
    public final DocumentLocation documentLocation() {
        return documentLocation;
    }

    /**
     * <p>
     * The idempotent token that you use to identify the start request. If you use the same token with multiple
     * <code>StartLendingAnalysis</code> requests, the same <code>JobId</code> is returned. Use
     * <code>ClientRequestToken</code> to prevent the same job from being accidentally started more than once. For more
     * information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/api-sync.html">Calling Amazon Textract
     * Asynchronous Operations</a>.
     * </p>
     * 
     * @return The idempotent token that you use to identify the start request. If you use the same token with multiple
     *         <code>StartLendingAnalysis</code> requests, the same <code>JobId</code> is returned. Use
     *         <code>ClientRequestToken</code> to prevent the same job from being accidentally started more than once.
     *         For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/api-sync.html">Calling
     *         Amazon Textract Asynchronous Operations</a>.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * An identifier that you specify to be included in the completion notification published to the Amazon SNS topic.
     * For example, you can use <code>JobTag</code> to identify the type of document that the completion notification
     * corresponds to (such as a tax form or a receipt).
     * </p>
     * 
     * @return An identifier that you specify to be included in the completion notification published to the Amazon SNS
     *         topic. For example, you can use <code>JobTag</code> to identify the type of document that the completion
     *         notification corresponds to (such as a tax form or a receipt).
     */
    public final String jobTag() {
        return jobTag;
    }

    /**
     * Returns the value of the NotificationChannel property for this object.
     * 
     * @return The value of the NotificationChannel property for this object.
     */
    public final NotificationChannel notificationChannel() {
        return notificationChannel;
    }

    /**
     * Returns the value of the OutputConfig property for this object.
     * 
     * @return The value of the OutputConfig property for this object.
     */
    public final OutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * <p>
     * The KMS key used to encrypt the inference results. This can be in either Key ID or Key Alias format. When a KMS
     * key is provided, the KMS key will be used for server-side encryption of the objects in the customer bucket. When
     * this parameter is not enabled, the result will be encrypted server side, using SSE-S3.
     * </p>
     * 
     * @return The KMS key used to encrypt the inference results. This can be in either Key ID or Key Alias format. When
     *         a KMS key is provided, the KMS key will be used for server-side encryption of the objects in the customer
     *         bucket. When this parameter is not enabled, the result will be encrypted server side, using SSE-S3.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(documentLocation());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(jobTag());
        hashCode = 31 * hashCode + Objects.hashCode(notificationChannel());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartLendingAnalysisRequest)) {
            return false;
        }
        StartLendingAnalysisRequest other = (StartLendingAnalysisRequest) obj;
        return Objects.equals(documentLocation(), other.documentLocation())
                && Objects.equals(clientRequestToken(), other.clientRequestToken()) && Objects.equals(jobTag(), other.jobTag())
                && Objects.equals(notificationChannel(), other.notificationChannel())
                && Objects.equals(outputConfig(), other.outputConfig()) && Objects.equals(kmsKeyId(), other.kmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartLendingAnalysisRequest").add("DocumentLocation", documentLocation())
                .add("ClientRequestToken", clientRequestToken()).add("JobTag", jobTag())
                .add("NotificationChannel", notificationChannel()).add("OutputConfig", outputConfig())
                .add("KMSKeyId", kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentLocation":
            return Optional.ofNullable(clazz.cast(documentLocation()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "JobTag":
            return Optional.ofNullable(clazz.cast(jobTag()));
        case "NotificationChannel":
            return Optional.ofNullable(clazz.cast(notificationChannel()));
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "KMSKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DocumentLocation", DOCUMENT_LOCATION_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("JobTag", JOB_TAG_FIELD);
        map.put("NotificationChannel", NOTIFICATION_CHANNEL_FIELD);
        map.put("OutputConfig", OUTPUT_CONFIG_FIELD);
        map.put("KMSKeyId", KMS_KEY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartLendingAnalysisRequest, T> g) {
        return obj -> g.apply((StartLendingAnalysisRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TextractRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartLendingAnalysisRequest> {
        /**
         * Sets the value of the DocumentLocation property for this object.
         *
         * @param documentLocation
         *        The new value for the DocumentLocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentLocation(DocumentLocation documentLocation);

        /**
         * Sets the value of the DocumentLocation property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DocumentLocation.Builder} avoiding the
         * need to create one manually via {@link DocumentLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #documentLocation(DocumentLocation)}.
         * 
         * @param documentLocation
         *        a consumer that will call methods on {@link DocumentLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentLocation(DocumentLocation)
         */
        default Builder documentLocation(Consumer<DocumentLocation.Builder> documentLocation) {
            return documentLocation(DocumentLocation.builder().applyMutation(documentLocation).build());
        }

        /**
         * <p>
         * The idempotent token that you use to identify the start request. If you use the same token with multiple
         * <code>StartLendingAnalysis</code> requests, the same <code>JobId</code> is returned. Use
         * <code>ClientRequestToken</code> to prevent the same job from being accidentally started more than once. For
         * more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/api-sync.html">Calling Amazon
         * Textract Asynchronous Operations</a>.
         * </p>
         * 
         * @param clientRequestToken
         *        The idempotent token that you use to identify the start request. If you use the same token with
         *        multiple <code>StartLendingAnalysis</code> requests, the same <code>JobId</code> is returned. Use
         *        <code>ClientRequestToken</code> to prevent the same job from being accidentally started more than
         *        once. For more information, see <a
         *        href="https://docs.aws.amazon.com/textract/latest/dg/api-sync.html">Calling Amazon Textract
         *        Asynchronous Operations</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * An identifier that you specify to be included in the completion notification published to the Amazon SNS
         * topic. For example, you can use <code>JobTag</code> to identify the type of document that the completion
         * notification corresponds to (such as a tax form or a receipt).
         * </p>
         * 
         * @param jobTag
         *        An identifier that you specify to be included in the completion notification published to the Amazon
         *        SNS topic. For example, you can use <code>JobTag</code> to identify the type of document that the
         *        completion notification corresponds to (such as a tax form or a receipt).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTag(String jobTag);

        /**
         * Sets the value of the NotificationChannel property for this object.
         *
         * @param notificationChannel
         *        The new value for the NotificationChannel property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationChannel(NotificationChannel notificationChannel);

        /**
         * Sets the value of the NotificationChannel property for this object.
         *
         * This is a convenience method that creates an instance of the {@link NotificationChannel.Builder} avoiding the
         * need to create one manually via {@link NotificationChannel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NotificationChannel.Builder#build()} is called immediately and
         * its result is passed to {@link #notificationChannel(NotificationChannel)}.
         * 
         * @param notificationChannel
         *        a consumer that will call methods on {@link NotificationChannel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationChannel(NotificationChannel)
         */
        default Builder notificationChannel(Consumer<NotificationChannel.Builder> notificationChannel) {
            return notificationChannel(NotificationChannel.builder().applyMutation(notificationChannel).build());
        }

        /**
         * Sets the value of the OutputConfig property for this object.
         *
         * @param outputConfig
         *        The new value for the OutputConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(OutputConfig outputConfig);

        /**
         * Sets the value of the OutputConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OutputConfig.Builder} avoiding the need
         * to create one manually via {@link OutputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutputConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #outputConfig(OutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link OutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(OutputConfig)
         */
        default Builder outputConfig(Consumer<OutputConfig.Builder> outputConfig) {
            return outputConfig(OutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * <p>
         * The KMS key used to encrypt the inference results. This can be in either Key ID or Key Alias format. When a
         * KMS key is provided, the KMS key will be used for server-side encryption of the objects in the customer
         * bucket. When this parameter is not enabled, the result will be encrypted server side, using SSE-S3.
         * </p>
         * 
         * @param kmsKeyId
         *        The KMS key used to encrypt the inference results. This can be in either Key ID or Key Alias format.
         *        When a KMS key is provided, the KMS key will be used for server-side encryption of the objects in the
         *        customer bucket. When this parameter is not enabled, the result will be encrypted server side, using
         *        SSE-S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TextractRequest.BuilderImpl implements Builder {
        private DocumentLocation documentLocation;

        private String clientRequestToken;

        private String jobTag;

        private NotificationChannel notificationChannel;

        private OutputConfig outputConfig;

        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartLendingAnalysisRequest model) {
            super(model);
            documentLocation(model.documentLocation);
            clientRequestToken(model.clientRequestToken);
            jobTag(model.jobTag);
            notificationChannel(model.notificationChannel);
            outputConfig(model.outputConfig);
            kmsKeyId(model.kmsKeyId);
        }

        public final DocumentLocation.Builder getDocumentLocation() {
            return documentLocation != null ? documentLocation.toBuilder() : null;
        }

        public final void setDocumentLocation(DocumentLocation.BuilderImpl documentLocation) {
            this.documentLocation = documentLocation != null ? documentLocation.build() : null;
        }

        @Override
        public final Builder documentLocation(DocumentLocation documentLocation) {
            this.documentLocation = documentLocation;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getJobTag() {
            return jobTag;
        }

        public final void setJobTag(String jobTag) {
            this.jobTag = jobTag;
        }

        @Override
        public final Builder jobTag(String jobTag) {
            this.jobTag = jobTag;
            return this;
        }

        public final NotificationChannel.Builder getNotificationChannel() {
            return notificationChannel != null ? notificationChannel.toBuilder() : null;
        }

        public final void setNotificationChannel(NotificationChannel.BuilderImpl notificationChannel) {
            this.notificationChannel = notificationChannel != null ? notificationChannel.build() : null;
        }

        @Override
        public final Builder notificationChannel(NotificationChannel notificationChannel) {
            this.notificationChannel = notificationChannel;
            return this;
        }

        public final OutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(OutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(OutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartLendingAnalysisRequest build() {
            return new StartLendingAnalysisRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
