/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.LineItemFields;
import software.amazon.awssdk.services.textract.model.LineItemListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LineItemGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LineItemGroup> {
    private static final SdkField<Integer> LINE_ITEM_GROUP_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("LineItemGroupIndex").getter(LineItemGroup.getter(LineItemGroup::lineItemGroupIndex)).setter(LineItemGroup.setter(Builder::lineItemGroupIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineItemGroupIndex").build()}).build();
    private static final SdkField<List<LineItemFields>> LINE_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LineItems").getter(LineItemGroup.getter(LineItemGroup::lineItems)).setter(LineItemGroup.setter(Builder::lineItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LineItemFields::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINE_ITEM_GROUP_INDEX_FIELD, LINE_ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LineItemGroup.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer lineItemGroupIndex;
    private final List<LineItemFields> lineItems;

    private LineItemGroup(BuilderImpl builder) {
        this.lineItemGroupIndex = builder.lineItemGroupIndex;
        this.lineItems = builder.lineItems;
    }

    public final Integer lineItemGroupIndex() {
        return this.lineItemGroupIndex;
    }

    public final boolean hasLineItems() {
        return this.lineItems != null && !(this.lineItems instanceof SdkAutoConstructList);
    }

    public final List<LineItemFields> lineItems() {
        return this.lineItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lineItemGroupIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLineItems() ? this.lineItems() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineItemGroup)) {
            return false;
        }
        LineItemGroup other = (LineItemGroup)obj;
        return Objects.equals(this.lineItemGroupIndex(), other.lineItemGroupIndex()) && this.hasLineItems() == other.hasLineItems() && Objects.equals(this.lineItems(), other.lineItems());
    }

    public final String toString() {
        return ToString.builder((String)"LineItemGroup").add("LineItemGroupIndex", (Object)this.lineItemGroupIndex()).add("LineItems", this.hasLineItems() ? this.lineItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LineItemGroupIndex": {
                return Optional.ofNullable(clazz.cast(this.lineItemGroupIndex()));
            }
            case "LineItems": {
                return Optional.ofNullable(clazz.cast(this.lineItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LineItemGroupIndex", LINE_ITEM_GROUP_INDEX_FIELD);
        map.put("LineItems", LINE_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LineItemGroup, T> g) {
        return obj -> g.apply((LineItemGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer lineItemGroupIndex;
        private List<LineItemFields> lineItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LineItemGroup model) {
            this.lineItemGroupIndex(model.lineItemGroupIndex);
            this.lineItems(model.lineItems);
        }

        public final Integer getLineItemGroupIndex() {
            return this.lineItemGroupIndex;
        }

        public final void setLineItemGroupIndex(Integer lineItemGroupIndex) {
            this.lineItemGroupIndex = lineItemGroupIndex;
        }

        @Override
        public final Builder lineItemGroupIndex(Integer lineItemGroupIndex) {
            this.lineItemGroupIndex = lineItemGroupIndex;
            return this;
        }

        public final List<LineItemFields.Builder> getLineItems() {
            List<LineItemFields.Builder> result = LineItemListCopier.copyToBuilder(this.lineItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLineItems(Collection<LineItemFields.BuilderImpl> lineItems) {
            this.lineItems = LineItemListCopier.copyFromBuilder(lineItems);
        }

        @Override
        public final Builder lineItems(Collection<LineItemFields> lineItems) {
            this.lineItems = LineItemListCopier.copy(lineItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineItems(LineItemFields ... lineItems) {
            this.lineItems(Arrays.asList(lineItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineItems(Consumer<LineItemFields.Builder> ... lineItems) {
            this.lineItems(Stream.of(lineItems).map(c -> (LineItemFields)((LineItemFields.Builder)LineItemFields.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LineItemGroup build() {
            return new LineItemGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LineItemGroup> {
        public Builder lineItemGroupIndex(Integer var1);

        public Builder lineItems(Collection<LineItemFields> var1);

        public Builder lineItems(LineItemFields ... var1);

        public Builder lineItems(Consumer<LineItemFields.Builder> ... var1);
    }
}

