/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSolNetworkInstanceResponse extends TnbResponse implements
        ToCopyableBuilder<CreateSolNetworkInstanceResponse.Builder, CreateSolNetworkInstanceResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CreateSolNetworkInstanceResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CreateSolNetworkInstanceResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NS_INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsInstanceName").getter(getter(CreateSolNetworkInstanceResponse::nsInstanceName))
            .setter(setter(Builder::nsInstanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsInstanceName").build()).build();

    private static final SdkField<String> NSD_INFO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsdInfoId").getter(getter(CreateSolNetworkInstanceResponse::nsdInfoId))
            .setter(setter(Builder::nsdInfoId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdInfoId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateSolNetworkInstanceResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            NS_INSTANCE_NAME_FIELD, NSD_INFO_ID_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String id;

    private final String nsInstanceName;

    private final String nsdInfoId;

    private final Map<String, String> tags;

    private CreateSolNetworkInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.nsInstanceName = builder.nsInstanceName;
        this.nsdInfoId = builder.nsdInfoId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Network instance ARN.
     * </p>
     * 
     * @return Network instance ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Network instance ID.
     * </p>
     * 
     * @return Network instance ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Network instance name.
     * </p>
     * 
     * @return Network instance name.
     */
    public final String nsInstanceName() {
        return nsInstanceName;
    }

    /**
     * <p>
     * Network service descriptor ID.
     * </p>
     * 
     * @return Network service descriptor ID.
     */
    public final String nsdInfoId() {
        return nsdInfoId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional
     * value. You can use tags to search and filter your resources or track your Amazon Web Services costs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an
     *         optional value. You can use tags to search and filter your resources or track your Amazon Web Services
     *         costs.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(nsInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(nsdInfoId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSolNetworkInstanceResponse)) {
            return false;
        }
        CreateSolNetworkInstanceResponse other = (CreateSolNetworkInstanceResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id())
                && Objects.equals(nsInstanceName(), other.nsInstanceName()) && Objects.equals(nsdInfoId(), other.nsdInfoId())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSolNetworkInstanceResponse").add("Arn", arn()).add("Id", id())
                .add("NsInstanceName", nsInstanceName()).add("NsdInfoId", nsdInfoId())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "nsInstanceName":
            return Optional.ofNullable(clazz.cast(nsInstanceName()));
        case "nsdInfoId":
            return Optional.ofNullable(clazz.cast(nsdInfoId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("nsInstanceName", NS_INSTANCE_NAME_FIELD);
        map.put("nsdInfoId", NSD_INFO_ID_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSolNetworkInstanceResponse, T> g) {
        return obj -> g.apply((CreateSolNetworkInstanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TnbResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateSolNetworkInstanceResponse> {
        /**
         * <p>
         * Network instance ARN.
         * </p>
         * 
         * @param arn
         *        Network instance ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Network instance ID.
         * </p>
         * 
         * @param id
         *        Network instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Network instance name.
         * </p>
         * 
         * @param nsInstanceName
         *        Network instance name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsInstanceName(String nsInstanceName);

        /**
         * <p>
         * Network service descriptor ID.
         * </p>
         * 
         * @param nsdInfoId
         *        Network service descriptor ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsdInfoId(String nsdInfoId);

        /**
         * <p>
         * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an
         * optional value. You can use tags to search and filter your resources or track your Amazon Web Services costs.
         * </p>
         * 
         * @param tags
         *        A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an
         *        optional value. You can use tags to search and filter your resources or track your Amazon Web Services
         *        costs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends TnbResponse.BuilderImpl implements Builder {
        private String arn;

        private String id;

        private String nsInstanceName;

        private String nsdInfoId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSolNetworkInstanceResponse model) {
            super(model);
            arn(model.arn);
            id(model.id);
            nsInstanceName(model.nsInstanceName);
            nsdInfoId(model.nsdInfoId);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getNsInstanceName() {
            return nsInstanceName;
        }

        public final void setNsInstanceName(String nsInstanceName) {
            this.nsInstanceName = nsInstanceName;
        }

        @Override
        public final Builder nsInstanceName(String nsInstanceName) {
            this.nsInstanceName = nsInstanceName;
            return this;
        }

        public final String getNsdInfoId() {
            return nsdInfoId;
        }

        public final void setNsdInfoId(String nsdInfoId) {
            this.nsdInfoId = nsdInfoId;
        }

        @Override
        public final Builder nsdInfoId(String nsdInfoId) {
            this.nsdInfoId = nsdInfoId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public CreateSolNetworkInstanceResponse build() {
            return new CreateSolNetworkInstanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
