/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSolNetworkPackageResponse extends TnbResponse implements
        ToCopyableBuilder<CreateSolNetworkPackageResponse.Builder, CreateSolNetworkPackageResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CreateSolNetworkPackageResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CreateSolNetworkPackageResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NSD_ONBOARDING_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsdOnboardingState").getter(getter(CreateSolNetworkPackageResponse::nsdOnboardingStateAsString))
            .setter(setter(Builder::nsdOnboardingState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdOnboardingState").build())
            .build();

    private static final SdkField<String> NSD_OPERATIONAL_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsdOperationalState").getter(getter(CreateSolNetworkPackageResponse::nsdOperationalStateAsString))
            .setter(setter(Builder::nsdOperationalState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdOperationalState").build())
            .build();

    private static final SdkField<String> NSD_USAGE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsdUsageState").getter(getter(CreateSolNetworkPackageResponse::nsdUsageStateAsString))
            .setter(setter(Builder::nsdUsageState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdUsageState").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateSolNetworkPackageResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            NSD_ONBOARDING_STATE_FIELD, NSD_OPERATIONAL_STATE_FIELD, NSD_USAGE_STATE_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String id;

    private final String nsdOnboardingState;

    private final String nsdOperationalState;

    private final String nsdUsageState;

    private final Map<String, String> tags;

    private CreateSolNetworkPackageResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.nsdOnboardingState = builder.nsdOnboardingState;
        this.nsdOperationalState = builder.nsdOperationalState;
        this.nsdUsageState = builder.nsdUsageState;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Network package ARN.
     * </p>
     * 
     * @return Network package ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * ID of the network package.
     * </p>
     * 
     * @return ID of the network package.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Onboarding state of the network service descriptor in the network package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nsdOnboardingState} will return {@link NsdOnboardingState#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #nsdOnboardingStateAsString}.
     * </p>
     * 
     * @return Onboarding state of the network service descriptor in the network package.
     * @see NsdOnboardingState
     */
    public final NsdOnboardingState nsdOnboardingState() {
        return NsdOnboardingState.fromValue(nsdOnboardingState);
    }

    /**
     * <p>
     * Onboarding state of the network service descriptor in the network package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nsdOnboardingState} will return {@link NsdOnboardingState#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #nsdOnboardingStateAsString}.
     * </p>
     * 
     * @return Onboarding state of the network service descriptor in the network package.
     * @see NsdOnboardingState
     */
    public final String nsdOnboardingStateAsString() {
        return nsdOnboardingState;
    }

    /**
     * <p>
     * Operational state of the network service descriptor in the network package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nsdOperationalState} will return {@link NsdOperationalState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #nsdOperationalStateAsString}.
     * </p>
     * 
     * @return Operational state of the network service descriptor in the network package.
     * @see NsdOperationalState
     */
    public final NsdOperationalState nsdOperationalState() {
        return NsdOperationalState.fromValue(nsdOperationalState);
    }

    /**
     * <p>
     * Operational state of the network service descriptor in the network package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nsdOperationalState} will return {@link NsdOperationalState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #nsdOperationalStateAsString}.
     * </p>
     * 
     * @return Operational state of the network service descriptor in the network package.
     * @see NsdOperationalState
     */
    public final String nsdOperationalStateAsString() {
        return nsdOperationalState;
    }

    /**
     * <p>
     * Usage state of the network service descriptor in the network package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nsdUsageState}
     * will return {@link NsdUsageState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nsdUsageStateAsString}.
     * </p>
     * 
     * @return Usage state of the network service descriptor in the network package.
     * @see NsdUsageState
     */
    public final NsdUsageState nsdUsageState() {
        return NsdUsageState.fromValue(nsdUsageState);
    }

    /**
     * <p>
     * Usage state of the network service descriptor in the network package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nsdUsageState}
     * will return {@link NsdUsageState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nsdUsageStateAsString}.
     * </p>
     * 
     * @return Usage state of the network service descriptor in the network package.
     * @see NsdUsageState
     */
    public final String nsdUsageStateAsString() {
        return nsdUsageState;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional
     * value. You can use tags to search and filter your resources or track your Amazon Web Services costs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an
     *         optional value. You can use tags to search and filter your resources or track your Amazon Web Services
     *         costs.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(nsdOnboardingStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nsdOperationalStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nsdUsageStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSolNetworkPackageResponse)) {
            return false;
        }
        CreateSolNetworkPackageResponse other = (CreateSolNetworkPackageResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id())
                && Objects.equals(nsdOnboardingStateAsString(), other.nsdOnboardingStateAsString())
                && Objects.equals(nsdOperationalStateAsString(), other.nsdOperationalStateAsString())
                && Objects.equals(nsdUsageStateAsString(), other.nsdUsageStateAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSolNetworkPackageResponse").add("Arn", arn()).add("Id", id())
                .add("NsdOnboardingState", nsdOnboardingStateAsString())
                .add("NsdOperationalState", nsdOperationalStateAsString()).add("NsdUsageState", nsdUsageStateAsString())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "nsdOnboardingState":
            return Optional.ofNullable(clazz.cast(nsdOnboardingStateAsString()));
        case "nsdOperationalState":
            return Optional.ofNullable(clazz.cast(nsdOperationalStateAsString()));
        case "nsdUsageState":
            return Optional.ofNullable(clazz.cast(nsdUsageStateAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("nsdOnboardingState", NSD_ONBOARDING_STATE_FIELD);
        map.put("nsdOperationalState", NSD_OPERATIONAL_STATE_FIELD);
        map.put("nsdUsageState", NSD_USAGE_STATE_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSolNetworkPackageResponse, T> g) {
        return obj -> g.apply((CreateSolNetworkPackageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TnbResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateSolNetworkPackageResponse> {
        /**
         * <p>
         * Network package ARN.
         * </p>
         * 
         * @param arn
         *        Network package ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * ID of the network package.
         * </p>
         * 
         * @param id
         *        ID of the network package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Onboarding state of the network service descriptor in the network package.
         * </p>
         * 
         * @param nsdOnboardingState
         *        Onboarding state of the network service descriptor in the network package.
         * @see NsdOnboardingState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NsdOnboardingState
         */
        Builder nsdOnboardingState(String nsdOnboardingState);

        /**
         * <p>
         * Onboarding state of the network service descriptor in the network package.
         * </p>
         * 
         * @param nsdOnboardingState
         *        Onboarding state of the network service descriptor in the network package.
         * @see NsdOnboardingState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NsdOnboardingState
         */
        Builder nsdOnboardingState(NsdOnboardingState nsdOnboardingState);

        /**
         * <p>
         * Operational state of the network service descriptor in the network package.
         * </p>
         * 
         * @param nsdOperationalState
         *        Operational state of the network service descriptor in the network package.
         * @see NsdOperationalState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NsdOperationalState
         */
        Builder nsdOperationalState(String nsdOperationalState);

        /**
         * <p>
         * Operational state of the network service descriptor in the network package.
         * </p>
         * 
         * @param nsdOperationalState
         *        Operational state of the network service descriptor in the network package.
         * @see NsdOperationalState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NsdOperationalState
         */
        Builder nsdOperationalState(NsdOperationalState nsdOperationalState);

        /**
         * <p>
         * Usage state of the network service descriptor in the network package.
         * </p>
         * 
         * @param nsdUsageState
         *        Usage state of the network service descriptor in the network package.
         * @see NsdUsageState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NsdUsageState
         */
        Builder nsdUsageState(String nsdUsageState);

        /**
         * <p>
         * Usage state of the network service descriptor in the network package.
         * </p>
         * 
         * @param nsdUsageState
         *        Usage state of the network service descriptor in the network package.
         * @see NsdUsageState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NsdUsageState
         */
        Builder nsdUsageState(NsdUsageState nsdUsageState);

        /**
         * <p>
         * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an
         * optional value. You can use tags to search and filter your resources or track your Amazon Web Services costs.
         * </p>
         * 
         * @param tags
         *        A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an
         *        optional value. You can use tags to search and filter your resources or track your Amazon Web Services
         *        costs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends TnbResponse.BuilderImpl implements Builder {
        private String arn;

        private String id;

        private String nsdOnboardingState;

        private String nsdOperationalState;

        private String nsdUsageState;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSolNetworkPackageResponse model) {
            super(model);
            arn(model.arn);
            id(model.id);
            nsdOnboardingState(model.nsdOnboardingState);
            nsdOperationalState(model.nsdOperationalState);
            nsdUsageState(model.nsdUsageState);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getNsdOnboardingState() {
            return nsdOnboardingState;
        }

        public final void setNsdOnboardingState(String nsdOnboardingState) {
            this.nsdOnboardingState = nsdOnboardingState;
        }

        @Override
        public final Builder nsdOnboardingState(String nsdOnboardingState) {
            this.nsdOnboardingState = nsdOnboardingState;
            return this;
        }

        @Override
        public final Builder nsdOnboardingState(NsdOnboardingState nsdOnboardingState) {
            this.nsdOnboardingState(nsdOnboardingState == null ? null : nsdOnboardingState.toString());
            return this;
        }

        public final String getNsdOperationalState() {
            return nsdOperationalState;
        }

        public final void setNsdOperationalState(String nsdOperationalState) {
            this.nsdOperationalState = nsdOperationalState;
        }

        @Override
        public final Builder nsdOperationalState(String nsdOperationalState) {
            this.nsdOperationalState = nsdOperationalState;
            return this;
        }

        @Override
        public final Builder nsdOperationalState(NsdOperationalState nsdOperationalState) {
            this.nsdOperationalState(nsdOperationalState == null ? null : nsdOperationalState.toString());
            return this;
        }

        public final String getNsdUsageState() {
            return nsdUsageState;
        }

        public final void setNsdUsageState(String nsdUsageState) {
            this.nsdUsageState = nsdUsageState;
        }

        @Override
        public final Builder nsdUsageState(String nsdUsageState) {
            this.nsdUsageState = nsdUsageState;
            return this;
        }

        @Override
        public final Builder nsdUsageState(NsdUsageState nsdUsageState) {
            this.nsdUsageState(nsdUsageState == null ? null : nsdUsageState.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public CreateSolNetworkPackageResponse build() {
            return new CreateSolNetworkPackageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
