/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSolFunctionPackageResponse extends TnbResponse implements
        ToCopyableBuilder<GetSolFunctionPackageResponse.Builder, GetSolFunctionPackageResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetSolFunctionPackageResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetSolFunctionPackageResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<GetSolFunctionPackageMetadata> METADATA_FIELD = SdkField
            .<GetSolFunctionPackageMetadata> builder(MarshallingType.SDK_POJO).memberName("metadata")
            .getter(getter(GetSolFunctionPackageResponse::metadata)).setter(setter(Builder::metadata))
            .constructor(GetSolFunctionPackageMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final SdkField<String> ONBOARDING_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("onboardingState").getter(getter(GetSolFunctionPackageResponse::onboardingStateAsString))
            .setter(setter(Builder::onboardingState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onboardingState").build()).build();

    private static final SdkField<String> OPERATIONAL_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operationalState").getter(getter(GetSolFunctionPackageResponse::operationalStateAsString))
            .setter(setter(Builder::operationalState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationalState").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetSolFunctionPackageResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> USAGE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usageState").getter(getter(GetSolFunctionPackageResponse::usageStateAsString))
            .setter(setter(Builder::usageState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageState").build()).build();

    private static final SdkField<String> VNF_PRODUCT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vnfProductName").getter(getter(GetSolFunctionPackageResponse::vnfProductName))
            .setter(setter(Builder::vnfProductName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfProductName").build()).build();

    private static final SdkField<String> VNF_PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vnfProvider").getter(getter(GetSolFunctionPackageResponse::vnfProvider))
            .setter(setter(Builder::vnfProvider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfProvider").build()).build();

    private static final SdkField<String> VNFD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("vnfdId")
            .getter(getter(GetSolFunctionPackageResponse::vnfdId)).setter(setter(Builder::vnfdId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfdId").build()).build();

    private static final SdkField<String> VNFD_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vnfdVersion").getter(getter(GetSolFunctionPackageResponse::vnfdVersion))
            .setter(setter(Builder::vnfdVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfdVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            METADATA_FIELD, ONBOARDING_STATE_FIELD, OPERATIONAL_STATE_FIELD, TAGS_FIELD, USAGE_STATE_FIELD,
            VNF_PRODUCT_NAME_FIELD, VNF_PROVIDER_FIELD, VNFD_ID_FIELD, VNFD_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String id;

    private final GetSolFunctionPackageMetadata metadata;

    private final String onboardingState;

    private final String operationalState;

    private final Map<String, String> tags;

    private final String usageState;

    private final String vnfProductName;

    private final String vnfProvider;

    private final String vnfdId;

    private final String vnfdVersion;

    private GetSolFunctionPackageResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.metadata = builder.metadata;
        this.onboardingState = builder.onboardingState;
        this.operationalState = builder.operationalState;
        this.tags = builder.tags;
        this.usageState = builder.usageState;
        this.vnfProductName = builder.vnfProductName;
        this.vnfProvider = builder.vnfProvider;
        this.vnfdId = builder.vnfdId;
        this.vnfdVersion = builder.vnfdVersion;
    }

    /**
     * <p>
     * Function package ARN.
     * </p>
     * 
     * @return Function package ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Function package ID.
     * </p>
     * 
     * @return Function package ID.
     */
    public final String id() {
        return id;
    }

    /**
     * Returns the value of the Metadata property for this object.
     * 
     * @return The value of the Metadata property for this object.
     */
    public final GetSolFunctionPackageMetadata metadata() {
        return metadata;
    }

    /**
     * <p>
     * Function package onboarding state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #onboardingState}
     * will return {@link OnboardingState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #onboardingStateAsString}.
     * </p>
     * 
     * @return Function package onboarding state.
     * @see OnboardingState
     */
    public final OnboardingState onboardingState() {
        return OnboardingState.fromValue(onboardingState);
    }

    /**
     * <p>
     * Function package onboarding state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #onboardingState}
     * will return {@link OnboardingState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #onboardingStateAsString}.
     * </p>
     * 
     * @return Function package onboarding state.
     * @see OnboardingState
     */
    public final String onboardingStateAsString() {
        return onboardingState;
    }

    /**
     * <p>
     * Function package operational state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationalState}
     * will return {@link OperationalState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operationalStateAsString}.
     * </p>
     * 
     * @return Function package operational state.
     * @see OperationalState
     */
    public final OperationalState operationalState() {
        return OperationalState.fromValue(operationalState);
    }

    /**
     * <p>
     * Function package operational state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationalState}
     * will return {@link OperationalState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operationalStateAsString}.
     * </p>
     * 
     * @return Function package operational state.
     * @see OperationalState
     */
    public final String operationalStateAsString() {
        return operationalState;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional
     * value. You can use tags to search and filter your resources or track your Amazon Web Services costs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an
     *         optional value. You can use tags to search and filter your resources or track your Amazon Web Services
     *         costs.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Function package usage state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #usageState} will
     * return {@link UsageState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #usageStateAsString}.
     * </p>
     * 
     * @return Function package usage state.
     * @see UsageState
     */
    public final UsageState usageState() {
        return UsageState.fromValue(usageState);
    }

    /**
     * <p>
     * Function package usage state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #usageState} will
     * return {@link UsageState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #usageStateAsString}.
     * </p>
     * 
     * @return Function package usage state.
     * @see UsageState
     */
    public final String usageStateAsString() {
        return usageState;
    }

    /**
     * <p>
     * Network function product name.
     * </p>
     * 
     * @return Network function product name.
     */
    public final String vnfProductName() {
        return vnfProductName;
    }

    /**
     * <p>
     * Network function provider.
     * </p>
     * 
     * @return Network function provider.
     */
    public final String vnfProvider() {
        return vnfProvider;
    }

    /**
     * <p>
     * Function package descriptor ID.
     * </p>
     * 
     * @return Function package descriptor ID.
     */
    public final String vnfdId() {
        return vnfdId;
    }

    /**
     * <p>
     * Function package descriptor version.
     * </p>
     * 
     * @return Function package descriptor version.
     */
    public final String vnfdVersion() {
        return vnfdVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(onboardingStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(operationalStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(usageStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vnfProductName());
        hashCode = 31 * hashCode + Objects.hashCode(vnfProvider());
        hashCode = 31 * hashCode + Objects.hashCode(vnfdId());
        hashCode = 31 * hashCode + Objects.hashCode(vnfdVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSolFunctionPackageResponse)) {
            return false;
        }
        GetSolFunctionPackageResponse other = (GetSolFunctionPackageResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id())
                && Objects.equals(metadata(), other.metadata())
                && Objects.equals(onboardingStateAsString(), other.onboardingStateAsString())
                && Objects.equals(operationalStateAsString(), other.operationalStateAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(usageStateAsString(), other.usageStateAsString())
                && Objects.equals(vnfProductName(), other.vnfProductName()) && Objects.equals(vnfProvider(), other.vnfProvider())
                && Objects.equals(vnfdId(), other.vnfdId()) && Objects.equals(vnfdVersion(), other.vnfdVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSolFunctionPackageResponse").add("Arn", arn()).add("Id", id()).add("Metadata", metadata())
                .add("OnboardingState", onboardingStateAsString()).add("OperationalState", operationalStateAsString())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").add("UsageState", usageStateAsString())
                .add("VnfProductName", vnfProductName()).add("VnfProvider", vnfProvider()).add("VnfdId", vnfdId())
                .add("VnfdVersion", vnfdVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "onboardingState":
            return Optional.ofNullable(clazz.cast(onboardingStateAsString()));
        case "operationalState":
            return Optional.ofNullable(clazz.cast(operationalStateAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "usageState":
            return Optional.ofNullable(clazz.cast(usageStateAsString()));
        case "vnfProductName":
            return Optional.ofNullable(clazz.cast(vnfProductName()));
        case "vnfProvider":
            return Optional.ofNullable(clazz.cast(vnfProvider()));
        case "vnfdId":
            return Optional.ofNullable(clazz.cast(vnfdId()));
        case "vnfdVersion":
            return Optional.ofNullable(clazz.cast(vnfdVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("metadata", METADATA_FIELD);
        map.put("onboardingState", ONBOARDING_STATE_FIELD);
        map.put("operationalState", OPERATIONAL_STATE_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("usageState", USAGE_STATE_FIELD);
        map.put("vnfProductName", VNF_PRODUCT_NAME_FIELD);
        map.put("vnfProvider", VNF_PROVIDER_FIELD);
        map.put("vnfdId", VNFD_ID_FIELD);
        map.put("vnfdVersion", VNFD_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSolFunctionPackageResponse, T> g) {
        return obj -> g.apply((GetSolFunctionPackageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TnbResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSolFunctionPackageResponse> {
        /**
         * <p>
         * Function package ARN.
         * </p>
         * 
         * @param arn
         *        Function package ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Function package ID.
         * </p>
         * 
         * @param id
         *        Function package ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the Metadata property for this object.
         *
         * @param metadata
         *        The new value for the Metadata property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(GetSolFunctionPackageMetadata metadata);

        /**
         * Sets the value of the Metadata property for this object.
         *
         * This is a convenience method that creates an instance of the {@link GetSolFunctionPackageMetadata.Builder}
         * avoiding the need to create one manually via {@link GetSolFunctionPackageMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GetSolFunctionPackageMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #metadata(GetSolFunctionPackageMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link GetSolFunctionPackageMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(GetSolFunctionPackageMetadata)
         */
        default Builder metadata(Consumer<GetSolFunctionPackageMetadata.Builder> metadata) {
            return metadata(GetSolFunctionPackageMetadata.builder().applyMutation(metadata).build());
        }

        /**
         * <p>
         * Function package onboarding state.
         * </p>
         * 
         * @param onboardingState
         *        Function package onboarding state.
         * @see OnboardingState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OnboardingState
         */
        Builder onboardingState(String onboardingState);

        /**
         * <p>
         * Function package onboarding state.
         * </p>
         * 
         * @param onboardingState
         *        Function package onboarding state.
         * @see OnboardingState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OnboardingState
         */
        Builder onboardingState(OnboardingState onboardingState);

        /**
         * <p>
         * Function package operational state.
         * </p>
         * 
         * @param operationalState
         *        Function package operational state.
         * @see OperationalState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationalState
         */
        Builder operationalState(String operationalState);

        /**
         * <p>
         * Function package operational state.
         * </p>
         * 
         * @param operationalState
         *        Function package operational state.
         * @see OperationalState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationalState
         */
        Builder operationalState(OperationalState operationalState);

        /**
         * <p>
         * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an
         * optional value. You can use tags to search and filter your resources or track your Amazon Web Services costs.
         * </p>
         * 
         * @param tags
         *        A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an
         *        optional value. You can use tags to search and filter your resources or track your Amazon Web Services
         *        costs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Function package usage state.
         * </p>
         * 
         * @param usageState
         *        Function package usage state.
         * @see UsageState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageState
         */
        Builder usageState(String usageState);

        /**
         * <p>
         * Function package usage state.
         * </p>
         * 
         * @param usageState
         *        Function package usage state.
         * @see UsageState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageState
         */
        Builder usageState(UsageState usageState);

        /**
         * <p>
         * Network function product name.
         * </p>
         * 
         * @param vnfProductName
         *        Network function product name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfProductName(String vnfProductName);

        /**
         * <p>
         * Network function provider.
         * </p>
         * 
         * @param vnfProvider
         *        Network function provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfProvider(String vnfProvider);

        /**
         * <p>
         * Function package descriptor ID.
         * </p>
         * 
         * @param vnfdId
         *        Function package descriptor ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfdId(String vnfdId);

        /**
         * <p>
         * Function package descriptor version.
         * </p>
         * 
         * @param vnfdVersion
         *        Function package descriptor version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfdVersion(String vnfdVersion);
    }

    static final class BuilderImpl extends TnbResponse.BuilderImpl implements Builder {
        private String arn;

        private String id;

        private GetSolFunctionPackageMetadata metadata;

        private String onboardingState;

        private String operationalState;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String usageState;

        private String vnfProductName;

        private String vnfProvider;

        private String vnfdId;

        private String vnfdVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSolFunctionPackageResponse model) {
            super(model);
            arn(model.arn);
            id(model.id);
            metadata(model.metadata);
            onboardingState(model.onboardingState);
            operationalState(model.operationalState);
            tags(model.tags);
            usageState(model.usageState);
            vnfProductName(model.vnfProductName);
            vnfProvider(model.vnfProvider);
            vnfdId(model.vnfdId);
            vnfdVersion(model.vnfdVersion);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final GetSolFunctionPackageMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(GetSolFunctionPackageMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(GetSolFunctionPackageMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getOnboardingState() {
            return onboardingState;
        }

        public final void setOnboardingState(String onboardingState) {
            this.onboardingState = onboardingState;
        }

        @Override
        public final Builder onboardingState(String onboardingState) {
            this.onboardingState = onboardingState;
            return this;
        }

        @Override
        public final Builder onboardingState(OnboardingState onboardingState) {
            this.onboardingState(onboardingState == null ? null : onboardingState.toString());
            return this;
        }

        public final String getOperationalState() {
            return operationalState;
        }

        public final void setOperationalState(String operationalState) {
            this.operationalState = operationalState;
        }

        @Override
        public final Builder operationalState(String operationalState) {
            this.operationalState = operationalState;
            return this;
        }

        @Override
        public final Builder operationalState(OperationalState operationalState) {
            this.operationalState(operationalState == null ? null : operationalState.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getUsageState() {
            return usageState;
        }

        public final void setUsageState(String usageState) {
            this.usageState = usageState;
        }

        @Override
        public final Builder usageState(String usageState) {
            this.usageState = usageState;
            return this;
        }

        @Override
        public final Builder usageState(UsageState usageState) {
            this.usageState(usageState == null ? null : usageState.toString());
            return this;
        }

        public final String getVnfProductName() {
            return vnfProductName;
        }

        public final void setVnfProductName(String vnfProductName) {
            this.vnfProductName = vnfProductName;
        }

        @Override
        public final Builder vnfProductName(String vnfProductName) {
            this.vnfProductName = vnfProductName;
            return this;
        }

        public final String getVnfProvider() {
            return vnfProvider;
        }

        public final void setVnfProvider(String vnfProvider) {
            this.vnfProvider = vnfProvider;
        }

        @Override
        public final Builder vnfProvider(String vnfProvider) {
            this.vnfProvider = vnfProvider;
            return this;
        }

        public final String getVnfdId() {
            return vnfdId;
        }

        public final void setVnfdId(String vnfdId) {
            this.vnfdId = vnfdId;
        }

        @Override
        public final Builder vnfdId(String vnfdId) {
            this.vnfdId = vnfdId;
            return this;
        }

        public final String getVnfdVersion() {
            return vnfdVersion;
        }

        public final void setVnfdVersion(String vnfdVersion) {
            this.vnfdVersion = vnfdVersion;
        }

        @Override
        public final Builder vnfdVersion(String vnfdVersion) {
            this.vnfdVersion = vnfdVersion;
            return this;
        }

        @Override
        public GetSolFunctionPackageResponse build() {
            return new GetSolFunctionPackageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
