/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSolNetworkInstanceResponse extends TnbResponse implements
        ToCopyableBuilder<GetSolNetworkInstanceResponse.Builder, GetSolNetworkInstanceResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetSolNetworkInstanceResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetSolNetworkInstanceResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<LcmOperationInfo> LCM_OP_INFO_FIELD = SdkField
            .<LcmOperationInfo> builder(MarshallingType.SDK_POJO).memberName("lcmOpInfo")
            .getter(getter(GetSolNetworkInstanceResponse::lcmOpInfo)).setter(setter(Builder::lcmOpInfo))
            .constructor(LcmOperationInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lcmOpInfo").build()).build();

    private static final SdkField<GetSolNetworkInstanceMetadata> METADATA_FIELD = SdkField
            .<GetSolNetworkInstanceMetadata> builder(MarshallingType.SDK_POJO).memberName("metadata")
            .getter(getter(GetSolNetworkInstanceResponse::metadata)).setter(setter(Builder::metadata))
            .constructor(GetSolNetworkInstanceMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final SdkField<String> NS_INSTANCE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsInstanceDescription").getter(getter(GetSolNetworkInstanceResponse::nsInstanceDescription))
            .setter(setter(Builder::nsInstanceDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsInstanceDescription").build())
            .build();

    private static final SdkField<String> NS_INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsInstanceName").getter(getter(GetSolNetworkInstanceResponse::nsInstanceName))
            .setter(setter(Builder::nsInstanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsInstanceName").build()).build();

    private static final SdkField<String> NS_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsState").getter(getter(GetSolNetworkInstanceResponse::nsStateAsString))
            .setter(setter(Builder::nsState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsState").build()).build();

    private static final SdkField<String> NSD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("nsdId")
            .getter(getter(GetSolNetworkInstanceResponse::nsdId)).setter(setter(Builder::nsdId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdId").build()).build();

    private static final SdkField<String> NSD_INFO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsdInfoId").getter(getter(GetSolNetworkInstanceResponse::nsdInfoId)).setter(setter(Builder::nsdInfoId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdInfoId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetSolNetworkInstanceResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            LCM_OP_INFO_FIELD, METADATA_FIELD, NS_INSTANCE_DESCRIPTION_FIELD, NS_INSTANCE_NAME_FIELD, NS_STATE_FIELD,
            NSD_ID_FIELD, NSD_INFO_ID_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String id;

    private final LcmOperationInfo lcmOpInfo;

    private final GetSolNetworkInstanceMetadata metadata;

    private final String nsInstanceDescription;

    private final String nsInstanceName;

    private final String nsState;

    private final String nsdId;

    private final String nsdInfoId;

    private final Map<String, String> tags;

    private GetSolNetworkInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.lcmOpInfo = builder.lcmOpInfo;
        this.metadata = builder.metadata;
        this.nsInstanceDescription = builder.nsInstanceDescription;
        this.nsInstanceName = builder.nsInstanceName;
        this.nsState = builder.nsState;
        this.nsdId = builder.nsdId;
        this.nsdInfoId = builder.nsdInfoId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Network instance ARN.
     * </p>
     * 
     * @return Network instance ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Network instance ID.
     * </p>
     * 
     * @return Network instance ID.
     */
    public final String id() {
        return id;
    }

    /**
     * Returns the value of the LcmOpInfo property for this object.
     * 
     * @return The value of the LcmOpInfo property for this object.
     */
    public final LcmOperationInfo lcmOpInfo() {
        return lcmOpInfo;
    }

    /**
     * Returns the value of the Metadata property for this object.
     * 
     * @return The value of the Metadata property for this object.
     */
    public final GetSolNetworkInstanceMetadata metadata() {
        return metadata;
    }

    /**
     * <p>
     * Network instance description.
     * </p>
     * 
     * @return Network instance description.
     */
    public final String nsInstanceDescription() {
        return nsInstanceDescription;
    }

    /**
     * <p>
     * Network instance name.
     * </p>
     * 
     * @return Network instance name.
     */
    public final String nsInstanceName() {
        return nsInstanceName;
    }

    /**
     * <p>
     * Network instance state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nsState} will
     * return {@link NsState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nsStateAsString}.
     * </p>
     * 
     * @return Network instance state.
     * @see NsState
     */
    public final NsState nsState() {
        return NsState.fromValue(nsState);
    }

    /**
     * <p>
     * Network instance state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nsState} will
     * return {@link NsState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nsStateAsString}.
     * </p>
     * 
     * @return Network instance state.
     * @see NsState
     */
    public final String nsStateAsString() {
        return nsState;
    }

    /**
     * <p>
     * Network service descriptor ID.
     * </p>
     * 
     * @return Network service descriptor ID.
     */
    public final String nsdId() {
        return nsdId;
    }

    /**
     * <p>
     * Network service descriptor info ID.
     * </p>
     * 
     * @return Network service descriptor info ID.
     */
    public final String nsdInfoId() {
        return nsdInfoId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional
     * value. You can use tags to search and filter your resources or track your Amazon Web Services costs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an
     *         optional value. You can use tags to search and filter your resources or track your Amazon Web Services
     *         costs.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lcmOpInfo());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(nsInstanceDescription());
        hashCode = 31 * hashCode + Objects.hashCode(nsInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(nsStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nsdId());
        hashCode = 31 * hashCode + Objects.hashCode(nsdInfoId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSolNetworkInstanceResponse)) {
            return false;
        }
        GetSolNetworkInstanceResponse other = (GetSolNetworkInstanceResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id())
                && Objects.equals(lcmOpInfo(), other.lcmOpInfo()) && Objects.equals(metadata(), other.metadata())
                && Objects.equals(nsInstanceDescription(), other.nsInstanceDescription())
                && Objects.equals(nsInstanceName(), other.nsInstanceName())
                && Objects.equals(nsStateAsString(), other.nsStateAsString()) && Objects.equals(nsdId(), other.nsdId())
                && Objects.equals(nsdInfoId(), other.nsdInfoId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSolNetworkInstanceResponse").add("Arn", arn()).add("Id", id()).add("LcmOpInfo", lcmOpInfo())
                .add("Metadata", metadata()).add("NsInstanceDescription", nsInstanceDescription())
                .add("NsInstanceName", nsInstanceName()).add("NsState", nsStateAsString()).add("NsdId", nsdId())
                .add("NsdInfoId", nsdInfoId()).add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "lcmOpInfo":
            return Optional.ofNullable(clazz.cast(lcmOpInfo()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "nsInstanceDescription":
            return Optional.ofNullable(clazz.cast(nsInstanceDescription()));
        case "nsInstanceName":
            return Optional.ofNullable(clazz.cast(nsInstanceName()));
        case "nsState":
            return Optional.ofNullable(clazz.cast(nsStateAsString()));
        case "nsdId":
            return Optional.ofNullable(clazz.cast(nsdId()));
        case "nsdInfoId":
            return Optional.ofNullable(clazz.cast(nsdInfoId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("lcmOpInfo", LCM_OP_INFO_FIELD);
        map.put("metadata", METADATA_FIELD);
        map.put("nsInstanceDescription", NS_INSTANCE_DESCRIPTION_FIELD);
        map.put("nsInstanceName", NS_INSTANCE_NAME_FIELD);
        map.put("nsState", NS_STATE_FIELD);
        map.put("nsdId", NSD_ID_FIELD);
        map.put("nsdInfoId", NSD_INFO_ID_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSolNetworkInstanceResponse, T> g) {
        return obj -> g.apply((GetSolNetworkInstanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TnbResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSolNetworkInstanceResponse> {
        /**
         * <p>
         * Network instance ARN.
         * </p>
         * 
         * @param arn
         *        Network instance ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Network instance ID.
         * </p>
         * 
         * @param id
         *        Network instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the LcmOpInfo property for this object.
         *
         * @param lcmOpInfo
         *        The new value for the LcmOpInfo property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lcmOpInfo(LcmOperationInfo lcmOpInfo);

        /**
         * Sets the value of the LcmOpInfo property for this object.
         *
         * This is a convenience method that creates an instance of the {@link LcmOperationInfo.Builder} avoiding the
         * need to create one manually via {@link LcmOperationInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LcmOperationInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #lcmOpInfo(LcmOperationInfo)}.
         * 
         * @param lcmOpInfo
         *        a consumer that will call methods on {@link LcmOperationInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lcmOpInfo(LcmOperationInfo)
         */
        default Builder lcmOpInfo(Consumer<LcmOperationInfo.Builder> lcmOpInfo) {
            return lcmOpInfo(LcmOperationInfo.builder().applyMutation(lcmOpInfo).build());
        }

        /**
         * Sets the value of the Metadata property for this object.
         *
         * @param metadata
         *        The new value for the Metadata property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(GetSolNetworkInstanceMetadata metadata);

        /**
         * Sets the value of the Metadata property for this object.
         *
         * This is a convenience method that creates an instance of the {@link GetSolNetworkInstanceMetadata.Builder}
         * avoiding the need to create one manually via {@link GetSolNetworkInstanceMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GetSolNetworkInstanceMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #metadata(GetSolNetworkInstanceMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link GetSolNetworkInstanceMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(GetSolNetworkInstanceMetadata)
         */
        default Builder metadata(Consumer<GetSolNetworkInstanceMetadata.Builder> metadata) {
            return metadata(GetSolNetworkInstanceMetadata.builder().applyMutation(metadata).build());
        }

        /**
         * <p>
         * Network instance description.
         * </p>
         * 
         * @param nsInstanceDescription
         *        Network instance description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsInstanceDescription(String nsInstanceDescription);

        /**
         * <p>
         * Network instance name.
         * </p>
         * 
         * @param nsInstanceName
         *        Network instance name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsInstanceName(String nsInstanceName);

        /**
         * <p>
         * Network instance state.
         * </p>
         * 
         * @param nsState
         *        Network instance state.
         * @see NsState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NsState
         */
        Builder nsState(String nsState);

        /**
         * <p>
         * Network instance state.
         * </p>
         * 
         * @param nsState
         *        Network instance state.
         * @see NsState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NsState
         */
        Builder nsState(NsState nsState);

        /**
         * <p>
         * Network service descriptor ID.
         * </p>
         * 
         * @param nsdId
         *        Network service descriptor ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsdId(String nsdId);

        /**
         * <p>
         * Network service descriptor info ID.
         * </p>
         * 
         * @param nsdInfoId
         *        Network service descriptor info ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsdInfoId(String nsdInfoId);

        /**
         * <p>
         * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an
         * optional value. You can use tags to search and filter your resources or track your Amazon Web Services costs.
         * </p>
         * 
         * @param tags
         *        A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an
         *        optional value. You can use tags to search and filter your resources or track your Amazon Web Services
         *        costs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends TnbResponse.BuilderImpl implements Builder {
        private String arn;

        private String id;

        private LcmOperationInfo lcmOpInfo;

        private GetSolNetworkInstanceMetadata metadata;

        private String nsInstanceDescription;

        private String nsInstanceName;

        private String nsState;

        private String nsdId;

        private String nsdInfoId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSolNetworkInstanceResponse model) {
            super(model);
            arn(model.arn);
            id(model.id);
            lcmOpInfo(model.lcmOpInfo);
            metadata(model.metadata);
            nsInstanceDescription(model.nsInstanceDescription);
            nsInstanceName(model.nsInstanceName);
            nsState(model.nsState);
            nsdId(model.nsdId);
            nsdInfoId(model.nsdInfoId);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final LcmOperationInfo.Builder getLcmOpInfo() {
            return lcmOpInfo != null ? lcmOpInfo.toBuilder() : null;
        }

        public final void setLcmOpInfo(LcmOperationInfo.BuilderImpl lcmOpInfo) {
            this.lcmOpInfo = lcmOpInfo != null ? lcmOpInfo.build() : null;
        }

        @Override
        public final Builder lcmOpInfo(LcmOperationInfo lcmOpInfo) {
            this.lcmOpInfo = lcmOpInfo;
            return this;
        }

        public final GetSolNetworkInstanceMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(GetSolNetworkInstanceMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(GetSolNetworkInstanceMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getNsInstanceDescription() {
            return nsInstanceDescription;
        }

        public final void setNsInstanceDescription(String nsInstanceDescription) {
            this.nsInstanceDescription = nsInstanceDescription;
        }

        @Override
        public final Builder nsInstanceDescription(String nsInstanceDescription) {
            this.nsInstanceDescription = nsInstanceDescription;
            return this;
        }

        public final String getNsInstanceName() {
            return nsInstanceName;
        }

        public final void setNsInstanceName(String nsInstanceName) {
            this.nsInstanceName = nsInstanceName;
        }

        @Override
        public final Builder nsInstanceName(String nsInstanceName) {
            this.nsInstanceName = nsInstanceName;
            return this;
        }

        public final String getNsState() {
            return nsState;
        }

        public final void setNsState(String nsState) {
            this.nsState = nsState;
        }

        @Override
        public final Builder nsState(String nsState) {
            this.nsState = nsState;
            return this;
        }

        @Override
        public final Builder nsState(NsState nsState) {
            this.nsState(nsState == null ? null : nsState.toString());
            return this;
        }

        public final String getNsdId() {
            return nsdId;
        }

        public final void setNsdId(String nsdId) {
            this.nsdId = nsdId;
        }

        @Override
        public final Builder nsdId(String nsdId) {
            this.nsdId = nsdId;
            return this;
        }

        public final String getNsdInfoId() {
            return nsdInfoId;
        }

        public final void setNsdInfoId(String nsdInfoId) {
            this.nsdInfoId = nsdInfoId;
        }

        @Override
        public final Builder nsdInfoId(String nsdInfoId) {
            this.nsdInfoId = nsdInfoId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetSolNetworkInstanceResponse build() {
            return new GetSolNetworkInstanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
