/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutSolFunctionPackageContentResponse extends TnbResponse implements
        ToCopyableBuilder<PutSolFunctionPackageContentResponse.Builder, PutSolFunctionPackageContentResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(PutSolFunctionPackageContentResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<PutSolFunctionPackageContentMetadata> METADATA_FIELD = SdkField
            .<PutSolFunctionPackageContentMetadata> builder(MarshallingType.SDK_POJO).memberName("metadata")
            .getter(getter(PutSolFunctionPackageContentResponse::metadata)).setter(setter(Builder::metadata))
            .constructor(PutSolFunctionPackageContentMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final SdkField<String> VNF_PRODUCT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vnfProductName").getter(getter(PutSolFunctionPackageContentResponse::vnfProductName))
            .setter(setter(Builder::vnfProductName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfProductName").build()).build();

    private static final SdkField<String> VNF_PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vnfProvider").getter(getter(PutSolFunctionPackageContentResponse::vnfProvider))
            .setter(setter(Builder::vnfProvider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfProvider").build()).build();

    private static final SdkField<String> VNFD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("vnfdId")
            .getter(getter(PutSolFunctionPackageContentResponse::vnfdId)).setter(setter(Builder::vnfdId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfdId").build()).build();

    private static final SdkField<String> VNFD_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vnfdVersion").getter(getter(PutSolFunctionPackageContentResponse::vnfdVersion))
            .setter(setter(Builder::vnfdVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfdVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, METADATA_FIELD,
            VNF_PRODUCT_NAME_FIELD, VNF_PROVIDER_FIELD, VNFD_ID_FIELD, VNFD_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final PutSolFunctionPackageContentMetadata metadata;

    private final String vnfProductName;

    private final String vnfProvider;

    private final String vnfdId;

    private final String vnfdVersion;

    private PutSolFunctionPackageContentResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.metadata = builder.metadata;
        this.vnfProductName = builder.vnfProductName;
        this.vnfProvider = builder.vnfProvider;
        this.vnfdId = builder.vnfdId;
        this.vnfdVersion = builder.vnfdVersion;
    }

    /**
     * <p>
     * Function package ID.
     * </p>
     * 
     * @return Function package ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Function package metadata.
     * </p>
     * 
     * @return Function package metadata.
     */
    public final PutSolFunctionPackageContentMetadata metadata() {
        return metadata;
    }

    /**
     * <p>
     * Function product name.
     * </p>
     * 
     * @return Function product name.
     */
    public final String vnfProductName() {
        return vnfProductName;
    }

    /**
     * <p>
     * Function provider.
     * </p>
     * 
     * @return Function provider.
     */
    public final String vnfProvider() {
        return vnfProvider;
    }

    /**
     * <p>
     * Function package descriptor ID.
     * </p>
     * 
     * @return Function package descriptor ID.
     */
    public final String vnfdId() {
        return vnfdId;
    }

    /**
     * <p>
     * Function package descriptor version.
     * </p>
     * 
     * @return Function package descriptor version.
     */
    public final String vnfdVersion() {
        return vnfdVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(vnfProductName());
        hashCode = 31 * hashCode + Objects.hashCode(vnfProvider());
        hashCode = 31 * hashCode + Objects.hashCode(vnfdId());
        hashCode = 31 * hashCode + Objects.hashCode(vnfdVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSolFunctionPackageContentResponse)) {
            return false;
        }
        PutSolFunctionPackageContentResponse other = (PutSolFunctionPackageContentResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(metadata(), other.metadata())
                && Objects.equals(vnfProductName(), other.vnfProductName()) && Objects.equals(vnfProvider(), other.vnfProvider())
                && Objects.equals(vnfdId(), other.vnfdId()) && Objects.equals(vnfdVersion(), other.vnfdVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutSolFunctionPackageContentResponse").add("Id", id()).add("Metadata", metadata())
                .add("VnfProductName", vnfProductName()).add("VnfProvider", vnfProvider()).add("VnfdId", vnfdId())
                .add("VnfdVersion", vnfdVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "vnfProductName":
            return Optional.ofNullable(clazz.cast(vnfProductName()));
        case "vnfProvider":
            return Optional.ofNullable(clazz.cast(vnfProvider()));
        case "vnfdId":
            return Optional.ofNullable(clazz.cast(vnfdId()));
        case "vnfdVersion":
            return Optional.ofNullable(clazz.cast(vnfdVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("metadata", METADATA_FIELD);
        map.put("vnfProductName", VNF_PRODUCT_NAME_FIELD);
        map.put("vnfProvider", VNF_PROVIDER_FIELD);
        map.put("vnfdId", VNFD_ID_FIELD);
        map.put("vnfdVersion", VNFD_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutSolFunctionPackageContentResponse, T> g) {
        return obj -> g.apply((PutSolFunctionPackageContentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TnbResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutSolFunctionPackageContentResponse> {
        /**
         * <p>
         * Function package ID.
         * </p>
         * 
         * @param id
         *        Function package ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Function package metadata.
         * </p>
         * 
         * @param metadata
         *        Function package metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(PutSolFunctionPackageContentMetadata metadata);

        /**
         * <p>
         * Function package metadata.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PutSolFunctionPackageContentMetadata.Builder} avoiding the need to create one manually via
         * {@link PutSolFunctionPackageContentMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PutSolFunctionPackageContentMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #metadata(PutSolFunctionPackageContentMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link PutSolFunctionPackageContentMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(PutSolFunctionPackageContentMetadata)
         */
        default Builder metadata(Consumer<PutSolFunctionPackageContentMetadata.Builder> metadata) {
            return metadata(PutSolFunctionPackageContentMetadata.builder().applyMutation(metadata).build());
        }

        /**
         * <p>
         * Function product name.
         * </p>
         * 
         * @param vnfProductName
         *        Function product name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfProductName(String vnfProductName);

        /**
         * <p>
         * Function provider.
         * </p>
         * 
         * @param vnfProvider
         *        Function provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfProvider(String vnfProvider);

        /**
         * <p>
         * Function package descriptor ID.
         * </p>
         * 
         * @param vnfdId
         *        Function package descriptor ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfdId(String vnfdId);

        /**
         * <p>
         * Function package descriptor version.
         * </p>
         * 
         * @param vnfdVersion
         *        Function package descriptor version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfdVersion(String vnfdVersion);
    }

    static final class BuilderImpl extends TnbResponse.BuilderImpl implements Builder {
        private String id;

        private PutSolFunctionPackageContentMetadata metadata;

        private String vnfProductName;

        private String vnfProvider;

        private String vnfdId;

        private String vnfdVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSolFunctionPackageContentResponse model) {
            super(model);
            id(model.id);
            metadata(model.metadata);
            vnfProductName(model.vnfProductName);
            vnfProvider(model.vnfProvider);
            vnfdId(model.vnfdId);
            vnfdVersion(model.vnfdVersion);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final PutSolFunctionPackageContentMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(PutSolFunctionPackageContentMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(PutSolFunctionPackageContentMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getVnfProductName() {
            return vnfProductName;
        }

        public final void setVnfProductName(String vnfProductName) {
            this.vnfProductName = vnfProductName;
        }

        @Override
        public final Builder vnfProductName(String vnfProductName) {
            this.vnfProductName = vnfProductName;
            return this;
        }

        public final String getVnfProvider() {
            return vnfProvider;
        }

        public final void setVnfProvider(String vnfProvider) {
            this.vnfProvider = vnfProvider;
        }

        @Override
        public final Builder vnfProvider(String vnfProvider) {
            this.vnfProvider = vnfProvider;
            return this;
        }

        public final String getVnfdId() {
            return vnfdId;
        }

        public final void setVnfdId(String vnfdId) {
            this.vnfdId = vnfdId;
        }

        @Override
        public final Builder vnfdId(String vnfdId) {
            this.vnfdId = vnfdId;
            return this;
        }

        public final String getVnfdVersion() {
            return vnfdVersion;
        }

        public final void setVnfdVersion(String vnfdVersion) {
            this.vnfdVersion = vnfdVersion;
        }

        @Override
        public final Builder vnfdVersion(String vnfdVersion) {
            this.vnfdVersion = vnfdVersion;
            return this;
        }

        @Override
        public PutSolFunctionPackageContentResponse build() {
            return new PutSolFunctionPackageContentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
