/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.trustedadvisor;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.services.trustedadvisor.endpoints.TrustedAdvisorEndpointProvider;

/**
 * Internal implementation of {@link TrustedAdvisorAsyncClientBuilder}.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultTrustedAdvisorAsyncClientBuilder extends
        DefaultTrustedAdvisorBaseClientBuilder<TrustedAdvisorAsyncClientBuilder, TrustedAdvisorAsyncClient> implements
        TrustedAdvisorAsyncClientBuilder {
    @Override
    public DefaultTrustedAdvisorAsyncClientBuilder endpointProvider(TrustedAdvisorEndpointProvider endpointProvider) {
        clientConfiguration.option(SdkClientOption.ENDPOINT_PROVIDER, endpointProvider);
        return this;
    }

    @Override
    protected final TrustedAdvisorAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        this.validateClientOptions(clientConfiguration);
        TrustedAdvisorAsyncClient client = new DefaultTrustedAdvisorAsyncClient(clientConfiguration);
        return client;
    }
}
