/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.trustedadvisor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOrganizationRecommendationAccountsRequest extends TrustedAdvisorRequest implements
        ToCopyableBuilder<ListOrganizationRecommendationAccountsRequest.Builder, ListOrganizationRecommendationAccountsRequest> {
    private static final SdkField<String> AFFECTED_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("affectedAccountId").getter(getter(ListOrganizationRecommendationAccountsRequest::affectedAccountId))
            .setter(setter(Builder::affectedAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("affectedAccountId").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListOrganizationRecommendationAccountsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListOrganizationRecommendationAccountsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> ORGANIZATION_RECOMMENDATION_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("organizationRecommendationIdentifier")
            .getter(getter(ListOrganizationRecommendationAccountsRequest::organizationRecommendationIdentifier))
            .setter(setter(Builder::organizationRecommendationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("organizationRecommendationIdentifier")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFFECTED_ACCOUNT_ID_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, ORGANIZATION_RECOMMENDATION_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String affectedAccountId;

    private final Integer maxResults;

    private final String nextToken;

    private final String organizationRecommendationIdentifier;

    private ListOrganizationRecommendationAccountsRequest(BuilderImpl builder) {
        super(builder);
        this.affectedAccountId = builder.affectedAccountId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.organizationRecommendationIdentifier = builder.organizationRecommendationIdentifier;
    }

    /**
     * <p>
     * An account affected by this organization recommendation
     * </p>
     * 
     * @return An account affected by this organization recommendation
     */
    public final String affectedAccountId() {
        return affectedAccountId;
    }

    /**
     * <p>
     * The maximum number of results to return per page.
     * </p>
     * 
     * @return The maximum number of results to return per page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The Recommendation identifier
     * </p>
     * 
     * @return The Recommendation identifier
     */
    public final String organizationRecommendationIdentifier() {
        return organizationRecommendationIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(affectedAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(organizationRecommendationIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOrganizationRecommendationAccountsRequest)) {
            return false;
        }
        ListOrganizationRecommendationAccountsRequest other = (ListOrganizationRecommendationAccountsRequest) obj;
        return Objects.equals(affectedAccountId(), other.affectedAccountId()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(organizationRecommendationIdentifier(), other.organizationRecommendationIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListOrganizationRecommendationAccountsRequest").add("AffectedAccountId", affectedAccountId())
                .add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("OrganizationRecommendationIdentifier", organizationRecommendationIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "affectedAccountId":
            return Optional.ofNullable(clazz.cast(affectedAccountId()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "organizationRecommendationIdentifier":
            return Optional.ofNullable(clazz.cast(organizationRecommendationIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("affectedAccountId", AFFECTED_ACCOUNT_ID_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("organizationRecommendationIdentifier", ORGANIZATION_RECOMMENDATION_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListOrganizationRecommendationAccountsRequest, T> g) {
        return obj -> g.apply((ListOrganizationRecommendationAccountsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TrustedAdvisorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListOrganizationRecommendationAccountsRequest> {
        /**
         * <p>
         * An account affected by this organization recommendation
         * </p>
         * 
         * @param affectedAccountId
         *        An account affected by this organization recommendation
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder affectedAccountId(String affectedAccountId);

        /**
         * <p>
         * The maximum number of results to return per page.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The Recommendation identifier
         * </p>
         * 
         * @param organizationRecommendationIdentifier
         *        The Recommendation identifier
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationRecommendationIdentifier(String organizationRecommendationIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TrustedAdvisorRequest.BuilderImpl implements Builder {
        private String affectedAccountId;

        private Integer maxResults;

        private String nextToken;

        private String organizationRecommendationIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOrganizationRecommendationAccountsRequest model) {
            super(model);
            affectedAccountId(model.affectedAccountId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            organizationRecommendationIdentifier(model.organizationRecommendationIdentifier);
        }

        public final String getAffectedAccountId() {
            return affectedAccountId;
        }

        public final void setAffectedAccountId(String affectedAccountId) {
            this.affectedAccountId = affectedAccountId;
        }

        @Override
        public final Builder affectedAccountId(String affectedAccountId) {
            this.affectedAccountId = affectedAccountId;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getOrganizationRecommendationIdentifier() {
            return organizationRecommendationIdentifier;
        }

        public final void setOrganizationRecommendationIdentifier(String organizationRecommendationIdentifier) {
            this.organizationRecommendationIdentifier = organizationRecommendationIdentifier;
        }

        @Override
        public final Builder organizationRecommendationIdentifier(String organizationRecommendationIdentifier) {
            this.organizationRecommendationIdentifier = organizationRecommendationIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListOrganizationRecommendationAccountsRequest build() {
            return new ListOrganizationRecommendationAccountsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
